/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.emf.dt.editors.fields;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class FormTextField {
    private final FormText label;
    private final Text text;

    public FormTextField(FormToolkit toolkit, Composite sectionClient, String labelText, String defaultValue) {
        this(toolkit, sectionClient, labelText, defaultValue, 2112);
    }

    public FormTextField(FormToolkit toolkit, Composite sectionClient, String labelText, String defaultValue, int textStyle) {
        this.label = toolkit.createFormText(sectionClient, true);
        this.label.setText("<form><p>" + labelText + "</p></form>", true, false);
        this.label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        TableWrapData layoutData = new TableWrapData();
        layoutData.valign = 32;
        this.label.setLayoutData((Object)layoutData);
        this.text = toolkit.createText(sectionClient, defaultValue, textStyle | 0x40);
        this.text.setLayoutData((Object)new TableWrapData(256));
    }

    public Text getText() {
        return this.text;
    }

    public void setTextWithoutListener(String newText, ModifyListener disabledListener) {
        this.text.removeModifyListener(disabledListener);
        this.text.setText(newText);
        this.text.addModifyListener(disabledListener);
    }

    public FormText getLabel() {
        return this.label;
    }
}

