/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc.optimisation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.dom.AndOperatorExpression;
import org.eclipse.epsilon.eol.dom.EqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.GreaterEqualOperatorExpression;
import org.eclipse.epsilon.eol.dom.GreaterThanOperatorExpression;
import org.eclipse.epsilon.eol.dom.ImpliesOperatorExpression;
import org.eclipse.epsilon.eol.dom.LessEqualOperatorExpression;
import org.eclipse.epsilon.eol.dom.LessThanOperatorExpression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.NotEqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.NotOperatorExpression;
import org.eclipse.epsilon.eol.dom.OperatorExpression;
import org.eclipse.epsilon.eol.dom.OrOperatorExpression;
import org.eclipse.epsilon.eol.dom.PropertyCallExpression;
import org.eclipse.epsilon.eol.dom.XorOperatorExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.operations.declarative.SelectOperation;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.util.Utils;
import org.eclipse.hawk.epsilon.emc.AbstractHawkModel;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.optimisation.OptimisableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimisableCollectionSelectOperation
extends SelectOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptimisableCollectionSelectOperation.class);
    protected EOLQueryEngine model;
    private IEolContext context;
    private boolean returnOnFirstMatch;
    private Variable iterator;
    IGraphNode metaclass;
    IGraphDatabase graph = null;

    public Object execute(Object target, Variable iterator, Expression ast, IEolContext context, boolean returnOnFirstMatch) throws EolRuntimeException {
        try {
            this.context = context;
            this.returnOnFirstMatch = false;
            this.iterator = iterator;
            this.model = (EOLQueryEngine)((OptimisableCollection)target).getModel();
            this.graph = this.model.getBackend();
            Throwable throwable = null;
            Object var7_9 = null;
            try (IGraphTransaction ignored = this.graph.beginTransaction();){
                this.metaclass = ((OptimisableCollection)target).type.getNode();
                ignored.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return this.decomposeAST(target, ast);
        }
        catch (Exception e) {
            throw new EolRuntimeException("select(...) failed: " + e.getMessage(), (ModuleElement)ast);
        }
    }

    protected Collection<Object> decomposeAST(Object target, Expression ast) throws Exception {
        if (ast instanceof AndOperatorExpression) {
            return this.and(target, (AndOperatorExpression)ast);
        }
        if (ast instanceof OrOperatorExpression) {
            return this.or(target, (OrOperatorExpression)ast);
        }
        if (ast instanceof XorOperatorExpression) {
            return this.xor(target, (XorOperatorExpression)ast);
        }
        if (ast instanceof ImpliesOperatorExpression) {
            return this.implies(target, (ImpliesOperatorExpression)ast);
        }
        if (ast instanceof NotOperatorExpression) {
            return this.not(target, (NotOperatorExpression)ast);
        }
        if (this.isOptimisable(ast)) {
            return this.optimisedExecution(target, ast);
        }
        Object ret = super.execute(target, this.iterator, ast, this.context, this.returnOnFirstMatch);
        return (Collection)ret;
    }

    private Collection<Object> implies(Object target, ImpliesOperatorExpression ast) throws Exception {
        Expression lOperand = ast.getFirstOperand();
        Expression rOperand = ast.getSecondOperand();
        boolean lOptimisable = this.isOptimisable(lOperand);
        boolean rOptimisable = this.isOptimisable(rOperand);
        HashSet<Object> filter = new HashSet<Object>();
        filter.addAll((Collection)target);
        if (lOptimisable && rOptimisable) {
            Collection<Object> aa = this.optimisedExecution(target, lOperand);
            Collection<Object> bb = this.optimisedExecution(target, rOperand);
            filter.removeAll(aa);
            filter.addAll(bb);
            return filter;
        }
        if (lOptimisable) {
            Collection<Object> lhsResult = this.optimisedExecution(target, lOperand);
            lhsResult.removeAll(this.decomposeAST(lhsResult, rOperand));
            filter.removeAll(lhsResult);
            return filter;
        }
        if (rOptimisable) {
            Collection<Object> rhsResult = this.optimisedExecution(target, rOperand);
            HashSet notb = new HashSet((Collection)target);
            notb.removeAll(rhsResult);
            filter.removeAll(this.decomposeAST(notb, lOperand));
            return filter;
        }
        Collection<Object> aa = this.decomposeAST(target, lOperand);
        Collection<Object> bb = this.decomposeAST(target, rOperand);
        filter.removeAll(aa);
        filter.addAll(bb);
        return filter;
    }

    private Collection<Object> not(Object target, NotOperatorExpression ast) throws Exception {
        HashSet<Object> filter = new HashSet<Object>((Collection)target);
        Expression operand = ast.getFirstOperand();
        if (this.isOptimisable(operand)) {
            filter.removeAll(this.optimisedExecution(target, operand));
        } else {
            filter.removeAll(this.decomposeAST(target, operand));
        }
        return filter;
    }

    private Collection<Object> xor(Object target, XorOperatorExpression ast) throws Exception {
        HashSet<Object> filter = new HashSet<Object>();
        Collection<Object> a = null;
        Collection<Object> b = null;
        Expression lOperand = ast.getFirstOperand();
        Expression rOperand = ast.getSecondOperand();
        if (this.isOptimisable(lOperand) && this.isOptimisable(rOperand)) {
            a = this.optimisedExecution(target, lOperand);
            b = this.optimisedExecution(target, rOperand);
        } else {
            a = this.decomposeAST(target, lOperand);
            b = this.decomposeAST(target, rOperand);
        }
        filter.addAll(a);
        filter.addAll(b);
        a.retainAll(b);
        filter.removeAll(a);
        return filter;
    }

    private Collection<Object> or(Object target, OrOperatorExpression ast) throws Exception {
        Expression lOperand = ast.getFirstOperand();
        Expression rOperand = ast.getSecondOperand();
        HashSet<Object> filter = new HashSet<Object>();
        if (this.isOptimisable(lOperand) && this.isOptimisable(rOperand)) {
            filter.addAll(this.optimisedExecution(target, lOperand));
            filter.addAll(this.optimisedExecution(target, rOperand));
        } else {
            filter.addAll(this.decomposeAST(target, lOperand));
            filter.addAll(this.decomposeAST(target, rOperand));
        }
        return filter;
    }

    private Collection<Object> and(Object target, AndOperatorExpression ast) throws Exception {
        Expression lOperand = ast.getFirstOperand();
        Expression rOperand = ast.getSecondOperand();
        boolean lOptimisable = this.isOptimisable(lOperand);
        boolean rOptimisable = this.isOptimisable(rOperand);
        HashSet<Object> filter = new HashSet<Object>();
        if (lOptimisable && rOptimisable) {
            filter.addAll(this.optimisedExecution(this.optimisedExecution(target, lOperand), rOperand));
        } else if (lOptimisable) {
            filter.addAll(this.decomposeAST(this.optimisedExecution(target, lOperand), rOperand));
        } else if (rOptimisable) {
            filter.addAll(this.decomposeAST(this.optimisedExecution(target, rOperand), lOperand));
        } else {
            filter.addAll(this.decomposeAST(this.decomposeAST(target, lOperand), rOperand));
        }
        return filter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<Object> optimisedExecution(Object target, Expression ast) throws EolRuntimeException {
        String indexname;
        OperatorExpression opExp = (OperatorExpression)ast;
        PropertyCallExpression lOperand = (PropertyCallExpression)opExp.getFirstOperand();
        String attributename = lOperand.getName();
        String variableName = ((NameExpression)lOperand.getTargetExpression()).getName();
        Expression valueAST = opExp.getSecondOperand();
        Object attributevalue = null;
        try {
            attributevalue = this.context.getExecutorFactory().execute((ModuleElement)valueAST, this.context);
        }
        catch (Exception e) {
            LOGGER.warn("Warning: the RHS of the expression:\n{}\ncannot be evaluated using database indexing,\nas the iterator variable of the current select operation ({}) is not used in this process.\nDefaulting to Epsilon's select", (Object)ast, (Object)this.iterator.getName());
        }
        if (attributevalue == null || (indexname = this.isIndexed(attributename)) == null) return (Collection)super.execute(target, this.iterator, ast, this.context, this.returnOnFirstMatch);
        if (!(attributevalue instanceof Collection)) {
            attributevalue = AbstractHawkModel.toPrimitive(attributevalue);
        } else {
            Collection cRet = (Collection)attributevalue;
            Object[] aRet = new Object[cRet.size()];
            int count = 0;
            Iterator it = cRet.iterator();
            while (it.hasNext()) {
                aRet[count] = AbstractHawkModel.toPrimitive(it.next());
                ++count;
            }
            attributevalue = Arrays.toString(aRet);
        }
        HashSet<Object> result = new HashSet<Object>((Collection)target);
        System.err.println(String.format("indexed ast found: %s.%s %s %s (type: %s)", variableName, attributename, ast.getClass().getName(), new Utils().toString(attributevalue), attributevalue.getClass().getName()));
        HashSet<EOLQueryEngine.GraphNodeWrapper> filter = new HashSet<EOLQueryEngine.GraphNodeWrapper>();
        try {
            Throwable count = null;
            Object var13_17 = null;
            try (IGraphTransaction ignored = this.graph.beginTransaction();){
                IGraphNodeIndex index = this.graph.getOrCreateNodeIndex(indexname);
                IGraphIterable hits = null;
                if (ast instanceof EqualsOperatorExpression && !(ast instanceof NotEqualsOperatorExpression)) {
                    hits = attributevalue instanceof Integer ? index.query(attributename, (Number)((Integer)attributevalue), (Number)((Integer)attributevalue), true, true) : (attributevalue instanceof Long ? index.query(attributename, (Number)((Long)attributevalue), (Number)((Long)attributevalue), true, true) : (attributevalue instanceof Double ? index.query(attributename, (Number)((Double)attributevalue), (Number)((Double)attributevalue), true, true) : index.get(attributename, attributevalue)));
                } else if (ast instanceof GreaterEqualOperatorExpression) {
                    if (attributevalue instanceof Integer) {
                        hits = index.query(attributename, (Number)((Integer)attributevalue), (Number)Integer.MAX_VALUE, true, true);
                    } else if (attributevalue instanceof Long) {
                        hits = index.query(attributename, (Number)((Long)attributevalue), (Number)Long.MAX_VALUE, true, true);
                    } else {
                        if (!(attributevalue instanceof Double)) throw new EolRuntimeException(">= used with a non numeric value (" + attributevalue.getClass() + ")");
                        hits = index.query(attributename, (Number)((Double)attributevalue), (Number)Double.MAX_VALUE, true, true);
                    }
                } else if (ast instanceof GreaterThanOperatorExpression) {
                    if (attributevalue instanceof Integer) {
                        hits = index.query(attributename, (Number)((Integer)attributevalue), (Number)Integer.MAX_VALUE, false, true);
                    } else if (attributevalue instanceof Long) {
                        hits = index.query(attributename, (Number)((Long)attributevalue), (Number)Long.MAX_VALUE, false, true);
                    } else {
                        if (!(attributevalue instanceof Double)) throw new EolRuntimeException("> used with a non numeric value (" + attributevalue.getClass() + ")");
                        hits = index.query(attributename, (Number)((Double)attributevalue), (Number)Double.MAX_VALUE, false, true);
                    }
                } else if (ast instanceof LessEqualOperatorExpression) {
                    if (attributevalue instanceof Integer) {
                        hits = index.query(attributename, (Number)Integer.MIN_VALUE, (Number)((Integer)attributevalue), true, true);
                    } else if (attributevalue instanceof Long) {
                        hits = index.query(attributename, (Number)Long.MIN_VALUE, (Number)((Long)attributevalue), true, true);
                    } else {
                        if (!(attributevalue instanceof Double)) throw new EolRuntimeException("<= used with a non numeric value (" + attributevalue.getClass() + ")");
                        hits = index.query(attributename, (Number)Double.MIN_VALUE, (Number)((Double)attributevalue), true, true);
                    }
                } else if (ast instanceof LessThanOperatorExpression) {
                    if (attributevalue instanceof Integer) {
                        hits = index.query(attributename, (Number)Integer.MIN_VALUE, (Number)((Integer)attributevalue), true, false);
                    } else if (attributevalue instanceof Long) {
                        hits = index.query(attributename, (Number)Long.MIN_VALUE, (Number)((Long)attributevalue), true, false);
                    } else {
                        if (!(attributevalue instanceof Double)) throw new EolRuntimeException("< used with a non numeric value (" + attributevalue.getClass() + ")");
                        hits = index.query(attributename, (Number)Double.MIN_VALUE, (Number)((Double)attributevalue), true, false);
                    }
                }
                for (IGraphNode hit : hits) {
                    filter.add(this.model.wrap(hit));
                }
                ignored.success();
            }
            catch (Throwable throwable) {
                if (count == null) {
                    count = throwable;
                    throw count;
                } else {
                    if (count == throwable) throw count;
                    count.addSuppressed(throwable);
                }
                throw count;
            }
        }
        catch (Exception e) {
            throw new EolRuntimeException("select optimisation failed: " + e.getMessage(), (ModuleElement)ast);
        }
        result.retainAll(filter);
        return result;
    }

    private boolean isOptimisable(Expression ast) {
        block9: {
            Expression rawTargetExpression;
            block8: {
                Expression rawLOperand;
                block7: {
                    block6: {
                        try {
                            if (ast instanceof OperatorExpression) break block6;
                            return false;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    OperatorExpression opExp = (OperatorExpression)ast;
                    rawLOperand = opExp.getFirstOperand();
                    if (rawLOperand instanceof PropertyCallExpression) break block7;
                    return false;
                }
                PropertyCallExpression lOperand = (PropertyCallExpression)rawLOperand;
                rawTargetExpression = lOperand.getTargetExpression();
                if (lOperand.getTargetExpression() instanceof NameExpression) break block8;
                return false;
            }
            NameExpression nameExpression = (NameExpression)rawTargetExpression;
            if (this.iterator.getName().equals(nameExpression.getName())) break block9;
            return false;
        }
        return ast instanceof EqualsOperatorExpression && !(ast instanceof NotEqualsOperatorExpression) || ast instanceof GreaterThanOperatorExpression || ast instanceof LessThanOperatorExpression || ast instanceof NotEqualsOperatorExpression || ast instanceof GreaterEqualOperatorExpression || ast instanceof LessEqualOperatorExpression;
    }

    private String isIndexed(String attributename) {
        String result = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (IGraphTransaction ignored = this.graph.beginTransaction();){
                String indexname = ((IGraphEdge)this.metaclass.getOutgoingWithType("epackage").iterator().next()).getEndNode().getProperty("_hawkid") + "##" + this.metaclass.getProperty("_hawkid") + "##" + attributename;
                if (this.graph.nodeIndexExists(indexname)) {
                    result = indexname;
                }
                ignored.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Suppressed exception from isIndexed", (Throwable)e);
        }
        return result;
    }
}

