/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.osgiserver;

import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.hawk.core.ICredentialsStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SecurePreferencesCredentialsStore
implements ICredentialsStore {
    private static final String PASSWORD_SUFFIX = ".password";
    private static final String USERNAME_SUFFIX = ".username";
    private ISecurePreferences preferences;

    public void put(String repositoryKey, ICredentialsStore.Credentials creds) throws Exception {
        this.checkOpen();
        String encodedPrefix = EncodingUtils.encodeSlashes((String)repositoryKey);
        this.preferences.put(String.valueOf(encodedPrefix) + USERNAME_SUFFIX, creds.getUsername(), true);
        this.preferences.put(String.valueOf(encodedPrefix) + PASSWORD_SUFFIX, creds.getPassword(), true);
        this.preferences.flush();
    }

    public ICredentialsStore.Credentials get(String repositoryKey) throws Exception {
        this.checkOpen();
        String encodedPrefix = EncodingUtils.encodeSlashes((String)repositoryKey);
        String username = this.preferences.get(String.valueOf(encodedPrefix) + USERNAME_SUFFIX, null);
        String password = this.preferences.get(String.valueOf(encodedPrefix) + PASSWORD_SUFFIX, null);
        if (username != null && password != null) {
            return new ICredentialsStore.Credentials(username, password);
        }
        return null;
    }

    public void remove(String repositoryKey) throws Exception {
        this.checkOpen();
        String encodedPrefix = EncodingUtils.encodeSlashes((String)repositoryKey);
        this.preferences.remove(String.valueOf(encodedPrefix) + USERNAME_SUFFIX);
        this.preferences.remove(String.valueOf(encodedPrefix) + PASSWORD_SUFFIX);
    }

    public void shutdown() throws Exception {
        if (this.preferences != null) {
            this.preferences.flush();
        }
    }

    private void checkOpen() {
        if (this.preferences != null) {
            return;
        }
        Bundle bundle = FrameworkUtil.getBundle(SecurePreferencesCredentialsStore.class);
        this.preferences = SecurePreferencesFactory.getDefault().node(bundle.getSymbolicName());
    }
}

