/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.dialog;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.ui2.Activator;
import org.eclipse.hawk.ui2.dialog.HConfigDialog;
import org.eclipse.hawk.ui2.vcs.DefaultVcsConfigurationBlock;
import org.eclipse.hawk.ui2.vcs.IVcsConfigurationBlock;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HVCSDialog
extends TitleAreaDialog {
    private final IVcsManager managerToEdit;
    private final HModel hawkModel;
    private Button freeze;
    private ComboViewer cmbVCSType;
    private List<IVcsManager> availableVCS;
    private Composite cmpConfiguration;
    private IVcsConfigurationBlock configBlock;

    public HVCSDialog(Shell parentShell, HModel hawkModel, IVcsManager managerToEdit) {
        super(parentShell);
        this.hawkModel = hawkModel;
        this.managerToEdit = managerToEdit;
        this.availableVCS = hawkModel.getVCSInstances();
        Collections.sort(this.availableVCS, new Comparator<IVcsManager>(){

            @Override
            public int compare(IVcsManager o1, IVcsManager o2) {
                return o1.getHumanReadableName().compareTo(o2.getHumanReadableName());
            }
        });
    }

    public void create() {
        super.create();
        if (this.managerToEdit == null) {
            this.setTitle("Add repository");
            this.setMessage("Select the repository type and configure its options.");
        } else {
            this.setTitle("Edit repository");
            this.setMessage("Change the authentication credentials.");
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout containerLayout = new GridLayout();
        containerLayout.numColumns = 3;
        container.setLayout((Layout)containerLayout);
        Label lblType = new Label(container, 0);
        lblType.setText("Type:");
        this.cmbVCSType = new ComboViewer(container, 8);
        this.cmbVCSType.setLabelProvider((IBaseLabelProvider)new HConfigDialog.VCSLabelProvider());
        this.cmbVCSType.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cmbVCSType.setInput((Object)this.availableVCS.toArray());
        GridData cmbVCSTypeLayoutData = new GridData(4, 0x1000000, true, false);
        cmbVCSTypeLayoutData.horizontalSpan = 2;
        this.cmbVCSType.getCombo().setLayoutData((Object)cmbVCSTypeLayoutData);
        this.cmbVCSType.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HVCSDialog.this.updateConfigurationBlock();
            }
        });
        Label lblFreeze = new Label(container, 0);
        lblFreeze.setText("Freeze repo:");
        this.freeze = new Button(container, 32);
        boolean isFrozen = this.managerToEdit == null ? false : this.managerToEdit.isFrozen();
        this.freeze.setSelection(isFrozen);
        if (this.managerToEdit == null) {
            this.freeze.setEnabled(false);
        }
        this.cmpConfiguration = new Composite(container, 2052);
        GridData cmpConfigurationLD = new GridData(4, 0x1000000, true, false);
        cmpConfigurationLD.horizontalSpan = 3;
        this.cmpConfiguration.setLayoutData((Object)cmpConfigurationLD);
        if (this.managerToEdit != null) {
            String managerType = this.managerToEdit.getType();
            int i = 0;
            for (IVcsManager kind : this.availableVCS) {
                String availableType = kind.getType();
                if (availableType.equals(managerType)) {
                    this.cmbVCSType.getCombo().select(i);
                    break;
                }
                ++i;
            }
            this.cmbVCSType.getCombo().setEnabled(false);
        } else {
            this.cmbVCSType.getCombo().select(0);
        }
        this.updateConfigurationBlock();
        return container;
    }

    public IVcsManager getManagerToEdit() {
        return this.managerToEdit;
    }

    private void updateConfigurationBlock() {
        Control[] controlArray = this.cmpConfiguration.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.setErrorMessage(null);
        this.configBlock = this.getConfigurationBlockFor(this.getSelectedVCSManager());
        this.configBlock.createBlock(this.cmpConfiguration, this);
        this.cmpConfiguration.requestLayout();
    }

    public void setErrorMessage(String newErrorMessage) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(newErrorMessage == null);
        }
        super.setErrorMessage(newErrorMessage);
    }

    public IVcsManager getSelectedVCSManager() {
        IStructuredSelection selection = (IStructuredSelection)this.cmbVCSType.getSelection();
        return (IVcsManager)selection.getFirstElement();
    }

    protected void okPressed() {
        this.configBlock.okPressed(this.hawkModel, this.freeze.getSelection());
        super.okPressed();
    }

    private IVcsConfigurationBlock getConfigurationBlockFor(IVcsManager manager) {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hawk.ui.vcsConfigBlock");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                IVcsConfigurationBlock selector = (IVcsConfigurationBlock)e.createExecutableExtension("class");
                if (selector.isApplicableTo(manager)) {
                    return selector;
                }
            }
            catch (CoreException ex) {
                Activator.logError("Could not create the config block for " + manager.getHumanReadableName(), ex);
            }
            ++n2;
        }
        return new DefaultVcsConfigurationBlock();
    }
}

