/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.preferences;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.hawk.core.IHawkPlugin;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.ui2.preferences.HawkPluginSelectionBlock;
import org.eclipse.hawk.ui2.util.HUIManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class HawkInstancePluginConfigurationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo combo;
    private HawkPluginSelectionBlock pluginBlock;

    public HawkInstancePluginConfigurationPreferencePage() {
        super("Instance Configuration");
        this.setDescription("You may enable plugins but not disable them");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.combo = new Combo(parent, 8);
        this.combo.setLayoutData((Object)gd);
        Set hawks = HUIManager.getInstance().getHawks();
        for (HModel db : hawks) {
            this.combo.add(db.getName());
        }
        if (!hawks.isEmpty()) {
            this.combo.select(0);
        }
        this.pluginBlock = new HawkPluginSelectionBlock();
        this.pluginBlock.createControl(parent);
        this.pluginBlock.getMetamodelTableViewer().setCheckStateProvider((ICheckStateProvider)new TypedCheckStateProvider());
        this.pluginBlock.getGraphChangeListenerTableViewer().setCheckStateProvider((ICheckStateProvider)new TypedCheckStateProvider());
        this.pluginBlock.getModelTableViewer().setCheckStateProvider((ICheckStateProvider)new TypedCheckStateProvider());
        this.pluginBlock.getQueryEngineTableViewer().setCheckStateProvider((ICheckStateProvider)new TypedCheckStateProvider());
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HawkInstancePluginConfigurationPreferencePage.this.updatePlugins();
            }
        });
        this.updatePlugins();
        return parent;
    }

    private void updatePlugins() {
        HModel hawkInstance = this.getSelectedHawkInstance();
        List plugins = hawkInstance == null ? Collections.emptyList() : hawkInstance.getManager().getAvailablePlugins();
        this.pluginBlock.update(plugins);
    }

    protected void performDefaults() {
        this.updatePlugins();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performApply() {
        try {
            HModel hawk = this.getSelectedHawkInstance();
            HashSet<String> selectablePlugins = new HashSet<String>(this.pluginBlock.getAllSelectable());
            HashSet<String> selectedPlugins = new HashSet<String>(this.pluginBlock.getAllChecked());
            Set enabledPlugins = hawk.getEnabledPlugins().stream().filter(p -> selectablePlugins.contains(p)).collect(Collectors.toSet());
            HashSet<String> toAdd = new HashSet<String>(selectedPlugins);
            toAdd.removeAll(enabledPlugins);
            HashSet toRemove = new HashSet(enabledPlugins);
            toRemove.removeAll(selectedPlugins);
            if (!toAdd.isEmpty() || !toRemove.isEmpty()) {
                hawk.addPlugins(toAdd);
                hawk.removePlugins(toRemove);
                HUIManager.getInstance().saveHawkToMetadata(hawk, true);
                this.updatePlugins();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HModel getSelectedHawkInstance() {
        int idx = this.combo.getSelectionIndex();
        if (idx == -1) {
            return null;
        }
        return HUIManager.getInstance().getHawkByName(this.combo.getItem(idx));
    }

    class TypedCheckStateProvider
    implements ICheckStateProvider {
        TypedCheckStateProvider() {
        }

        public boolean isGrayed(Object element) {
            return HawkInstancePluginConfigurationPreferencePage.this.getSelectedHawkInstance() == null;
        }

        public boolean isChecked(Object element) {
            HModel instance = HawkInstancePluginConfigurationPreferencePage.this.getSelectedHawkInstance();
            if (instance == null) {
                return false;
            }
            List enabledPlugins = instance.getEnabledPlugins();
            IHawkPlugin plugin = (IHawkPlugin)element;
            return enabledPlugins.contains(plugin.getType());
        }
    }
}

