/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.greycat.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SimpleCollector;

class IntervalCollector<T>
extends SimpleCollector {
    protected final List<Integer> docIds = new ArrayList<Integer>();
    protected final IndexSearcher searcher;
    private int docBase;
    private final String fieldFrom;
    private final String fieldTo;
    private Function<IndexableField, T> extractor;

    protected IntervalCollector(IndexSearcher searcher, String fieldFrom, String fieldTo, Function<IndexableField, T> extractor) {
        this.searcher = searcher;
        this.fieldFrom = fieldFrom;
        this.fieldTo = fieldTo;
        this.extractor = extractor;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docBase = context.docBase;
    }

    public boolean needsScores() {
        return false;
    }

    public void collect(int doc) {
        this.docIds.add(this.docBase + doc);
    }

    public List<Interval<T>> getValues() throws IOException {
        ArrayList<Interval<T>> result = new ArrayList<Interval<T>>();
        for (int docId : this.docIds) {
            Document document = this.searcher.doc(docId);
            T from = this.extractor.apply(document.getField(this.fieldFrom));
            T to = this.extractor.apply(document.getField(this.fieldTo));
            result.add(new Interval<T>(from, to));
        }
        return result;
    }

    public static final class Interval<T> {
        private final T from;
        private final T to;

        public Interval(T from, T to) {
            this.from = from;
            this.to = to;
        }

        public T getFrom() {
            return this.from;
        }

        public T getTo() {
            return this.to;
        }

        public String toString() {
            return "Interval [from=" + this.from + ", to=" + this.to + "]";
        }
    }
}

