/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.greycat.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SimpleCollector;

class ListCollector
extends SimpleCollector {
    protected final List<Integer> docIds = new ArrayList<Integer>();
    protected final IndexSearcher searcher;
    private int docBase;

    protected ListCollector(IndexSearcher searcher) {
        this.searcher = searcher;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docBase = context.docBase;
    }

    public boolean needsScores() {
        return false;
    }

    public void collect(int doc) {
        this.docIds.add(this.docBase + doc);
    }

    public List<Document> getDocuments() throws IOException {
        ArrayList<Document> result = new ArrayList<Document>();
        for (int docId : this.docIds) {
            Document document = this.searcher.doc(docId);
            result.add(document);
        }
        return result;
    }
}

