/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.metamodel;

import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkDataType;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.eclipse.hawk.modelio.exml.metamodel.AbstractModelioObject;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioPackage;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MDataType;

public class ModelioDataType
extends AbstractModelioObject
implements IHawkDataType {
    private final ModelioPackage mPackage;
    private final MDataType mDataType;

    public ModelioDataType(ModelioPackage pkg, MDataType mDataType) {
        this.mPackage = pkg;
        this.mDataType = mDataType;
    }

    public String getInstanceType() {
        String it = this.mDataType.getJavaEquivalent();
        String[] arrayString = it.split("\\.");
        if (arrayString.length > 0) {
            it = arrayString[arrayString.length - 1];
        }
        it = it == null ? "NULL_INSTANCE_TYPE" : it;
        return it;
    }

    public boolean isRoot() {
        return false;
    }

    public String getUri() {
        return String.valueOf(this.mPackage.getNsURI()) + "#" + this.getUriFragment();
    }

    public String getUriFragment() {
        return this.mDataType.getId();
    }

    public boolean isFragmentUnique() {
        return true;
    }

    public IHawkClassifier getType() {
        return this.mPackage.getResource().getMetaType();
    }

    public boolean isSet(IHawkStructuralFeature hsf) {
        switch (hsf.getName()) {
            case "name": {
                return true;
            }
        }
        return false;
    }

    public Object get(IHawkAttribute attr) {
        switch (attr.getName()) {
            case "name": {
                return this.mDataType.getName();
            }
        }
        return null;
    }

    public Object get(IHawkReference ref, boolean b) {
        return null;
    }

    public String getName() {
        return this.mDataType.getName();
    }

    public String getPackageNSURI() {
        return this.mPackage.getNsURI();
    }

    @Override
    public String getExml() {
        return this.mPackage.getExml();
    }

    public String toString() {
        return "ModelioDataType [getInstanceType()=" + this.getInstanceType() + ", getName()=" + this.getName() + "]";
    }
}

