/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.emf.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Table;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.http.auth.Credentials;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEStoreEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.hawk.emfresource.HawkResource;
import org.eclipse.hawk.emfresource.HawkResourceChangeListener;
import org.eclipse.hawk.emfresource.impl.HawkFileResourceImpl;
import org.eclipse.hawk.emfresource.util.LazyEObjectFactory;
import org.eclipse.hawk.emfresource.util.LazyResolver;
import org.eclipse.hawk.service.api.AttributeSlot;
import org.eclipse.hawk.service.api.ContainerSlot;
import org.eclipse.hawk.service.api.EffectiveMetamodelRuleset;
import org.eclipse.hawk.service.api.FailedQuery;
import org.eclipse.hawk.service.api.Hawk;
import org.eclipse.hawk.service.api.HawkAttributeRemovalEvent;
import org.eclipse.hawk.service.api.HawkAttributeUpdateEvent;
import org.eclipse.hawk.service.api.HawkChangeEvent;
import org.eclipse.hawk.service.api.HawkFileAdditionEvent;
import org.eclipse.hawk.service.api.HawkFileRemovalEvent;
import org.eclipse.hawk.service.api.HawkInstanceNotFound;
import org.eclipse.hawk.service.api.HawkInstanceNotRunning;
import org.eclipse.hawk.service.api.HawkModelElementAdditionEvent;
import org.eclipse.hawk.service.api.HawkModelElementRemovalEvent;
import org.eclipse.hawk.service.api.HawkQueryOptions;
import org.eclipse.hawk.service.api.HawkReferenceAdditionEvent;
import org.eclipse.hawk.service.api.HawkReferenceRemovalEvent;
import org.eclipse.hawk.service.api.HawkSynchronizationEndEvent;
import org.eclipse.hawk.service.api.HawkSynchronizationStartEvent;
import org.eclipse.hawk.service.api.InvalidQuery;
import org.eclipse.hawk.service.api.MixedReference;
import org.eclipse.hawk.service.api.ModelElement;
import org.eclipse.hawk.service.api.ModelElementType;
import org.eclipse.hawk.service.api.QueryResult;
import org.eclipse.hawk.service.api.ReferenceSlot;
import org.eclipse.hawk.service.api.Subscription;
import org.eclipse.hawk.service.api.SubscriptionDurability;
import org.eclipse.hawk.service.api.UnknownQueryLanguage;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.api.utils.ActiveMQBufferTransport;
import org.eclipse.hawk.service.artemis.consumer.Consumer;
import org.eclipse.hawk.service.emf.HawkModelDescriptor;
import org.eclipse.hawk.service.emf.impl.SlotDecodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawkResourceImpl
extends ResourceImpl
implements HawkResource {
    public static final String EOL_QUERY_LANG = "org.eclipse.hawk.epsilon.emc.EOLQueryEngine";
    private static final Logger LOGGER = LoggerFactory.getLogger(HawkResourceImpl.class);
    private final BiMap<String, EObject> nodeIdToEObjectMap = HashBiMap.create();
    private final Map<String, HawkFileResourceImpl> resources = new HashMap<String, HawkFileResourceImpl>();
    private HawkModelDescriptor descriptor;
    private Hawk.Client client;
    private Consumer subscriber;
    private LazyResolver lazyResolver;
    private LazyEObjectFactory eobFactory;
    private final Map<EClass, EList<EObject>> classToEObjectsMap = new HashMap<EClass, EList<EObject>>();
    private final Set<Runnable> syncEndListeners = new HashSet<Runnable>();
    private final Set<HawkResourceChangeListener> changeListeners = new HashSet<HawkResourceChangeListener>();

    private static EClass getEClass(String metamodelUri, String typeName, EPackage.Registry packageRegistry) {
        EPackage pkg = packageRegistry.getEPackage(metamodelUri);
        if (pkg == null) {
            throw new NoSuchElementException(String.format("Could not find EPackage with URI '%s' in the registry", metamodelUri));
        }
        EClassifier eClassifier = pkg.getEClassifier(typeName);
        if (!(eClassifier instanceof EClass)) {
            throw new NoSuchElementException(String.format("Received an element of type '%s', which is not an EClass", eClassifier));
        }
        EClass eClass = (EClass)eClassifier;
        return eClass;
    }

    public HawkResourceImpl() {
    }

    public HawkResourceImpl(URI uri, HawkModelDescriptor descriptor) {
        this(uri);
        this.descriptor = descriptor;
    }

    public HawkResourceImpl(URI uri) {
        super(uri);
    }

    public void load(Map<?, ?> options) throws IOException {
        if (this.descriptor != null) {
            this.doLoad(this.descriptor, (IProgressMonitor)new NullProgressMonitor());
        } else {
            super.load(options);
        }
    }

    public void save(Map<?, ?> options) throws IOException {
        this.doSave(null, null);
    }

    public HawkModelDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean hasChildren(EObject o) {
        for (EReference r : o.eClass().getEAllReferences()) {
            EList pending;
            if (!r.isContainment()) continue;
            if (this.lazyResolver != null && (pending = this.lazyResolver.getPending(o, r)) != null) {
                return !pending.isEmpty();
            }
            Object v = o.eGet((EStructuralFeature)r);
            if ((!r.isMany() || ((Collection)v).isEmpty()) && (r.isMany() || v == null)) continue;
            return true;
        }
        return false;
    }

    public void doLoad(HawkModelDescriptor descriptor, IProgressMonitor monitor) throws IOException {
        this.prepareResourceFactoryMap();
        try {
            this.descriptor = descriptor;
            monitor.subTask("Connecting to Hawk");
            Credentials lazyCreds = this.connect(descriptor);
            HawkModelDescriptor.LoadingMode mode = descriptor.getLoadingMode();
            HawkQueryOptions opts = new HawkQueryOptions();
            opts.setDefaultNamespaces(descriptor.getDefaultNamespaces());
            opts.setRepositoryPattern(descriptor.getHawkRepository());
            opts.setFilePatterns(Arrays.asList(descriptor.getHawkFilePatterns()));
            opts.setIncludeAttributes(mode.isGreedyAttributes() && !descriptor.isPaged());
            opts.setIncludeReferences(!descriptor.isPaged());
            opts.setIncludeNodeIDs(this.isIncludeNodeIDs(descriptor));
            opts.setIncludeContained(mode.isGreedyElements() && !descriptor.isPaged());
            this.setEffectiveMetamodelOptions(opts, descriptor.getEffectiveMetamodel());
            monitor.subTask("Performing initial fetch");
            List<ModelElement> elems = this.initialFetch(descriptor, mode, opts);
            this.resolveContents(descriptor, mode, elems, opts, monitor);
            if (descriptor.isSubscribed()) {
                monitor.subTask("Subscribing to Artemis");
                this.subscribeToChanges(descriptor, lazyCreds);
            }
            this.setLoaded(true);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
    }

    protected void prepareResourceFactoryMap() {
        Resource.Factory hawkResourceFactory = new Resource.Factory(){

            public Resource createResource(URI uri) {
                return new HawkFileResourceImpl(uri, (HawkResource)HawkResourceImpl.this);
            }
        };
        Map protocolToFactoryMap = this.getResourceSet().getResourceFactoryRegistry().getProtocolToFactoryMap();
        protocolToFactoryMap.put("hawkrepo+file", hawkResourceFactory);
        protocolToFactoryMap.put("hawkrepo+http", hawkResourceFactory);
        protocolToFactoryMap.put("hawkrepo+https", hawkResourceFactory);
        protocolToFactoryMap.put("hawkrepo+git", hawkResourceFactory);
        protocolToFactoryMap.put("hawkrepo+svn", hawkResourceFactory);
        protocolToFactoryMap.put("hawkrepo+svn+ssh", hawkResourceFactory);
    }

    protected Credentials connect(HawkModelDescriptor descriptor) throws TTransportException, URISyntaxException {
        String username = descriptor.getUsername();
        String password = descriptor.getPassword();
        Credentials lazyCreds = null;
        if (username != null && password != null && username.length() > 0 && password.length() > 0) {
            this.client = (Hawk.Client)APIUtils.connectTo(Hawk.Client.class, (String)descriptor.getHawkURL(), (APIUtils.ThriftProtocol)descriptor.getThriftProtocol(), (String)username, (String)password);
        } else {
            try {
                Class<?> lCredClass = Class.forName("org.eclipse.hawk.service.api.dt.http.LazyCredentials");
                lazyCreds = (Credentials)lCredClass.getConstructor(String.class).newInstance(descriptor.getHawkURL());
                this.client = (Hawk.Client)APIUtils.connectTo(Hawk.Client.class, (String)descriptor.getHawkURL(), (APIUtils.ThriftProtocol)descriptor.getThriftProtocol(), (Credentials)lazyCreds);
            }
            catch (Exception ex) {
                this.client = (Hawk.Client)APIUtils.connectTo(Hawk.Client.class, (String)descriptor.getHawkURL(), (APIUtils.ThriftProtocol)descriptor.getThriftProtocol());
            }
        }
        return lazyCreds;
    }

    protected List<ModelElement> initialFetch(HawkModelDescriptor descriptor, HawkModelDescriptor.LoadingMode mode, HawkQueryOptions opts) throws HawkInstanceNotFound, HawkInstanceNotRunning, UnknownQueryLanguage, InvalidQuery, FailedQuery, TException {
        List<Object> elems;
        boolean useQuery;
        String queryLanguage = descriptor.getHawkQueryLanguage();
        String query = descriptor.getHawkQuery();
        boolean bl = useQuery = queryLanguage != null && queryLanguage.length() > 0 && query != null && query.length() > 0;
        if (useQuery) {
            QueryResult results = this.client.query(descriptor.getHawkInstance(), query, queryLanguage, opts);
            if (!results.isSetVList()) {
                results = new QueryResult(QueryResult._Fields.V_LIST, Collections.singletonList(results));
            }
            elems = new ArrayList<ModelElement>();
            for (QueryResult result : results.getVList()) {
                if (!result.isSetVModelElement()) continue;
                elems.add(result.getVModelElement());
            }
        } else {
            elems = mode.isGreedyElements() ? this.client.getModel(descriptor.getHawkInstance(), opts) : this.client.getRootElements(descriptor.getHawkInstance(), opts);
        }
        return elems;
    }

    protected void resolveContents(HawkModelDescriptor descriptor, HawkModelDescriptor.LoadingMode mode, List<ModelElement> elems, HawkQueryOptions opts, IProgressMonitor monitor) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException, IOException {
        if (descriptor.isPaged()) {
            opts.setIncludeAttributes(true);
            opts.setIncludeReferences(true);
            int nElems = elems.size();
            int iRangeStart = 0;
            while (iRangeStart < nElems) {
                ArrayList<String> rangeIDs = new ArrayList<String>(descriptor.getPageSize());
                int iRangeEnd = Math.min(nElems, iRangeStart + descriptor.getPageSize());
                for (ModelElement elem : elems.subList(iRangeStart, iRangeEnd)) {
                    rangeIDs.add(elem.getId());
                }
                monitor.subTask(String.format("Fetching model elements %d-%d out of %d", iRangeStart, iRangeEnd, nElems));
                List batch = this.client.resolveProxies(descriptor.getHawkInstance(), rangeIDs, opts);
                TreeLoadingState state = new TreeLoadingState();
                this.createEObjectTree(batch, state);
                this.fillInReferences(batch, state);
                iRangeStart += descriptor.getPageSize();
            }
            if (mode.isGreedyElements()) {
                monitor.subTask("Revising object containment");
                for (EObject eob : this.getContents()) {
                    eob.eContainer();
                }
            }
        } else {
            monitor.subTask("Resolving contents");
            TreeLoadingState state = new TreeLoadingState();
            this.createEObjectTree(elems, state);
            this.fillInReferences(elems, state);
        }
    }

    protected void subscribeToChanges(HawkModelDescriptor descriptor, Credentials lazyCreds) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException, Exception, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ActiveMQException {
        SubscriptionDurability sd = descriptor.getSubscriptionDurability();
        Subscription subscription = this.client.watchModelChanges(descriptor.getHawkInstance(), descriptor.getHawkRepository(), Arrays.asList(descriptor.getHawkFilePatterns()), descriptor.getSubscriptionClientID(), sd);
        this.subscriber = APIUtils.connectToArtemis((Subscription)subscription, (SubscriptionDurability)sd);
        Principal fetchedUser = null;
        if (lazyCreds != null) {
            fetchedUser = (Principal)lazyCreds.getClass().getMethod("getRawUserPrincipal", new Class[0]).invoke((Object)lazyCreds, new Object[0]);
        }
        if (fetchedUser != null) {
            String fetchedPass = (String)lazyCreds.getClass().getMethod("getRawPassword", new Class[0]).invoke((Object)lazyCreds, new Object[0]);
            this.subscriber.openSession(fetchedUser.getName(), fetchedPass);
        } else {
            this.subscriber.openSession(descriptor.getUsername(), descriptor.getPassword());
        }
        this.subscriber.processChangesAsync((MessageHandler)new HawkResourceMessageHandler(descriptor.getThriftProtocol().getProtocolFactory()));
    }

    protected void setEffectiveMetamodelOptions(HawkQueryOptions opts, EffectiveMetamodelRuleset emm) {
        Table inclusionRules = emm.getInclusionRules();
        Table exclusionRules = emm.getExclusionRules();
        if (!inclusionRules.isEmpty()) {
            Map inclusionMap = inclusionRules.rowMap();
            opts.setEffectiveMetamodelIncludes(inclusionMap);
        }
        if (!exclusionRules.isEmpty()) {
            Map exclusionMap = exclusionRules.rowMap();
            opts.setEffectiveMetamodelExcludes(exclusionMap);
        }
    }

    protected boolean isIncludeNodeIDs(HawkModelDescriptor descriptor) {
        HawkModelDescriptor.LoadingMode lm = descriptor.getLoadingMode();
        return !lm.isGreedyElements() || !lm.isGreedyAttributes() || descriptor.isSubscribed() || descriptor.isPaged();
    }

    public EList<EObject> fetchNodes(List<String> ids, boolean mustFetchAttributes) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException, IOException {
        if (!this.isIncludeNodeIDs(this.getDescriptor())) {
            throw new IllegalArgumentException("Cannot fetch by ID: loading mode is " + (Object)((Object)this.descriptor.getLoadingMode()));
        }
        ArrayList<String> toBeFetched = new ArrayList<String>();
        for (String id : ids) {
            if (this.nodeIdToEObjectMap.containsKey((Object)id)) continue;
            toBeFetched.add(id);
        }
        if (!toBeFetched.isEmpty()) {
            HawkQueryOptions options = new HawkQueryOptions();
            options.setIncludeAttributes(this.descriptor.getLoadingMode().isGreedyAttributes() || mustFetchAttributes);
            options.setIncludeReferences(true);
            this.setEffectiveMetamodelOptions(options, this.descriptor.getEffectiveMetamodel());
            List elems = this.client.resolveProxies(this.descriptor.getHawkInstance(), toBeFetched, options);
            TreeLoadingState state = new TreeLoadingState();
            this.createEObjectTree(elems, state);
            this.fillInReferences(elems, state);
        }
        BasicEList finalList = new BasicEList(ids.size());
        for (String id : ids) {
            EObject eObject = (EObject)this.nodeIdToEObjectMap.get((Object)id);
            if (eObject == null) continue;
            finalList.add((Object)eObject);
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList<EObject> fetchNodes(EClass eClass, boolean includeAttributes) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException, IOException {
        Map<EClass, EList<EObject>> map = this.classToEObjectsMap;
        synchronized (map) {
            EList<EObject> precomputed = this.classToEObjectsMap.get(eClass);
            if (precomputed != null) {
                return precomputed;
            }
            if (!this.isIncludeNodeIDs(this.getDescriptor())) {
                BasicEList computed = new BasicEList();
                for (Resource r : this.getResourceSet().getResources()) {
                    TreeIterator itEob = r.getAllContents();
                    while (itEob.hasNext()) {
                        EObject eob = (EObject)itEob.next();
                        EClass ec = eob.eClass();
                        if (!eClass.isSuperTypeOf(ec)) continue;
                        computed.add((Object)eob);
                    }
                }
                this.classToEObjectsMap.put(eClass, (EList<EObject>)computed);
                return computed;
            }
            HawkQueryOptions opts = new HawkQueryOptions();
            opts.setDefaultNamespaces(eClass.getEPackage().getNsURI());
            opts.setRepositoryPattern(this.descriptor.getHawkRepository());
            opts.setFilePatterns(Arrays.asList(this.descriptor.getHawkFilePatterns()));
            opts.setIncludeAttributes(includeAttributes);
            this.setEffectiveMetamodelOptions(opts, this.descriptor.getEffectiveMetamodel());
            String query = String.format("return %s.all;", eClass.getName());
            EList<EObject> fetched = this.fetchByQuery(EOL_QUERY_LANG, query, opts);
            this.classToEObjectsMap.put(eClass, fetched);
            return fetched;
        }
    }

    public Object performRawQuery(String queryLanguage, String query, Map<String, Object> context) throws Exception {
        String sDefaultNamespaces;
        String sRepoPattern;
        HawkQueryOptions options = new HawkQueryOptions();
        String sFilePattern = (String)context.get("FILE");
        if (sFilePattern != null) {
            options.setFilePatterns(Arrays.asList(sFilePattern.split(",")));
        }
        if ((sRepoPattern = (String)context.get("REPOSITORY")) != null) {
            options.setRepositoryPattern(sRepoPattern);
        }
        if ((sDefaultNamespaces = (String)context.get("DEFAULTNAMESPACES")) != null) {
            options.setDefaultNamespaces(sDefaultNamespaces);
        }
        return this.client.query(this.descriptor.getHawkInstance(), query, queryLanguage, options);
    }

    public EList<EObject> fetchByQuery(String language, String query, HawkQueryOptions opts) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException, IOException {
        QueryResult typeInstanceIDs = this.client.query(this.descriptor.getHawkInstance(), query, language, opts);
        if (!typeInstanceIDs.isSetVList()) {
            typeInstanceIDs = new QueryResult(QueryResult._Fields.V_LIST, (Object)typeInstanceIDs);
        }
        return this.fetchNodesByQueryResults(typeInstanceIDs.getVList(), opts.includeAttributes);
    }

    protected EList<EObject> fetchNodesByQueryResults(List<QueryResult> typeInstanceIDs, boolean includeAttributes) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException, IOException {
        ArrayList<String> ids = new ArrayList<String>();
        for (QueryResult qr : typeInstanceIDs) {
            ids.add(qr.getVModelElement().getId());
        }
        EList<EObject> fetched = this.fetchNodes(ids, includeAttributes);
        return fetched;
    }

    public List<Object> fetchValuesByEClassifier(EClassifier dataType) throws HawkInstanceNotFound, HawkInstanceNotRunning, UnknownQueryLanguage, InvalidQuery, FailedQuery, TException, IOException {
        Map<EClass, List<EStructuralFeature>> candidateTypes = this.fetchTypesWithEClassifier(dataType);
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<EClass, List<EStructuralFeature>> entry : candidateTypes.entrySet()) {
            EClass eClass = entry.getKey();
            List<EStructuralFeature> featureWithType = entry.getValue();
            for (EObject eob : this.fetchNodes(eClass, true)) {
                for (EStructuralFeature attr : featureWithType) {
                    Object o = eob.eGet(attr);
                    if (o == null) continue;
                    values.add(o);
                }
            }
        }
        return values;
    }

    public Map<EClass, List<EStructuralFeature>> fetchTypesWithEClassifier(EClassifier dataType) throws HawkInstanceNotFound, HawkInstanceNotRunning, UnknownQueryLanguage, InvalidQuery, FailedQuery, TException {
        HawkQueryOptions opts = new HawkQueryOptions();
        opts.setRepositoryPattern(this.descriptor.getHawkRepository());
        opts.setFilePatterns(Arrays.asList(this.descriptor.getHawkFilePatterns()));
        this.setEffectiveMetamodelOptions(opts, this.descriptor.getEffectiveMetamodel());
        QueryResult typesWithInstances = this.client.query(this.descriptor.getHawkInstance(), "return Model.types.select(t|not t.all.isEmpty);", EOL_QUERY_LANG, opts);
        IdentityHashMap<EClass, List<EStructuralFeature>> candidateTypes = new IdentityHashMap<EClass, List<EStructuralFeature>>();
        for (QueryResult qr : typesWithInstances.getVList()) {
            ModelElementType type = qr.getVModelElementType();
            EClass eClass = HawkResourceImpl.getEClass(type.metamodelUri, type.typeName, this.getResourceSet().getPackageRegistry());
            ArrayList<EStructuralFeature> attrsWithType = new ArrayList<EStructuralFeature>();
            for (EStructuralFeature attr : eClass.getEAllAttributes()) {
                if (attr.getEType() != dataType) continue;
                attrsWithType.add(attr);
            }
            if (!attrsWithType.isEmpty()) continue;
            candidateTypes.put(eClass, attrsWithType);
        }
        return candidateTypes;
    }

    public Map<EObject, Object> fetchValuesByEStructuralFeature(EStructuralFeature feature) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException, IOException {
        EClass featureEClass = feature.getEContainingClass();
        EList<EObject> eobs = this.fetchNodes(featureEClass, feature instanceof EAttribute);
        LOGGER.debug("Fetched {} nodes of class {}", (Object)eobs.size(), (Object)featureEClass.getName());
        if (this.lazyResolver != null && feature instanceof EReference) {
            EReference ref = (EReference)feature;
            ArrayList<String> allPending = new ArrayList<String>();
            for (EObject eob : eobs) {
                EList pending = this.lazyResolver.getPending(eob, ref);
                if (pending == null) continue;
                for (Object p : pending) {
                    if (!(p instanceof String)) continue;
                    allPending.add((String)p);
                }
            }
            this.fetchNodes(allPending, false);
        }
        IdentityHashMap<EObject, Object> values = new IdentityHashMap<EObject, Object>();
        for (EObject eob : eobs) {
            Object value = eob.eGet(feature);
            if (value != null) {
                values.put(eob, value);
                continue;
            }
            LOGGER.debug("Value is null for feature {} of object {}", (Object)feature.getName(), (Object)eob);
        }
        return values;
    }

    public void fetchAttributes(Map<String, EObject> objects) throws IOException, HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        HawkQueryOptions options = new HawkQueryOptions();
        options.setIncludeAttributes(true);
        options.setIncludeReferences(false);
        this.setEffectiveMetamodelOptions(options, this.descriptor.getEffectiveMetamodel());
        List elems = this.client.resolveProxies(this.descriptor.getHawkInstance(), new ArrayList<String>(objects.keySet()), options);
        for (ModelElement me : elems) {
            EObject object = objects.get(me.id);
            EFactory eFactory = this.getResourceSet().getPackageRegistry().getEFactory(me.getMetamodelUri());
            EClass eClass = HawkResourceImpl.getEClass(me.getMetamodelUri(), me.getTypeName(), this.getResourceSet().getPackageRegistry());
            for (AttributeSlot s : me.attributes) {
                SlotDecodingUtils.setFromSlot(eFactory, eClass, object, s);
            }
        }
    }

    public boolean addSyncEndListener(Runnable r) {
        return this.syncEndListeners.add(r);
    }

    public boolean removeSyncEndListener(Runnable r) {
        return this.syncEndListeners.remove(r);
    }

    public boolean addChangeListener(HawkResourceChangeListener l) {
        return this.changeListeners.add(l);
    }

    public boolean removeChangeListener(HawkResourceChangeListener l) {
        return this.changeListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToResource(String repoURL, String path, EObject eob) {
        if (this.descriptor.isSplit()) {
            String fullURL = this.computeFileResourceURL(repoURL, path);
            Map<String, HawkFileResourceImpl> map = this.resources;
            synchronized (map) {
                HawkFileResourceImpl resource = this.resources.get(fullURL);
                if (resource == null) {
                    resource = new HawkFileResourceImpl(URI.createURI((String)fullURL), (HawkResource)this);
                    this.getResourceSet().getResources().add((Object)resource);
                    this.resources.put(fullURL, resource);
                }
                resource.getContents().add((Object)eob);
            }
        } else {
            this.getContents().add((Object)eob);
        }
    }

    private String computeFileResourceURL(String repoURL, String path) {
        String repoSep = repoURL.endsWith("/") ? "!!" : "/!!";
        String pathSep = path.startsWith("/") ? "" : "/";
        return "hawkrepo+" + repoURL + repoSep + pathSep + path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EObject createEObject(ModelElement me) throws IOException {
        EPackage.Registry registry = this.getResourceSet().getPackageRegistry();
        EClass eClass = HawkResourceImpl.getEClass(me.metamodelUri, me.typeName, registry);
        EObject obj = this.createInstance(eClass);
        if (me.isSetId()) {
            this.nodeIdToEObjectMap.put((Object)me.id, (Object)obj);
            Map<EClass, EList<EObject>> map = this.classToEObjectsMap;
            synchronized (map) {
                EList<EObject> instances = this.classToEObjectsMap.get(eClass);
                if (instances != null) {
                    instances.add((Object)obj);
                }
            }
        }
        if (me.isSetAttributes()) {
            EFactory factory = registry.getEFactory(eClass.getEPackage().getNsURI());
            for (AttributeSlot s : me.attributes) {
                SlotDecodingUtils.setFromSlot(factory, eClass, obj, s);
            }
        } else if (!this.descriptor.getLoadingMode().isGreedyAttributes()) {
            this.getLazyResolver().putLazyAttributes(me.id, obj);
        }
        return obj;
    }

    private EObject createInstance(EClass eClass) {
        EPackage.Registry packageRegistry = this.getResourceSet().getPackageRegistry();
        EFactory factory = packageRegistry.getEFactory(eClass.getEPackage().getNsURI());
        EObject obj = factory.create(eClass);
        if (this.isLazyLoading()) {
            if (this.eobFactory == null) {
                this.eobFactory = new LazyEObjectFactory(this.getResourceSet().getPackageRegistry(), new MethodInterceptor(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object intercept(Object o, Method m, Object[] args, MethodProxy proxy) throws Throwable {
                        EObject eob = (EObject)o;
                        switch (m.getName()) {
                            case "eIsSet": {
                                EStructuralFeature sfEIsSet = (EStructuralFeature)args[0];
                                if (!((Boolean)proxy.invokeSuper(o, args)).booleanValue() && !HawkResourceImpl.this.getLazyResolver().isLazy(eob, sfEIsSet)) {
                                    return false;
                                }
                                return true;
                            }
                            case "eContainmentFeature": 
                            case "eContainingFeature": {
                                EReference sfContainingF = HawkResourceImpl.this.lazyResolver.getContainingFeature(eob);
                                return sfContainingF != null ? sfContainingF : proxy.invokeSuper(o, args);
                            }
                            case "eContainerFeatureID": {
                                EReference sfContaining = HawkResourceImpl.this.lazyResolver.getContainingFeature(eob);
                                if (!$assertionsDisabled && !sfContaining.isContainment()) {
                                    throw new AssertionError((Object)"containing feature should be containment");
                                }
                                if (sfContaining != null) {
                                    if (sfContaining.getEOpposite() != null) {
                                        return sfContaining.getEOpposite().getFeatureID();
                                    }
                                    return -1 - sfContaining.getFeatureID();
                                }
                                return proxy.invokeSuper(o, args);
                            }
                            case "eInternalContainer": 
                            case "eContainer": {
                                EObject rawContainer = (EObject)proxy.invokeSuper(o, args);
                                return rawContainer != null ? rawContainer : (HawkResourceImpl.this.lazyResolver != null ? HawkResourceImpl.this.lazyResolver.getContainer(eob) : null);
                            }
                            case "eResource": {
                                Object rawResource = proxy.invokeSuper(o, args);
                                return rawResource != null ? rawResource : (HawkResourceImpl.this.lazyResolver != null ? HawkResourceImpl.this.lazyResolver.getContainer(eob) : null);
                            }
                            case "eGet": {
                                EStructuralFeature sfEGet = (EStructuralFeature)args[0];
                                return this.interceptEGet(eob, args, proxy, sfEGet);
                            }
                            case "eContents": {
                                HawkModelDescriptor.LoadingMode loadingMode = HawkResourceImpl.this.getDescriptor().getLoadingMode();
                                BiMap biMap = HawkResourceImpl.this.nodeIdToEObjectMap;
                                synchronized (biMap) {
                                    for (EReference ref : eob.eClass().getEAllReferences()) {
                                        if (!ref.isContainment()) continue;
                                        HawkResourceImpl.this.getLazyResolver().resolve(eob, (EStructuralFeature)ref, loadingMode.isGreedyReferences(), loadingMode.isGreedyAttributes());
                                    }
                                    break;
                                }
                            }
                            default: {
                                EReference eRef;
                                if (!m.getName().startsWith("get") || (eRef = HawkResourceImpl.this.eobFactory.guessEReferenceFromGetter(eob.eClass(), m.getName())) == null) break;
                                return this.interceptEGet(eob, args, proxy, (EStructuralFeature)eRef);
                            }
                        }
                        return proxy.invokeSuper(o, args);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected Object interceptEGet(EObject eob, Object[] args, MethodProxy proxy, EStructuralFeature sf) throws Throwable {
                        BiMap biMap = HawkResourceImpl.this.nodeIdToEObjectMap;
                        synchronized (biMap) {
                            HawkModelDescriptor.LoadingMode loadingMode = HawkResourceImpl.this.getDescriptor().getLoadingMode();
                            Object value = HawkResourceImpl.this.getLazyResolver().resolve(eob, sf, loadingMode.isGreedyReferences(), loadingMode.isGreedyAttributes());
                            if (value != null) {
                                return value;
                            }
                        }
                        return proxy.invokeSuper((Object)eob, args);
                    }
                });
            }
            return this.eobFactory.createInstance(eClass);
        }
        return obj;
    }

    public boolean isLazyLoading() {
        HawkModelDescriptor.LoadingMode mode = this.descriptor.getLoadingMode();
        return !mode.isGreedyAttributes() || !mode.isGreedyElements();
    }

    private List<EObject> createEObjectTree(List<ModelElement> elems, TreeLoadingState state) throws IOException {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        for (ModelElement me : elems) {
            if (me.isSetMetamodelUri()) {
                state.lastMetamodelURI = me.getMetamodelUri();
            } else {
                me.setMetamodelUri(state.lastMetamodelURI);
            }
            if (me.isSetTypeName()) {
                state.lastTypename = me.getTypeName();
            } else {
                me.setTypeName(state.lastTypename);
            }
            if (me.isSetRepositoryURL()) {
                state.lastRepository = me.getRepositoryURL();
            } else {
                me.setRepositoryURL(state.lastRepository);
            }
            if (me.isSetFile()) {
                state.lastFile = me.getFile();
            } else {
                me.setFile(state.lastFile);
            }
            EObject obj = this.createEObject(me);
            state.allEObjects.add(obj);
            state.meToEObject.put(me, obj);
            eObjects.add(obj);
            if (!me.isSetContainers()) continue;
            for (ContainerSlot s : me.containers) {
                EStructuralFeature sf = obj.eClass().getEStructuralFeature(s.name);
                List<EObject> children = this.createEObjectTree(s.elements, state);
                if (sf.isMany()) {
                    obj.eSet(sf, (Object)ECollections.toEList(children));
                } else if (!children.isEmpty()) {
                    obj.eSet(sf, (Object)children.get(0));
                }
                for (EObject child : children) {
                    if (child.eResource() == null) continue;
                    child.eResource().getContents().remove((Object)child);
                }
            }
        }
        return eObjects;
    }

    private void fillInReferences(List<ModelElement> elems, TreeLoadingState state) throws IOException {
        EPackage.Registry packageRegistry = this.getResourceSet().getPackageRegistry();
        for (ModelElement me : elems) {
            EObject sourceObj = state.meToEObject.remove(me);
            this.fillInReferences(packageRegistry, me, sourceObj, state);
        }
    }

    private void fillInReferences(EPackage.Registry packageRegistry, ModelElement me, EObject sourceObj, TreeLoadingState state) throws IOException {
        if (me.isSetReferences()) {
            for (ReferenceSlot s : me.references) {
                EClass eClass = HawkResourceImpl.getEClass(me.getMetamodelUri(), me.getTypeName(), packageRegistry);
                EReference feature = (EReference)eClass.getEStructuralFeature(s.name);
                if (feature.isContainer() && sourceObj.eResource() != null) {
                    sourceObj.eResource().getContents().remove((Object)sourceObj);
                }
                this.fillInReference(sourceObj, s, feature, state);
            }
        }
        if (me.isSetContainers()) {
            for (ReferenceSlot s : me.getContainers()) {
                this.fillInReferences(s.elements, state);
            }
        }
        if (sourceObj.eContainer() == null) {
            this.addToResource(me.getRepositoryURL(), me.getFile(), sourceObj);
        }
    }

    private void fillInReference(EObject sourceObj, ReferenceSlot s, EReference feature, TreeLoadingState state) {
        if (!feature.isChangeable() || feature.isDerived() && !(sourceObj instanceof DynamicEStoreEObjectImpl)) {
            return;
        }
        boolean allAvailable = this.descriptor.getLoadingMode().isGreedyElements() && !this.descriptor.isPaged();
        EList<Object> eSetValues = null;
        if (s.isSetId()) {
            EObject eObject = (EObject)this.nodeIdToEObjectMap.get((Object)s.id);
            if (eObject != null) {
                eSetValues = this.createEList(eObject);
            } else if (!allAvailable) {
                BasicEList value = new BasicEList();
                value.add((Object)s.id);
                this.getLazyResolver().putLazyReference(sourceObj, feature, (EList)value);
            }
        } else if (s.isSetIds()) {
            eSetValues = this.createEList(new EObject[0]);
            for (String targetId : s.ids) {
                EObject eob = (EObject)this.nodeIdToEObjectMap.get((Object)targetId);
                if (eob == null) continue;
                eSetValues.add((Object)eob);
                if (!feature.isContainment() || eob.eResource() == null) continue;
                eob.eResource().getContents().remove((Object)eob);
            }
            if (!allAvailable && eSetValues.size() != s.ids.size()) {
                eSetValues = null;
                BasicEList lazyIds = new BasicEList();
                lazyIds.addAll((Collection)s.ids);
                this.getLazyResolver().putLazyReference(sourceObj, feature, (EList)lazyIds);
            }
        } else if (s.isSetPosition()) {
            eSetValues = this.createEList(state.allEObjects.get(s.position));
        } else if (s.isSetPositions()) {
            eSetValues = this.createEList(new EObject[0]);
            for (Integer position : s.positions) {
                eSetValues.add((Object)state.allEObjects.get(position));
            }
        } else if (s.isSetMixed()) {
            EList<Object> value = this.createEList(new EObject[0]);
            boolean allFetched = true;
            for (MixedReference mixed : s.mixed) {
                if (mixed.isSetId()) {
                    EObject eob = (EObject)this.nodeIdToEObjectMap.get((Object)mixed.getId());
                    if (eob != null) {
                        value.add((Object)eob);
                        if (!feature.isContainment() || eob.eResource() == null) continue;
                        eob.eResource().getContents().remove((Object)eob);
                        continue;
                    }
                    if (allAvailable) continue;
                    allFetched = false;
                    value.add((Object)mixed.getId());
                    continue;
                }
                if (mixed.isSetPosition()) {
                    value.add((Object)state.allEObjects.get(mixed.getPosition()));
                    continue;
                }
                LOGGER.warn("Unknown mixed reference in {}", (Object)mixed);
            }
            if (allFetched) {
                eSetValues = value;
            } else {
                this.getLazyResolver().putLazyReference(sourceObj, feature, value);
            }
        } else {
            LOGGER.warn("No known reference field was set in {}", (Object)s);
        }
        if (eSetValues != null) {
            if (feature.isMany()) {
                sourceObj.eSet((EStructuralFeature)feature, eSetValues);
            } else if (!eSetValues.isEmpty()) {
                sourceObj.eSet((EStructuralFeature)feature, eSetValues.get(0));
            }
            if (feature.isContainment()) {
                for (Object o : eSetValues) {
                    EObject contained = (EObject)o;
                    if (contained.eResource() == null) continue;
                    contained.eResource().getContents().remove((Object)contained);
                }
            }
        }
    }

    private EList<Object> createEList(EObject ... objects) {
        BasicEList values = new BasicEList();
        values.addAll(Arrays.asList(objects));
        return values;
    }

    private LazyResolver getLazyResolver() {
        if (this.lazyResolver == null) {
            this.lazyResolver = new LazyResolver((HawkResource)this);
        }
        return this.lazyResolver;
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        HawkModelDescriptor descriptor = new HawkModelDescriptor();
        descriptor.load(inputStream);
        this.doLoad(descriptor, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void doUnload() {
        if (!this.getContents().isEmpty()) {
            this.getContents().clear();
        }
        this.getErrors().clear();
        this.getWarnings().clear();
        this.resources.clear();
        this.nodeIdToEObjectMap.clear();
        this.classToEObjectsMap.clear();
        if (this.client != null) {
            this.client.getInputProtocol().getTransport().close();
            this.client = null;
        }
        if (this.subscriber != null) {
            try {
                this.subscriber.closeSession();
            }
            catch (ActiveMQException e) {
                LOGGER.error("Could not close the subscriber session", (Throwable)e);
            }
            this.subscriber = null;
        }
        this.lazyResolver = null;
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        LOGGER.warn("Hawk views are read-only: ignoring request to save");
    }

    private void notifyAttributeUnset(EObject eob, EStructuralFeature eAttr, Object oldValue) {
        if (oldValue instanceof Iterable) {
            for (Object o : (Iterable)oldValue) {
                this.dataTypeDeleted(eAttr.getEType(), o);
                this.featureDeleted(eob, eAttr, o);
            }
        } else {
            this.dataTypeDeleted(eAttr.getEType(), oldValue);
            this.featureDeleted(eob, eAttr, oldValue);
        }
    }

    private void notifyAttributeSet(EObject eob, EStructuralFeature eAttr, Object newValue) {
        if (newValue instanceof Iterable) {
            for (Object o : (Iterable)newValue) {
                this.dataTypeInserted(eAttr.getEType(), o);
                this.featureInserted(eob, eAttr, o);
            }
        } else {
            this.dataTypeInserted(eAttr.getEType(), newValue);
            this.featureInserted(eob, eAttr, newValue);
        }
    }

    private void featureInserted(EObject source, EStructuralFeature eAttr, Object o) {
        for (HawkResourceChangeListener l : this.changeListeners) {
            l.featureInserted(source, eAttr, o);
        }
    }

    private void featureDeleted(EObject eob, EStructuralFeature eAttr, Object oldValue) {
        for (HawkResourceChangeListener l : this.changeListeners) {
            l.featureDeleted(eob, eAttr, oldValue);
        }
    }

    private void instanceDeleted(EObject eob, EClass eClass) {
        for (HawkResourceChangeListener l : this.changeListeners) {
            l.instanceDeleted(eClass, eob);
        }
    }

    private void instanceInserted(EObject eob, EClass eClass) {
        for (HawkResourceChangeListener l : this.changeListeners) {
            l.instanceInserted(eClass, eob);
        }
    }

    private void dataTypeDeleted(EClassifier eType, Object oldValue) {
        for (HawkResourceChangeListener l : this.changeListeners) {
            l.dataTypeDeleted(eType, oldValue);
        }
    }

    private void dataTypeInserted(EClassifier eType, Object newValue) {
        for (HawkResourceChangeListener l : this.changeListeners) {
            l.dataTypeInserted(eType, newValue);
        }
    }

    public EObject fetchNode(HawkResource containerResource, String uriFragment, boolean mustFetchAttributes) throws Exception {
        throw new UnsupportedOperationException();
    }

    public EObject fetchNode(String id, boolean mustFetchAttributes) throws Exception {
        if (!this.isIncludeNodeIDs(this.getDescriptor())) {
            throw new IllegalArgumentException("Cannot fetch by ID: loading mode is " + (Object)((Object)this.descriptor.getLoadingMode()));
        }
        EObject eob = (EObject)this.nodeIdToEObjectMap.get((Object)id);
        if (eob != null) {
            return eob;
        }
        EList<EObject> resolved = this.fetchNodes(Arrays.asList(id), mustFetchAttributes);
        if (resolved.isEmpty()) {
            return null;
        }
        return (EObject)resolved.get(0);
    }

    public String getEObjectNodeID(EObject obj) {
        return (String)this.nodeIdToEObjectMap.inverse().get((Object)obj);
    }

    public List<String> getRegisteredMetamodels() throws Exception {
        return this.client.listMetamodels(this.descriptor.getHawkInstance());
    }

    public List<String> getRegisteredTypes(String metamodelURI) throws Exception {
        HawkQueryOptions opts = new HawkQueryOptions();
        opts.setRepositoryPattern(this.descriptor.getHawkRepository());
        opts.setFilePatterns(Arrays.asList(this.descriptor.getHawkFilePatterns()));
        QueryResult queryResults = this.client.query(this.descriptor.getHawkInstance(), "return Model.metamodels.selectOne(p|p.uri='%s').types.name;", EOL_QUERY_LANG, opts);
        ArrayList<String> types = new ArrayList<String>();
        for (QueryResult qr : queryResults.getVList()) {
            if (!qr.isSetVString()) continue;
            types.add(qr.getVString());
        }
        return types;
    }

    public void markChanged(EObject eob) {
    }

    private final class HawkResourceMessageHandler
    implements MessageHandler {
        private long lastSyncStart;
        private final TProtocolFactory protocolFactory;

        public HawkResourceMessageHandler(TProtocolFactory protocolFactory) {
            this.protocolFactory = protocolFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(ClientMessage message) {
            try {
                TProtocol proto = this.protocolFactory.getProtocol((TTransport)new ActiveMQBufferTransport(message.getBodyBuffer()));
                HawkChangeEvent change = new HawkChangeEvent();
                try {
                    change.read(proto);
                    BiMap biMap = HawkResourceImpl.this.nodeIdToEObjectMap;
                    synchronized (biMap) {
                        LOGGER.debug("Received message from Artemis at {}: {}", (Object)message.getAddress(), (Object)change);
                        if (change.isSetModelElementAttributeUpdate()) {
                            this.handle(change.getModelElementAttributeUpdate());
                        } else if (change.isSetModelElementAttributeRemoval()) {
                            this.handle(change.getModelElementAttributeRemoval());
                        } else if (change.isSetModelElementAddition()) {
                            this.handle(change.getModelElementAddition());
                        } else if (change.isSetModelElementRemoval()) {
                            this.handle(change.getModelElementRemoval());
                        } else if (change.isSetReferenceAddition()) {
                            this.handle(change.getReferenceAddition());
                        } else if (change.isSetReferenceRemoval()) {
                            this.handle(change.getReferenceRemoval());
                        } else if (change.isSetSyncStart()) {
                            this.handle(change.getSyncStart());
                        } else if (change.isSetSyncEnd()) {
                            this.handle(change.getSyncEnd());
                        } else if (change.isSetFileAddition()) {
                            this.handle(change.getFileAddition());
                        } else if (change.isSetFileRemoval()) {
                            this.handle(change.getFileRemoval());
                        }
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("Error while handling incoming message", e);
                }
                message.acknowledge();
            }
            catch (ActiveMQException e) {
                LOGGER.error("Failed to ack message", (Throwable)e);
            }
        }

        private void handle(HawkReferenceRemovalEvent ev) {
            block15: {
                EObject source = (EObject)HawkResourceImpl.this.nodeIdToEObjectMap.get((Object)ev.sourceId);
                EObject target = (EObject)HawkResourceImpl.this.nodeIdToEObjectMap.get((Object)ev.targetId);
                if (source != null) {
                    EReference ref = (EReference)source.eClass().getEStructuralFeature(ev.refName);
                    if (!ref.isChangeable()) {
                        return;
                    }
                    if (HawkResourceImpl.this.lazyResolver != null && HawkResourceImpl.this.lazyResolver.isLazy(source, (EStructuralFeature)ref)) {
                        if (!HawkResourceImpl.this.lazyResolver.removeFromLazyReference(source, ref, (Object)ev.targetId) && target != null) {
                            HawkResourceImpl.this.lazyResolver.removeFromLazyReference(source, ref, (Object)target);
                        }
                        if (target != null) {
                            HawkResourceImpl.this.featureDeleted(source, (EStructuralFeature)ref, target);
                        } else if (!HawkResourceImpl.this.changeListeners.isEmpty()) {
                            try {
                                EList<EObject> resolved = HawkResourceImpl.this.fetchNodes(Arrays.asList(ev.targetId), false);
                                if (resolved.isEmpty()) {
                                    LOGGER.warn("Could not notify listeners about deleted reference from {} to {}", (Object)ev.sourceId, (Object)ev.targetId);
                                    break block15;
                                }
                                HawkResourceImpl.this.featureDeleted(source, (EStructuralFeature)ref, resolved.get(0));
                            }
                            catch (IOException | TException e) {
                                LOGGER.error("Could not resolve removal", (Object)e.getMessage());
                            }
                        }
                    } else if (target != null) {
                        if (!ref.getEType().isInstance((Object)target)) {
                            throw new IllegalArgumentException(String.format("The target node %s is a %s, not an instance of %s", ev.targetId, target.eClass().getName(), ref.getEType().getName()));
                        }
                        if (ref.isMany()) {
                            Collection objs = (Collection)source.eGet((EStructuralFeature)ref);
                            objs.remove(target);
                        } else {
                            source.eUnset((EStructuralFeature)ref);
                        }
                        HawkResourceImpl.this.featureDeleted(source, (EStructuralFeature)ref, target);
                    }
                }
            }
        }

        private void handle(HawkReferenceAdditionEvent ev) {
            EObject source = (EObject)HawkResourceImpl.this.nodeIdToEObjectMap.get((Object)ev.sourceId);
            EObject target = (EObject)HawkResourceImpl.this.nodeIdToEObjectMap.get((Object)ev.targetId);
            if (source != null) {
                EReference ref = (EReference)source.eClass().getEStructuralFeature(ev.refName);
                if (!ref.isChangeable()) {
                    return;
                }
                if (HawkResourceImpl.this.lazyResolver != null && HawkResourceImpl.this.lazyResolver.isLazy(source, (EStructuralFeature)ref)) {
                    this.handleLazyReferenceAddition(ev, source, target, ref);
                } else if (HawkResourceImpl.this.isLazyLoading() && HawkResourceImpl.this.changeListeners.isEmpty() && !source.eIsSet((EStructuralFeature)ref)) {
                    BasicEList newList = new BasicEList();
                    newList.add((Object)ev.targetId);
                    HawkResourceImpl.this.getLazyResolver().putLazyReference(source, ref, (EList)newList);
                } else {
                    try {
                        this.handleNonlazyReferenceAddition(ev, source, target, ref);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Exception while handling non-lazy addition of reference {} from {} to {}", new Object[]{ref, ev.sourceId, ev.targetId});
                    }
                }
            } else {
                LOGGER.debug("Source of reference {} from {} to {} was not available", new Object[]{ev.refName, ev.sourceId, ev.targetId});
            }
        }

        private void handleNonlazyReferenceAddition(HawkReferenceAdditionEvent ev, EObject source, EObject target, EReference ref) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException, IOException {
            if (target == null) {
                EList<EObject> lResolved = HawkResourceImpl.this.fetchNodes(Arrays.asList(ev.targetId), false);
                if (lResolved.isEmpty()) {
                    LOGGER.warn("Target not found for non-lazy reference {} from node {} to node {}", new Object[]{ref, ev.sourceId, ev.targetId});
                    return;
                }
                target = (EObject)lResolved.get(0);
            }
            if (!ref.getEType().isInstance((Object)target)) {
                throw new IllegalArgumentException(String.format("The target node %s is a %s, not an instance of %s", ev.targetId, target.eClass().getName(), ref.getEType().getName()));
            }
            if (ref.isMany()) {
                Collection objs = (Collection)source.eGet((EStructuralFeature)ref);
                objs.add(target);
            } else {
                source.eSet((EStructuralFeature)ref, (Object)target);
            }
            if (ref.isContainer()) {
                source.eResource().getContents().remove((Object)source);
            } else if (ref.isContainment()) {
                target.eResource().getContents().remove((Object)target);
            }
            LOGGER.debug("Added {} to non-lazy ref {} of {}", new Object[]{target, ref.getName(), source});
            HawkResourceImpl.this.featureInserted(source, (EStructuralFeature)ref, target);
        }

        private void handleLazyReferenceAddition(HawkReferenceAdditionEvent ev, EObject source, EObject target, EReference ref) {
            block7: {
                if (target != null) {
                    HawkResourceImpl.this.lazyResolver.addToLazyReference(source, ref, (Object)target);
                    HawkResourceImpl.this.featureInserted(source, (EStructuralFeature)ref, target);
                } else if (!HawkResourceImpl.this.changeListeners.isEmpty()) {
                    try {
                        EList<EObject> resolved = HawkResourceImpl.this.fetchNodes(Arrays.asList(ev.targetId), false);
                        if (resolved.isEmpty()) {
                            HawkResourceImpl.this.lazyResolver.addToLazyReference(source, ref, (Object)ev.targetId);
                            LOGGER.warn("Target node does not exist: could not notify listeners about inserted reference from {} to {}", (Object)ev.sourceId, (Object)ev.targetId);
                            break block7;
                        }
                        EObject firstResolved = (EObject)resolved.get(0);
                        HawkResourceImpl.this.lazyResolver.addToLazyReference(source, ref, (Object)firstResolved);
                        HawkResourceImpl.this.featureInserted(source, (EStructuralFeature)ref, firstResolved);
                    }
                    catch (IOException | TException e) {
                        LOGGER.error("Could not resolve addition", (Object)e.getMessage());
                    }
                } else {
                    HawkResourceImpl.this.lazyResolver.addToLazyReference(source, ref, (Object)ev.targetId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handle(HawkModelElementRemovalEvent ev) {
            EObject eob = (EObject)HawkResourceImpl.this.nodeIdToEObjectMap.remove((Object)ev.id);
            if (eob != null) {
                EObject container;
                Map map = HawkResourceImpl.this.classToEObjectsMap;
                synchronized (map) {
                    EList instances = (EList)HawkResourceImpl.this.classToEObjectsMap.get(eob.eClass());
                    if (instances != null) {
                        instances.remove((Object)eob);
                    }
                }
                if (eob.eResource() != null) {
                    eob.eResource().getContents().remove((Object)eob);
                }
                if ((container = eob.eContainer()) != null) {
                    EStructuralFeature containingFeature = eob.eContainingFeature();
                    if (containingFeature.isMany()) {
                        ((Collection)container.eGet(containingFeature)).remove(eob);
                    } else {
                        container.eUnset(containingFeature);
                    }
                }
                HawkResourceImpl.this.instanceDeleted(eob, eob.eClass());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handle(HawkModelElementAdditionEvent ev) {
            EPackage.Registry registry = HawkResourceImpl.this.getResourceSet().getPackageRegistry();
            EClass eClass = HawkResourceImpl.getEClass(ev.metamodelURI, ev.typeName, registry);
            EObject existing = (EObject)HawkResourceImpl.this.nodeIdToEObjectMap.get((Object)ev.id);
            if (existing == null) {
                EObject eob = HawkResourceImpl.this.createInstance(eClass);
                HawkResourceImpl.this.nodeIdToEObjectMap.put((Object)ev.id, (Object)eob);
                Map map = HawkResourceImpl.this.classToEObjectsMap;
                synchronized (map) {
                    EList instances = (EList)HawkResourceImpl.this.classToEObjectsMap.get(eClass);
                    if (instances != null) {
                        instances.add((Object)eob);
                    }
                }
                HawkResourceImpl.this.addToResource(ev.vcsItem.repoURL, ev.vcsItem.path, eob);
                LOGGER.debug("Added a new {} with ID {}", (Object)eob.eClass().getName(), (Object)ev.id);
                HawkResourceImpl.this.instanceInserted(eob, eob.eClass());
            } else {
                LOGGER.warn("We already have a {} with ID {}: cannot create a {} there", new Object[]{existing.eClass().getName(), ev.id, eClass.getName()});
            }
        }

        private void handle(HawkAttributeRemovalEvent ev) {
            EObject eob = (EObject)HawkResourceImpl.this.nodeIdToEObjectMap.get((Object)ev.getId());
            if (eob != null) {
                EStructuralFeature eAttr = eob.eClass().getEStructuralFeature(ev.attribute);
                if (!HawkResourceImpl.this.changeListeners.isEmpty()) {
                    Object oldValue = eob.eGet(eAttr);
                    HawkResourceImpl.this.notifyAttributeUnset(eob, eAttr, oldValue);
                }
                if (eAttr != null) {
                    eob.eUnset(eAttr);
                    if (!HawkResourceImpl.this.changeListeners.isEmpty() && eAttr.getDefaultValue() != null) {
                        HawkResourceImpl.this.notifyAttributeSet(eob, eAttr, eAttr.getDefaultValue());
                    }
                }
            }
        }

        private void handle(HawkAttributeUpdateEvent ev) {
            EObject eob = (EObject)HawkResourceImpl.this.nodeIdToEObjectMap.get((Object)ev.getId());
            if (eob != null) {
                EClass eClass = eob.eClass();
                AttributeSlot slot = new AttributeSlot(ev.attribute);
                slot.setValue(ev.value);
                try {
                    EStructuralFeature eAttr = eClass.getEStructuralFeature(ev.attribute);
                    if (!HawkResourceImpl.this.changeListeners.isEmpty()) {
                        HawkResourceImpl.this.notifyAttributeUnset(eob, eAttr, eob.eGet(eAttr));
                    }
                    Object newValue = SlotDecodingUtils.setFromSlot(eClass.getEPackage().getEFactoryInstance(), eClass, eob, slot);
                    HawkResourceImpl.this.notifyAttributeSet(eob, eAttr, newValue);
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            } else {
                LOGGER.debug("EObject for ID {} not found when handling attribute update", (Object)ev.getId());
            }
        }

        private void handle(HawkSynchronizationStartEvent syncStart) {
            this.lastSyncStart = syncStart.getTimestampNanos();
            LOGGER.debug("Sync started: local timestamp is {} ns", (Object)this.lastSyncStart);
        }

        private void handle(HawkSynchronizationEndEvent syncEnd) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sync ended: local timestamp is {} ns (elapsed time: {} ms)", (Object)syncEnd.getTimestampNanos(), (Object)((double)(syncEnd.getTimestampNanos() - this.lastSyncStart) / 1000000.0));
            }
            try {
                HawkResourceImpl.this.subscriber.commitSession();
            }
            catch (ActiveMQException e) {
                LOGGER.error("Could not commit client session", (Throwable)e);
            }
            for (Runnable r : HawkResourceImpl.this.syncEndListeners) {
                try {
                    r.run();
                }
                catch (Throwable t) {
                    LOGGER.error("Error while executing sync end listener", t);
                }
            }
        }

        private void handle(HawkFileAdditionEvent ev) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handle(HawkFileRemovalEvent ev) {
            String fullUrl = HawkResourceImpl.this.computeFileResourceURL(ev.vcsItem.repoURL, ev.vcsItem.path);
            Map map = HawkResourceImpl.this.resources;
            synchronized (map) {
                Resource r = (Resource)HawkResourceImpl.this.resources.remove(fullUrl);
                if (r != null) {
                    r.unload();
                    HawkResourceImpl.this.getResourceSet().getResources().remove((Object)r);
                }
            }
        }
    }

    private final class TreeLoadingState {
        public String lastTypename;
        public String lastMetamodelURI;
        public String lastRepository;
        public String lastFile;
        public final List<EObject> allEObjects = new ArrayList<EObject>();
        public final Map<ModelElement, EObject> meToEObject = new IdentityHashMap<ModelElement, EObject>();

        private TreeLoadingState() {
        }
    }
}

