/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.graph;

import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.graph.updater.DeletionUtils;
import org.eclipse.hawk.graph.updater.GraphModelInserter;
import org.eclipse.hawk.graph.updater.GraphModelUpdater;
import org.eclipse.hawk.graph.updater.TypeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAwareModelUpdater
extends GraphModelUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeAwareModelUpdater.class);

    public GraphModelInserter createInserter() {
        return new GraphModelInserter(this.indexer, this::createDeletionUtils, new TypeCache(this.indexer)){

            protected double calculateModelDeltaRatio(IGraphNode fileNode, boolean verbose) throws Exception {
                super.calculateModelDeltaRatio(fileNode, verbose);
                return 0.0;
            }
        };
    }

    protected DeletionUtils createDeletionUtils() {
        return new SoftDeletionUtils(this.indexer.getGraph());
    }

    public String getHumanReadableName() {
        return "Default Hawk Time Aware Model Updater (v1.0)";
    }

    public class SoftDeletionUtils
    extends DeletionUtils {
        public SoftDeletionUtils(IGraphDatabase graph) {
            super(graph);
        }

        protected boolean delete(IGraphNode modelElement) {
            if (!modelElement.getEdges().iterator().hasNext()) {
                try {
                    this.removeFromIndexes(modelElement);
                    ITimeAwareGraphNode taModelElement = (ITimeAwareGraphNode)modelElement;
                    if (taModelElement.getTime() > 0L) {
                        taModelElement.travelInTime(taModelElement.getTime() - 1L).end();
                    } else {
                        taModelElement.delete();
                    }
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            return false;
        }
    }
}

