/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.dto.ExtendedErrorPageDTO;
import org.eclipse.equinox.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.equinox.http.servlet.internal.registration.ErrorPageRegistration;
import org.eclipse.equinox.http.servlet.internal.util.DTOUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ContextErrorPageTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<Servlet, ErrorPageRegistration> {
    public ContextErrorPageTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime, contextController);
    }

    public AtomicReference<ErrorPageRegistration> addingService(ServiceReference<Servlet> serviceReference) {
        AtomicReference<ErrorPageRegistration> result = new AtomicReference<ErrorPageRegistration>();
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return result;
        }
        try {
            this.contextController.checkShutdown();
            if (!this.contextController.matches(serviceReference)) {
                if (this.httpServiceRuntime.isDefaultContext(this.contextController) && !this.httpServiceRuntime.matchesAnyContext(serviceReference)) {
                    throw new HttpWhiteboardFailureException("Doesn't match any contexts. " + serviceReference, 1);
                }
                AtomicReference<ErrorPageRegistration> atomicReference = result;
                return atomicReference;
            }
            try {
                if (this.contextController.isLegacyContext() && serviceReference.getProperty("equinox.legacy.tccl") == null && serviceReference.getProperty("osgi.http.whiteboard.context.select") != null && ((String)serviceReference.getProperty("osgi.http.whiteboard.context.select")).contains("osgi.http.whiteboard.context.httpservice".concat("=")) && serviceReference.getProperty("osgi.http.whiteboard.servlet.pattern") != null) {
                    throw new HttpWhiteboardFailureException("Whiteboard ErrorPages with pattern cannot bind to legacy contexts. " + serviceReference, 1);
                }
                this.httpServiceRuntime.removeFailedErrorPageDTO(serviceReference);
                result.set(this.contextController.addErrorPageRegistration(serviceReference));
            }
            catch (HttpWhiteboardFailureException hwfe) {
                this.httpServiceRuntime.debug(hwfe.getMessage(), hwfe);
                this.recordFailed(serviceReference, hwfe.getFailureReason());
            }
            catch (Throwable t) {
                this.httpServiceRuntime.error(t.getMessage(), t);
                this.recordFailed(serviceReference, 4);
            }
        }
        finally {
            this.httpServiceRuntime.incrementServiceChangecount();
        }
        return result;
    }

    @Override
    void removeFailed(ServiceReference<Servlet> serviceReference) {
        this.contextController.getHttpServiceRuntime().removeFailedErrorPageDTO(serviceReference);
    }

    void recordFailed(ServiceReference<?> servletReference, int failureReason) {
        ExtendedErrorPageDTO errorPageDTO = DTOUtil.assembleErrorPageDTO(servletReference, this.contextController.getServiceId(), false);
        this.contextController.recordFailedErrorPageDTO(servletReference, errorPageDTO, failureReason);
    }
}

