/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public final class BorderData {
    private final Map<Control, Point> cachedSize = new IdentityHashMap<Control, Point>(1);
    public int hHint = -1;
    public int wHint = -1;
    public int region = 0x1000000;

    public BorderData() {
    }

    public BorderData(int region) {
        this.region = region;
    }

    public BorderData(int region, int widthHint, int heightHint) {
        this.region = region;
        this.wHint = widthHint;
        this.hHint = heightHint;
    }

    Point getSize(Control control) {
        return this.cachedSize.computeIfAbsent(control, c -> c.computeSize(this.wHint, this.hHint, true));
    }

    void flushCache(Control control) {
        this.cachedSize.remove(control);
    }

    public String toString() {
        return "BorderData [region=" + BorderData.getRegionString(this.region) + ", hHint=" + this.hHint + ", wHint=" + this.wHint + "]";
    }

    static String getRegionString(int region) {
        switch (region) {
            case 128: {
                return "SWT.TOP";
            }
            case 131072: {
                return "SWT.RIGHT";
            }
            case 1024: {
                return "SWT.BOTTOM";
            }
            case 16384: {
                return "SWT.LEFT";
            }
            case 0x1000000: {
                return "SWT.CENTER";
            }
        }
        return "SWT.NONE";
    }

    int getRegion() {
        switch (this.region) {
            case 128: 
            case 1024: 
            case 16384: 
            case 131072: 
            case 0x1000000: {
                return this.region;
            }
        }
        return 0;
    }
}

