/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph.updater;

import java.io.File;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkModelResource;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.eclipse.hawk.core.query.IAccess;
import org.eclipse.hawk.core.query.IAccessListener;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.core.query.InvalidQueryException;
import org.eclipse.hawk.core.query.QueryExecutionException;
import org.eclipse.hawk.core.runtime.CompositeGraphChangeListener;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.ProxyReferenceList;
import org.eclipse.hawk.graph.ProxyReferenceTarget;
import org.eclipse.hawk.graph.updater.DeletionUtils;
import org.eclipse.hawk.graph.updater.GraphModelBatchInjector;
import org.eclipse.hawk.graph.updater.TypeCache;
import org.eclipse.hawk.graph.updater.Utils;
import org.eclipse.hawk.graph.util.GraphUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphModelInserter {
    public static final String DERIVED_ATTR_TYPE = "attributetype";
    public static final String DERIVED_ATTR_LOGIC = "derivationlogic";
    public static final String LAST_DERIVED_TSTAMP_NODEPROP = "h_lastDerived";
    public static final String DERIVED_ACCESS_IDXNAME = "derivedaccessdictionary";
    public static final String DERIVED_FEATURE_EDGEPROP = "isDerived";
    public static final String DERIVED_IDXNAME_NODEPROP = "indexName";
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphModelInserter.class);
    private static final boolean enableDebug = false;
    private static final int PROXY_RESOLVE_NOTIFY_INTERVAL = 25000;
    private static final int PROXY_RESOLVE_TX_SIZE = 5000;
    private static final int DERIVED_PNODE_TX_SIZE = 1000;
    private static final double MAX_TX_LOADRATIO = 0.5;
    private String repoURL;
    private String tempDirURI;
    private IHawkModelResource resource;
    protected Map<String, IHawkObject> updated = new HashMap<String, IHawkObject>();
    protected Map<String, IHawkObject> added = new HashMap<String, IHawkObject>();
    protected Map<String, IHawkObject> unchanged = new HashMap<String, IHawkObject>();
    protected Map<String, IHawkObject> retyped = new HashMap<String, IHawkObject>();
    private IModelIndexer indexer;
    private IGraphDatabase graph;
    private GraphModelBatchInjector inj;
    private VcsCommitItem commitItem;
    private Map<String, IGraphNode> nodes = new HashMap<String, IGraphNode>();
    private TypeCache typeCache;
    private Supplier<DeletionUtils> deletionUtils;

    public GraphModelInserter(IModelIndexer hawk, Supplier<DeletionUtils> deletionUtils, TypeCache typeCache) {
        this.indexer = hawk;
        this.graph = this.indexer.getGraph();
        this.typeCache = typeCache;
        this.deletionUtils = deletionUtils;
    }

    public boolean run(IHawkModelResource res, VcsCommitItem s, boolean verbose) throws Exception {
        if (verbose) {
            this.indexer.getCompositeStateListener().info("Calculating model delta for file: " + s.getPath() + "...");
        }
        this.resource = res;
        this.commitItem = s;
        this.inj = new GraphModelBatchInjector(this.graph, this.typeCache, this.commitItem, (IGraphChangeListener)this.indexer.getCompositeGraphChangeListener());
        double ratio = this.calculateModelDeltaRatio(verbose);
        if (ratio >= 0.0) {
            this.tempDirURI = new File(this.graph.getTempDir()).toURI().toString();
            if (verbose) {
                LOGGER.debug("File already present, calculating deltas with respect to graph storage");
            }
            if (ratio > 0.5) {
                return this.batchUpdate(verbose);
            }
            this.indexer.getCompositeStateListener().info("Performing transactional update (ratio:" + ratio + ") on file: " + this.commitItem.getPath() + "...");
            LOGGER.debug("transactional update called");
            return this.transactionalUpdate(verbose);
        }
        return this.addNodes(verbose);
    }

    protected boolean transactionalUpdate(boolean verbose) throws Exception {
        this.graph.exitBatchMode();
        CompositeGraphChangeListener listener = this.indexer.getCompositeGraphChangeListener();
        try {
            block39: {
                Throwable throwable = null;
                Object var4_6 = null;
                IGraphTransaction t = this.graph.beginTransaction();
                try {
                    IGraphNode node;
                    listener.changeStart();
                    this.repoURL = this.commitItem.getCommit().getDelta().getManager().getLocation();
                    IGraphNode fileNode = (IGraphNode)this.graph.getFileIndex().get("id", (Object)(String.valueOf(this.repoURL) + "||||" + this.commitItem.getPath())).iterator().next();
                    for (Map.Entry<String, IHawkObject> entry : this.retyped.entrySet()) {
                        String uriFragment = entry.getKey();
                        IHawkObject o = entry.getValue();
                        node = this.nodes.remove(uriFragment);
                        this.remove(node, fileNode, (IGraphChangeListener)listener);
                        this.added.put(uriFragment, o);
                    }
                    HashMap<IGraphNode, IHawkObject> addedNodes = new HashMap<IGraphNode, IHawkObject>();
                    HashMap<String, IGraphNode> addedNodesHash = new HashMap<String, IGraphNode>();
                    for (String o : this.added.keySet()) {
                        IHawkObject object = this.added.get(o);
                        IGraphNode fileNode1 = fileNode;
                        IGraphNode node1 = this.inj.addEObject(fileNode1, object, this.resource.providesSingletonElements());
                        addedNodes.put(node1, object);
                        String newID = node1.getProperty("_hawkid").toString();
                        addedNodesHash.put(newID, node1);
                        for (String transientLabelEdge : ModelElementNode.TRANSIENT_EDGE_LABELS) {
                            for (IGraphEdge e : node1.getOutgoingWithType(transientLabelEdge)) {
                                listener.referenceAddition(this.commitItem, node1, e.getEndNode(), transientLabelEdge, true);
                            }
                        }
                    }
                    for (IGraphNode node2 : addedNodes.keySet()) {
                        this.inj.addEReferences(fileNode, node2, (IHawkObject)addedNodes.get(node2), addedNodesHash, this.nodes);
                    }
                    for (String s : this.nodes.keySet()) {
                        node = this.nodes.get(s);
                        if (this.unchanged.containsKey(node.getProperty("_hawkid"))) continue;
                        if (this.updated.containsKey(node.getProperty("_hawkid"))) {
                            this.cleanupNode(node);
                            IHawkObject o = this.updated.get(node.getProperty("_hawkid"));
                            node.setProperty("_hawksignature", (Object)o.signature());
                            this.updateNodeProperties(fileNode, node, o);
                            continue;
                        }
                        this.remove(node, fileNode, (IGraphChangeListener)listener);
                    }
                    for (String o : this.updated.keySet()) {
                        IHawkObject source = this.updated.get(o);
                        IGraphNode node3 = this.nodes.get(source.getUriFragment());
                        if (node3 == null) continue;
                        for (IHawkReference r : ((IHawkClass)source.getType()).getAllReferences()) {
                            if (source.isSet((IHawkStructuralFeature)r)) {
                                Object targets = source.get(r, false);
                                String refname = r.getName();
                                boolean isContainment = r.isContainment();
                                boolean isContainer = r.isContainer();
                                HashSet<String> targetids = new HashSet<String>();
                                if (targets instanceof Iterable) {
                                    for (IHawkObject target : (Iterable)targets) {
                                        if (!target.isInDifferentResourceThan(source)) {
                                            targetids.add(target.getUriFragment());
                                            continue;
                                        }
                                        this.addProxyRef(node3, target, refname, isContainment, isContainer);
                                    }
                                } else if (!((IHawkObject)targets).isInDifferentResourceThan(source)) {
                                    targetids.add(((IHawkObject)targets).getUriFragment());
                                } else {
                                    this.addProxyRef(node3, (IHawkObject)targets, refname, isContainment, isContainer);
                                }
                                Iterable graphtargets = node3.getOutgoingWithType(refname);
                                for (IGraphEdge e : graphtargets) {
                                    IGraphNode n = e.getEndNode();
                                    Object id = n.getProperty("_hawkid");
                                    boolean targetIdPresent = targetids.remove(id);
                                    if (targetIdPresent) continue;
                                    String edgeType = e.getType();
                                    e.delete();
                                    listener.referenceRemoval(this.commitItem, node3, n, edgeType, false);
                                }
                                for (String s : targetids) {
                                    IGraphNode dest = this.nodes.get(s);
                                    if (dest == null) {
                                        dest = (IGraphNode)addedNodesHash.get(s);
                                    }
                                    if (dest == null) {
                                        dest = (IGraphNode)addedNodesHash.get(s);
                                    }
                                    if (dest == null) continue;
                                    HashMap<String, String> props = new HashMap<String, String>();
                                    if (isContainment) {
                                        props.put("isContainment", "true");
                                    }
                                    if (isContainer) {
                                        props.put("isContainer", "true");
                                    }
                                    this.graph.createRelationship(node3, dest, refname, props);
                                    listener.referenceAddition(this.commitItem, node3, dest, refname, false);
                                }
                                continue;
                            }
                            String refname = r.getName();
                            Iterable graphtargets = node3.getOutgoingWithType(refname);
                            for (IGraphEdge e : graphtargets) {
                                IGraphNode endNode = e.getEndNode();
                                String type = e.getType();
                                e.delete();
                                listener.referenceRemoval(this.commitItem, node3, endNode, type, false);
                            }
                        }
                    }
                    fileNode.setProperty("revision", (Object)this.commitItem.getCommit().getRevision());
                    t.success();
                    listener.changeSuccess();
                    if (t == null) break block39;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (t != null) {
                                t.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("exception in transactionalUpdate()", (Throwable)e);
                        listener.changeFailure();
                        return false;
                    }
                }
                t.close();
            }
            return true;
        }
        finally {
            if (verbose) {
                this.indexer.getCompositeStateListener().info("Performed transactional update on file: " + this.commitItem.getPath() + ".");
            }
        }
    }

    private void cleanupNode(IGraphNode node) {
        IGraphNodeIndex proxyDictionary = this.graph.getOrCreateNodeIndex("proxydictionary");
        proxyDictionary.remove(node);
        for (String propertyKey : node.getPropertyKeys()) {
            if (!propertyKey.startsWith("hawkProxyRef:")) continue;
            node.removeProperty(propertyKey);
        }
    }

    protected void remove(IGraphNode node, IGraphNode fileNode, IGraphChangeListener listener) {
        for (String key : node.getPropertyKeys()) {
            listener.modelElementAttributeRemoval(this.commitItem, null, key, node, ModelElementNode.TRANSIENT_ATTRIBUTES.contains(key));
        }
        for (IGraphEdge e : node.getOutgoing()) {
            if (e.getProperty(DERIVED_FEATURE_EDGEPROP) != null) continue;
            boolean isTransient = ModelElementNode.TRANSIENT_EDGE_LABELS.contains(e.getType());
            listener.referenceRemoval(this.commitItem, node, e.getEndNode(), e.getType(), isTransient);
        }
        this.remove(node, this.repoURL, fileNode, listener);
    }

    private boolean addProxyRef(IGraphNode node, IHawkObject destinationObject, String edgelabel, boolean isContainment, boolean isContainer) {
        try {
            String uri;
            String destinationObjectRelativePathURI = uri = destinationObject.getUri();
            if (!destinationObject.URIIsRelative()) {
                if (destinationObjectRelativePathURI.startsWith(this.tempDirURI)) {
                    destinationObjectRelativePathURI = destinationObjectRelativePathURI.substring(this.tempDirURI.length());
                } else {
                    IVcsManager vcs = this.commitItem.getCommit().getDelta().getManager();
                    destinationObjectRelativePathURI = vcs.getRepositoryPath(destinationObjectRelativePathURI);
                }
            }
            String destinationObjectRelativeFileURI = destinationObjectRelativePathURI;
            destinationObjectRelativeFileURI = destinationObjectRelativePathURI.substring(0, destinationObjectRelativePathURI.indexOf("#"));
            String destinationObjectFullPathURI = String.valueOf(this.repoURL) + "||||" + destinationObjectRelativePathURI;
            String destinationObjectFullFileURI = String.valueOf(this.repoURL) + "||||" + destinationObjectRelativeFileURI;
            String[] proxies = null;
            proxies = node.getProperty("hawkProxyRef:" + destinationObjectFullFileURI);
            proxies = new Utils().addToElementProxies(proxies, destinationObjectFullPathURI, edgelabel, isContainment, isContainer);
            node.setProperty("hawkProxyRef:" + destinationObjectFullFileURI, (Object)proxies);
            IGraphNodeIndex proxyDictionary = this.graph.getOrCreateNodeIndex("proxydictionary");
            proxyDictionary.add(node, "hawkProxyRef:", (Object)destinationObjectFullFileURI);
        }
        catch (Exception e) {
            LOGGER.error("proxydictionary error", (Throwable)e);
            return false;
        }
        return true;
    }

    private void updateNodeProperties(IGraphNode fileNode, IGraphNode node, IHawkObject eObject) {
        Object[] ret;
        Object r;
        Object first;
        boolean primitiveOrWrapperClass;
        Class<?> elemClass;
        Collection srcCollection;
        AbstractCollection collection;
        LinkedList<IHawkAttribute> normalattributes = new LinkedList<IHawkAttribute>();
        LinkedList<IHawkAttribute> indexedattributes = new LinkedList<IHawkAttribute>();
        IGraphNode typenode = ((IGraphEdge)node.getOutgoingWithType("_hawkOfType").iterator().next()).getEndNode();
        CompositeGraphChangeListener listener = this.indexer.getCompositeGraphChangeListener();
        for (IHawkAttribute eAttribute : ((IHawkClass)eObject.getType()).getAllAttributes()) {
            String attrName = eAttribute.getName();
            if (eObject.isSet((IHawkStructuralFeature)eAttribute)) {
                String[] propValue = (String[])typenode.getProperty(attrName);
                if (propValue != null && "t".equals(propValue[5])) {
                    indexedattributes.add(eAttribute);
                }
                normalattributes.add(eAttribute);
                continue;
            }
            if (node.getProperty(attrName) == null) continue;
            node.removeProperty(attrName);
            this.indexer.getCompositeGraphChangeListener().modelElementAttributeRemoval(this.commitItem, eObject, eAttribute.getName(), node, false);
        }
        for (IHawkAttribute a : normalattributes) {
            Object oldproperty = node.getProperty(a.getName());
            Object newproperty = eObject.get(a);
            if (!a.isMany()) {
                Object newValue = newproperty;
                if (newValue instanceof Date) {
                    newValue = this.formatDate((Date)newValue);
                } else if (!GraphUtil.isPrimitiveOrWrapperType(newproperty.getClass())) {
                    newValue = newValue.toString();
                }
                if (newValue.equals(oldproperty)) continue;
                listener.modelElementAttributeUpdate(this.commitItem, eObject, a.getName(), oldproperty, newValue, node, false);
                node.setProperty(a.getName(), newValue);
                continue;
            }
            collection = null;
            collection = a.isUnique() ? new LinkedHashSet() : new LinkedList();
            srcCollection = (Collection)newproperty;
            elemClass = null;
            primitiveOrWrapperClass = false;
            if (!srcCollection.isEmpty()) {
                first = srcCollection.iterator().next();
                elemClass = first.getClass();
                primitiveOrWrapperClass = GraphUtil.isPrimitiveOrWrapperType(elemClass);
                if (primitiveOrWrapperClass) {
                    for (Object o : srcCollection) {
                        collection.add(o);
                    }
                } else if (first instanceof Date) {
                    for (Object o : srcCollection) {
                        collection.add(this.formatDate((Date)o));
                    }
                } else {
                    for (Object o : srcCollection) {
                        collection.add(o.toString());
                    }
                }
            }
            r = null;
            r = primitiveOrWrapperClass && elemClass != null ? Array.newInstance(elemClass, collection.size()) : Array.newInstance(String.class, collection.size());
            ret = collection.toArray((Object[])r);
            if (ret.equals(oldproperty)) continue;
            listener.modelElementAttributeUpdate(this.commitItem, eObject, a.getName(), oldproperty, (Object)ret, node, false);
            node.setProperty(a.getName(), (Object)ret);
        }
        for (IHawkAttribute a : indexedattributes) {
            IGraphNodeIndex i = this.graph.getOrCreateNodeIndex(String.valueOf(eObject.getType().getPackageNSURI()) + "##" + eObject.getType().getName() + "##" + a.getName());
            Object v = eObject.get(a);
            if (!a.isMany()) {
                if (GraphUtil.isPrimitiveOrWrapperType(v.getClass())) {
                    i.add(node, a.getName(), v);
                    continue;
                }
                if (v instanceof Date) {
                    i.add(node, a.getName(), this.formatDate((Date)v));
                    continue;
                }
                i.add(node, a.getName(), (Object)v.toString());
                continue;
            }
            collection = null;
            collection = a.isUnique() ? new LinkedHashSet() : new LinkedList();
            srcCollection = (Collection)v;
            elemClass = null;
            primitiveOrWrapperClass = false;
            if (!srcCollection.isEmpty()) {
                first = srcCollection.iterator().next();
                elemClass = first.getClass();
                primitiveOrWrapperClass = GraphUtil.isPrimitiveOrWrapperType(elemClass);
                if (primitiveOrWrapperClass) {
                    for (Object o : srcCollection) {
                        collection.add(o);
                    }
                } else if (first instanceof Date) {
                    for (Object o : srcCollection) {
                        collection.add(this.formatDate((Date)o));
                    }
                } else {
                    for (Object o : srcCollection) {
                        collection.add(o.toString());
                    }
                }
            }
            r = null;
            r = primitiveOrWrapperClass && elemClass != null ? Array.newInstance(elemClass, 1) : Array.newInstance(String.class, 1);
            ret = collection.toArray((Object[])r);
            i.add(node, a.getName(), (Object)ret);
        }
        IGraphNodeIndex rootDictionary = this.graph.getOrCreateNodeIndex("rootdictionary");
        if (eObject.isRoot()) {
            rootDictionary.add(node, "file", fileNode.getId());
        } else {
            rootDictionary.remove(node);
        }
    }

    private boolean batchUpdate(boolean verbose) throws Exception {
        if (verbose) {
            this.indexer.getCompositeStateListener().info("Performing batch update of file: " + this.commitItem.getPath() + "...");
        }
        CompositeGraphChangeListener listener = this.indexer.getCompositeGraphChangeListener();
        listener.changeStart();
        try {
            IGraphNode g = new Utils().getFileNodeFromVCSCommitItem(this.graph, this.commitItem);
            if (g != null) {
                Throwable throwable = null;
                Object var5_7 = null;
                try (IGraphTransaction t = this.graph.beginTransaction();){
                    this.deletionUtils.get().deleteAll(g, this.commitItem, (IGraphChangeListener)listener);
                    t.success();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.graph.enterBatchMode();
            new GraphModelBatchInjector(this.indexer, this.deletionUtils, this.typeCache, this.commitItem, this.resource, (IGraphChangeListener)listener, verbose);
            listener.changeSuccess();
            return true;
        }
        catch (Exception ex) {
            listener.changeFailure();
            return false;
        }
        finally {
            if (verbose) {
                this.indexer.getCompositeStateListener().info("Performed batch update of file: " + this.commitItem.getPath() + ".");
            }
        }
    }

    private double calculateModelDeltaRatio(boolean verbose) throws Exception {
        IGraphNode fileNode;
        if (verbose) {
            LOGGER.info("calculateModelDeltaSize() called");
        }
        if ((fileNode = new Utils().getFileNodeFromVCSCommitItem(this.graph, this.commitItem)) != null) {
            return this.calculateModelDeltaRatio(fileNode, verbose);
        }
        if (verbose) {
            LOGGER.info("File not in store, performing initial batch file insertion");
        }
        return -1.0;
    }

    protected double calculateModelDeltaRatio(IGraphNode fileNode, boolean verbose) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (IGraphTransaction t = this.graph.beginTransaction();){
            HashMap<String, byte[]> signatures = new HashMap<String, byte[]>();
            for (IGraphEdge e : fileNode.getIncomingWithType("_hawkFile")) {
                IGraphNode n = e.getStartNode();
                this.nodes.put(n.getProperty("_hawkid").toString(), n);
                signatures.put((String)n.getProperty("_hawkid"), (byte[])n.getProperty("_hawksignature"));
            }
            if (verbose) {
                LOGGER.info("File contains: {} ({}) nodes in store", (Object)this.nodes.size(), (Object)signatures.size());
            }
            for (IHawkObject o : this.resource.getAllContents()) {
                String uriFragment = o.getUriFragment();
                byte[] hash = (byte[])signatures.get(uriFragment);
                if (hash != null) {
                    if (!Arrays.equals(hash, o.signature())) {
                        IGraphNode node;
                        Iterator typeEdges;
                        IGraphNode typeNode;
                        String nodeType;
                        String actualType = o.getType().getName();
                        if (actualType.equals(nodeType = (typeNode = ((IGraphEdge)(typeEdges = (node = this.nodes.get(uriFragment)).getOutgoingWithType("_hawkOfType").iterator()).next()).getEndNode()).getProperty("_hawkid").toString())) {
                            this.updated.put(uriFragment, o);
                            continue;
                        }
                        this.retyped.put(uriFragment, o);
                        continue;
                    }
                    this.unchanged.put(uriFragment, o);
                    continue;
                }
                this.added.put(uriFragment, o);
            }
            t.success();
            int addedn = this.added.size();
            int retypedn = this.retyped.size();
            int updatedn = this.updated.size();
            int deletedn = this.nodes.size() - this.unchanged.size() - updatedn - retypedn;
            double ratio = (double)(addedn + retypedn + updatedn + deletedn) / (double)this.nodes.size();
            if (verbose) {
                LOGGER.info("Update contains | a:{} u:{} d:{} ratio: {}", new Object[]{addedn + retypedn, updatedn, deletedn, ratio});
            }
            return ratio;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean addNodes(boolean verbose) throws Exception {
        if (verbose) {
            this.indexer.getCompositeStateListener().info("Performing batch insert on file: " + this.commitItem.getPath() + "...");
        }
        boolean success = true;
        if (this.resource != null) {
            GraphModelBatchInjector batch = new GraphModelBatchInjector(this.indexer, this.deletionUtils, this.typeCache, this.commitItem, this.resource, (IGraphChangeListener)this.indexer.getCompositeGraphChangeListener(), verbose);
            success = batch.getSuccess();
            if (!success) {
                LOGGER.error("model insertion aborted: see above error (maybe you need to register the metamodel?)");
            }
        } else {
            LOGGER.error("model insertion aborted, see above error (maybe you need to register the metamodel?)");
        }
        if (verbose) {
            this.indexer.getCompositeStateListener().info("Performed batch insert on file: " + this.commitItem.getPath() + ".");
        }
        return success;
    }

    protected void remove(IGraphNode modelElement, String repositoryURL, IGraphNode fileNode, IGraphChangeListener l) {
        DeletionUtils del = this.deletionUtils.get();
        del.dereference(modelElement, l, this.commitItem);
        del.makeProxyRefs(this.commitItem, modelElement, repositoryURL, fileNode, l);
        if (del.delete(modelElement)) {
            l.modelElementRemoval(this.commitItem, modelElement, false);
        }
    }

    public void resolveProxies(IGraphDatabase graph) throws Exception {
        long start = System.currentTimeMillis();
        CompositeGraphChangeListener listener = this.indexer.getCompositeGraphChangeListener();
        List<ProxyReferenceList> proxyReferenceLists = ProxyReferenceList.getLists(graph);
        int nToBeProcessed = 0;
        HashMap<ProxyReferenceTarget, ArrayList<ProxyReferenceList.ProxyReference>> refsByTargetFile = new HashMap<ProxyReferenceTarget, ArrayList<ProxyReferenceList.ProxyReference>>();
        for (ProxyReferenceList list : proxyReferenceLists) {
            ArrayList<ProxyReferenceList.ProxyReference> refs = (ArrayList<ProxyReferenceList.ProxyReference>)refsByTargetFile.get(list.getTargetFile());
            if (refs == null) {
                refs = new ArrayList<ProxyReferenceList.ProxyReference>();
                refsByTargetFile.put(list.getTargetFile(), refs);
            }
            refs.addAll(list.getReferences());
            nToBeProcessed += list.getReferences().size();
        }
        long startMillis = System.currentTimeMillis();
        int totalProcessed = 0;
        int currentProcessed = 0;
        int totalResolved = 0;
        Iterator itTargetFiles = refsByTargetFile.entrySet().iterator();
        if (nToBeProcessed > 0) {
            this.indexer.getCompositeStateListener().info(String.format("Processing %d/%d proxy references (%d sec total)", totalProcessed, nToBeProcessed, (System.currentTimeMillis() - startMillis) / 1000L));
        }
        while (itTargetFiles.hasNext()) {
            Map.Entry entry = itTargetFiles.next();
            ProxyReferenceTarget targetFile = (ProxyReferenceTarget)entry.getKey();
            List refs = (List)entry.getValue();
            int iFrom = 0;
            while (iFrom < refs.size()) {
                List<ProxyReferenceList.ProxyReference> sublistRefs = refs.subList(iFrom, Math.min(refs.size(), iFrom + 5000));
                iFrom += 5000;
                try {
                    Throwable throwable = null;
                    Object var20_28 = null;
                    try (IGraphTransaction tx = graph.beginTransaction();){
                        listener.changeStart();
                        IGraphNodeIndex proxyDictionary = graph.getOrCreateNodeIndex("proxydictionary");
                        int nResolved = this.resolveProxies(graph, (IGraphChangeListener)listener, targetFile, sublistRefs, proxyDictionary);
                        totalResolved += nResolved;
                        tx.success();
                        listener.changeSuccess();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable ex) {
                    listener.changeFailure();
                    throw ex;
                }
                if ((currentProcessed += sublistRefs.size()) < 25000) continue;
                totalProcessed += currentProcessed;
                currentProcessed = 0;
                long elapsedSeconds = (System.currentTimeMillis() - startMillis) / 1000L;
                this.indexer.getCompositeStateListener().info(String.format("Processed %d/%d proxy references (%d sec total)", totalProcessed, nToBeProcessed, elapsedSeconds));
            }
        }
        totalProcessed += currentProcessed;
        Throwable throwable = null;
        Object var15_17 = null;
        try (IGraphTransaction tx = graph.beginTransaction();){
            IGraphNodeIndex proxyDictionary = graph.getOrCreateNodeIndex("proxydictionary");
            int proxiesLeft = proxyDictionary.query("hawkProxyRef:", (Object)"*").size();
            LOGGER.info("{} proxy ref lists left after resolving {} refs", (Object)proxiesLeft, (Object)totalResolved);
            tx.success();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        LOGGER.info("proxy resolution took: ~{}s", (Object)((double)(System.currentTimeMillis() - start) / 1000.0));
    }

    private int resolveProxies(IGraphDatabase graph, IGraphChangeListener listener, ProxyReferenceTarget targetFile, List<ProxyReferenceList.ProxyReference> references, IGraphNodeIndex proxyDictionary) throws Exception {
        HashMap<String, List<ProxyReferenceList.ProxyReference>> refsByURI = new HashMap<String, List<ProxyReferenceList.ProxyReference>>();
        HashSet<ProxyReferenceList> refLists = new HashSet<ProxyReferenceList>();
        for (ProxyReferenceList.ProxyReference ref : references) {
            LinkedList<ProxyReferenceList.ProxyReference> refs = (LinkedList<ProxyReferenceList.ProxyReference>)refsByURI.get(ref.getTarget().getElementURI());
            if (refs == null) {
                refs = new LinkedList<ProxyReferenceList.ProxyReference>();
                refsByURI.put(ref.getTarget().getElementURI(), refs);
            }
            refs.add(ref);
            refLists.add(ref.getList());
        }
        HashSet<ProxyReferenceList> changed = new HashSet<ProxyReferenceList>();
        int resolved = 0;
        resolved = targetFile.isFragmentBased() ? (resolved += this.resolveProxiesByFragment(graph, listener, refsByURI, changed)) : (resolved += this.resolveProxiesByPath(graph, listener, targetFile, refsByURI, changed));
        for (ProxyReferenceList list : changed) {
            IGraphNode sourceNode = graph.getNodeById(list.getSourceNodeID());
            String fullPathURI = list.getFullPathURI();
            if (list.getReferences().isEmpty()) {
                int nBefore;
                sourceNode.removeProperty("hawkProxyRef:" + fullPathURI);
                boolean assertsEnabled = false;
                if (!$assertionsDisabled) {
                    assertsEnabled = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                int n = nBefore = assertsEnabled ? proxyDictionary.query("hawkProxyRef:", (Object)fullPathURI).size() : 0;
                assert (nBefore > 0) : "Proxy reference " + fullPathURI + " was listed before removal";
                proxyDictionary.remove(sourceNode, "hawkProxyRef:", (Object)fullPathURI);
                assert (proxyDictionary.query("hawkProxyRef:", (Object)fullPathURI).size() < nBefore) : "Proxy reference " + fullPathURI + " removal was effective";
                continue;
            }
            sourceNode.setProperty("hawkProxyRef:" + fullPathURI, (Object)list.toArray());
        }
        return resolved;
    }

    private int resolveProxiesByPath(IGraphDatabase graph, IGraphChangeListener listener, ProxyReferenceTarget targetFile, Map<String, List<ProxyReferenceList.ProxyReference>> refsByURI, Set<ProxyReferenceList> changed) throws Exception {
        int resolved = 0;
        IGraphNode fileNode = this.getFileNode(graph, targetFile.getRepositoryURL(), targetFile.getFilePath());
        Iterable<IGraphEdge> fileRels = GraphModelInserter.allNodesWithFile(fileNode);
        if (fileRels != null) {
            for (IGraphEdge r : fileRels) {
                IGraphNode targetNode = r.getStartNode();
                String nodeURI = String.valueOf(targetFile.getFileURI()) + "#" + targetNode.getProperty("_hawkid").toString();
                List<ProxyReferenceList.ProxyReference> pendingRefs = refsByURI.get(nodeURI);
                if (pendingRefs == null) continue;
                Iterator<ProxyReferenceList.ProxyReference> itPendingRefs = pendingRefs.iterator();
                while (itPendingRefs.hasNext()) {
                    ProxyReferenceList.ProxyReference pendingRef = itPendingRefs.next();
                    IGraphNode sourceNode = graph.getNodeById(pendingRef.getList().getSourceNodeID());
                    boolean edgeCreated = new GraphModelBatchInjector(graph, this.typeCache, null, listener).resolveProxyRef(sourceNode, targetNode, pendingRef.getEdgeLabel(), pendingRef.isContainment(), pendingRef.isContainer());
                    itPendingRefs.remove();
                    ++resolved;
                    pendingRef.getList().getReferences().remove(pendingRef);
                    changed.add(pendingRef.getList());
                    if (!edgeCreated) continue;
                    listener.referenceAddition(this.commitItem, sourceNode, targetNode, pendingRef.getEdgeLabel(), false);
                }
            }
        }
        return resolved;
    }

    private int resolveProxiesByFragment(IGraphDatabase graph, IGraphChangeListener listener, Map<String, List<ProxyReferenceList.ProxyReference>> refsByURI, Set<ProxyReferenceList> changed) throws Exception {
        int resolved = 0;
        IGraphNodeIndex fragDictionary = graph.getOrCreateNodeIndex("fragmentdictionary");
        for (List<ProxyReferenceList.ProxyReference> refs : refsByURI.values()) {
            Iterator<ProxyReferenceList.ProxyReference> itPendingRefs = refs.iterator();
            while (itPendingRefs.hasNext()) {
                ProxyReferenceList.ProxyReference ref = itPendingRefs.next();
                String fragment = ref.getTarget().getFragment();
                Iterator targetNodes = fragDictionary.get("id", (Object)fragment).iterator();
                if (!targetNodes.hasNext()) continue;
                IGraphNode sourceNode = graph.getNodeById(ref.getList().getSourceNodeID());
                IGraphNode targetNode = (IGraphNode)targetNodes.next();
                boolean edgeCreated = new GraphModelBatchInjector(graph, this.typeCache, null, listener).resolveProxyRef(sourceNode, targetNode, ref.getEdgeLabel(), ref.isContainment(), ref.isContainer());
                itPendingRefs.remove();
                ++resolved;
                ref.getList().getReferences().remove(ref);
                changed.add(ref.getList());
                if (!edgeCreated) continue;
                listener.referenceAddition(this.commitItem, sourceNode, targetNode, ref.getEdgeLabel(), false);
            }
        }
        return resolved;
    }

    public int resolveDerivedAttributeProxies(String type) throws Exception {
        IGraphIterable allUnresolved = null;
        IGraphNodeIndex derivedProxyDictionary = null;
        int size = 0;
        LOGGER.info("Deriving attributes...");
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (IGraphTransaction tx = this.graph.beginTransaction();){
            derivedProxyDictionary = this.graph.getOrCreateNodeIndex("derivedproxydictionary");
            allUnresolved = derivedProxyDictionary.query("derived", (Object)"*");
            size = allUnresolved.size();
            tx.success();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        if (size > 0) {
            this.processDerivedFeatureNodes(type, (Iterable<? extends IGraphNode>)allUnresolved, size);
        }
        int derivedLeft = -1;
        throwable2 = null;
        Object var7_11 = null;
        try (IGraphTransaction tx = this.graph.beginTransaction();){
            derivedLeft = derivedProxyDictionary.query("derived", (Object)"*").size();
            tx.success();
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        LOGGER.info("{} - sets of proxy [derived] attributes left incomplete in the store", (Object)derivedLeft);
        return derivedLeft;
    }

    protected void processDerivedFeatureNodes(String type, Iterable<? extends IGraphNode> derivedFeatureNodes, int nNodes) throws InvalidQueryException, QueryExecutionException, Exception {
        Iterator<? extends IGraphNode> itUnresolved;
        long startMillis = System.currentTimeMillis();
        IQueryEngine q = (IQueryEngine)this.indexer.getKnownQueryLanguages().get(type);
        Throwable throwable = null;
        Object var9_9 = null;
        try (IGraphTransaction tx = this.graph.beginTransaction();){
            itUnresolved = derivedFeatureNodes.iterator();
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int count = 0;
        boolean done = false;
        while (!done) {
            Throwable throwable3 = null;
            Object var11_15 = null;
            try (IGraphTransaction tx = this.graph.beginTransaction();){
                IGraphNode sourceNode;
                long startChunkMillis = System.currentTimeMillis();
                ArrayList<IGraphNode> chunk = new ArrayList<IGraphNode>(1000);
                int i = 0;
                while (i < 1000 && itUnresolved.hasNext()) {
                    chunk.add(itUnresolved.next());
                    ++i;
                }
                done = !itUnresolved.hasNext();
                IGraphNodeIndex derivedAccessDictionary = this.graph.getOrCreateNodeIndex(DERIVED_ACCESS_IDXNAME);
                IAccessListener accessListener = q.calculateDerivedAttributes(this.indexer, chunk);
                for (IAccess a : accessListener.getAccesses()) {
                    sourceNode = this.graph.getNodeById((Object)a.getSourceObjectID());
                    derivedAccessDictionary.remove(sourceNode);
                }
                for (IAccess a : accessListener.getAccesses()) {
                    sourceNode = this.graph.getNodeById((Object)a.getSourceObjectID());
                    derivedAccessDictionary.add(sourceNode, a.getAccessObjectID(), (Object)a.getProperty());
                }
                accessListener.resetAccesses();
                tx.success();
                long now = System.currentTimeMillis();
                long chunkMillis = now - startChunkMillis;
                long totalMillis = now - startMillis;
                this.indexer.getCompositeStateListener().info(String.format("Processed %d/%d derived feature nodes of type '%s' (%d s, %d s total)", count += chunk.size(), nNodes, type, chunkMillis / 1000L, totalMillis / 1000L));
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
        }
    }

    public void updateDerivedAttributes(String type, Set<IGraphNode> nodesToBeUpdated) throws Exception {
        CompositeGraphChangeListener listener = this.indexer.getCompositeGraphChangeListener();
        IQueryEngine q = (IQueryEngine)this.indexer.getKnownQueryLanguages().get(type);
        if (q == null) {
            throw new IllegalArgumentException("Cannot derive attributes - query engine " + type + " is disabled");
        }
        IAccessListener accessListener = q.calculateDerivedAttributes(this.indexer, (Iterable)new ReloadNodeCollectionIterable(nodesToBeUpdated));
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (IGraphTransaction tx = this.graph.beginTransaction();){
                IGraphNode sourceNode;
                listener.changeStart();
                IGraphNodeIndex derivedAccessDictionary = this.graph.getOrCreateNodeIndex(DERIVED_ACCESS_IDXNAME);
                for (IAccess a : accessListener.getAccesses()) {
                    sourceNode = this.graph.getNodeById((Object)a.getSourceObjectID());
                    if (sourceNode == null) continue;
                    derivedAccessDictionary.remove(sourceNode);
                }
                for (IAccess a : accessListener.getAccesses()) {
                    sourceNode = this.graph.getNodeById((Object)a.getSourceObjectID());
                    if (sourceNode == null) continue;
                    derivedAccessDictionary.add(sourceNode, a.getAccessObjectID(), (Object)a.getProperty());
                }
                tx.success();
                listener.changeSuccess();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            listener.changeFailure();
            throw e;
        }
    }

    private static Iterable<IGraphEdge> allNodesWithFile(IGraphNode fileNode) {
        if (fileNode != null) {
            return fileNode.getIncomingWithType("_hawkFile");
        }
        return null;
    }

    private IGraphNode getFileNode(IGraphDatabase graph, String repositoryURL, String file) {
        if (!file.startsWith("/")) {
            file = "/" + file;
        }
        IGraphNodeIndex filedictionary = graph.getFileIndex();
        IGraphNode fileNode = null;
        try {
            String idSameRepo = String.valueOf(repositoryURL) + "||||" + file;
            IGraphIterable itNodes = filedictionary.get("id", (Object)idSameRepo);
            if (itNodes.size() > 0) {
                fileNode = (IGraphNode)itNodes.getSingle();
            } else {
                file = file.replaceFirst("^/", "");
                for (IVcsManager vcs : this.indexer.getRunningVCSManagers()) {
                    if (!file.startsWith(vcs.getLocation())) continue;
                    String subpath = file.substring(vcs.getLocation().length());
                    if (!subpath.startsWith("/")) {
                        subpath = "/" + subpath;
                    }
                    fileNode = this.getFileNode(graph, vcs.getLocation(), subpath);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return fileNode;
    }

    public void updateDerivedAttribute(String metamodelUri, String typeName, String attributeName, String attributeType, boolean isMany, boolean isOrdered, boolean isUnique, String derivationlanguage, String derivationlogic) {
        long startMillis = System.currentTimeMillis();
        LOGGER.info("Creating / updating derived attribute {}::{}#{}", new Object[]{metamodelUri, typeName, attributeName});
        HashSet<IGraphNode> derivedPropertyNodes = new HashSet<IGraphNode>();
        try {
            Throwable throwable = null;
            Object var14_16 = null;
            try (IGraphTransaction tx = this.graph.beginTransaction();){
                IGraphNode metamodelNode = (IGraphNode)this.graph.getMetamodelIndex().get("id", (Object)metamodelUri).getSingle();
                IGraphNode typeNode = null;
                for (IGraphEdge e : metamodelNode.getIncomingWithType("epackage")) {
                    IGraphNode othernode = e.getStartNode();
                    if (!othernode.getProperty("_hawkid").equals(typeName)) continue;
                    typeNode = othernode;
                    break;
                }
                HashSet<IGraphNode> nodes = new HashSet<IGraphNode>();
                for (IGraphEdge e : typeNode.getIncomingWithType("_hawkOfKind")) {
                    nodes.add(e.getStartNode());
                }
                for (IGraphNode instanceNode : nodes) {
                    IGraphNode derivedPropertyNode;
                    Iterator derived = instanceNode.getOutgoingWithType(attributeName).iterator();
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("isMany", isMany);
                    m.put("isOrdered", isOrdered);
                    m.put("isUnique", isUnique);
                    m.put(DERIVED_ATTR_TYPE, attributeType);
                    m.put("derivationlanguage", derivationlanguage);
                    m.put(DERIVED_ATTR_LOGIC, derivationlogic);
                    m.put(DERIVED_IDXNAME_NODEPROP, String.format("%s##%s##%s", metamodelUri, typeName, attributeName));
                    m.put(attributeName, "_NYD##" + derivationlogic);
                    if (derived.hasNext()) {
                        derivedPropertyNode = ((IGraphEdge)derived.next()).getEndNode();
                        for (String s : m.keySet()) {
                            derivedPropertyNode.setProperty(s, m.get(s));
                        }
                        derivedPropertyNodes.add(derivedPropertyNode);
                        continue;
                    }
                    derivedPropertyNode = this.graph.createNode(m, "derivedattribute");
                    m.clear();
                    m.put(DERIVED_FEATURE_EDGEPROP, true);
                    this.graph.createRelationship(instanceNode, derivedPropertyNode, attributeName, m);
                    derivedPropertyNodes.add(derivedPropertyNode);
                }
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            this.processDerivedFeatureNodes(derivationlanguage, derivedPropertyNodes, derivedPropertyNodes.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        LOGGER.info("Finished adding derived feature in {}s", (Object)((double)(System.currentTimeMillis() - startMillis) / 1000.0));
    }

    public void updateIndexedAttribute(String metamodeluri, String typename, String attributename) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (IGraphTransaction tx = this.graph.beginTransaction();){
                IGraphNodeIndex i = this.graph.getOrCreateNodeIndex(String.valueOf(metamodeluri) + "##" + typename + "##" + attributename);
                IGraphNode typeNode = null;
                for (IGraphEdge r : ((IGraphNode)this.graph.getMetamodelIndex().get("id", (Object)metamodeluri).getSingle()).getIncomingWithType("epackage")) {
                    IGraphNode othernode = r.getStartNode();
                    if (!othernode.getProperty("_hawkid").equals(typename)) continue;
                    typeNode = othernode;
                    break;
                }
                String[] metadata = (String[])typeNode.getProperty(attributename);
                boolean isPrimitiveOrWrapperType = false;
                Class c = String.class;
                try {
                    c = Class.forName(metadata[4]);
                    isPrimitiveOrWrapperType = GraphUtil.isPrimitiveOrWrapperType(c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                HashSet<IGraphNode> nodes = new HashSet<IGraphNode>();
                for (IGraphEdge e : typeNode.getIncomingWithType("_hawkOfKind")) {
                    nodes.add(e.getStartNode());
                }
                for (IGraphNode node : nodes) {
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    Object value = node.getProperty(attributename);
                    if (!"t".equals(metadata[1])) {
                        if (isPrimitiveOrWrapperType) {
                            m.put(attributename, value);
                        } else if (value instanceof Date) {
                            m.put(attributename, this.formatDate((Date)value));
                        } else {
                            m.put(attributename, value.toString());
                        }
                    } else {
                        AbstractCollection collection = null;
                        collection = "t".equals(metadata[3]) ? new LinkedHashSet() : new LinkedList();
                        for (Object o : (Collection)value) {
                            if (isPrimitiveOrWrapperType) {
                                collection.add(o);
                                continue;
                            }
                            if (o instanceof Date) {
                                collection.add(this.formatDate((Date)o));
                                continue;
                            }
                            collection.add(o.toString());
                        }
                        if (collection.size() > 0) {
                            Object r = Array.newInstance(c, collection.size());
                            Object[] ret = collection.toArray((Object[])r);
                            m.put(attributename, ret);
                        }
                    }
                    i.add(node, m);
                }
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Object formatDate(Date value) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return sdf.format(value);
    }

    protected class ReloadNodeCollectionIterable
    implements Iterable<IGraphNode> {
        private final Iterable<IGraphNode> nodes;

        protected ReloadNodeCollectionIterable(Iterable<IGraphNode> nodesToBeUpdated) {
            this.nodes = nodesToBeUpdated;
        }

        @Override
        public Iterator<IGraphNode> iterator() {
            final Iterator<IGraphNode> itNodes = this.nodes.iterator();
            return new Iterator<IGraphNode>(){

                @Override
                public boolean hasNext() {
                    return itNodes.hasNext();
                }

                @Override
                public IGraphNode next() {
                    Object id = ((IGraphNode)itNodes.next()).getId();
                    return GraphModelInserter.this.indexer.getGraph().getNodeById(id);
                }
            };
        }
    }
}

