/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph.updater;

import java.util.Iterator;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.model.IHawkClass;

public class MetamodelUtils {
    public static String eClassNSURI(IHawkClass e) {
        return e.getName();
    }

    public static boolean isOfType(IGraphNode node, String type) {
        boolean found = false;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (IGraphTransaction tx = node.getGraph().beginTransaction();){
                Iterator it = node.getOutgoingWithType("_hawkOfType").iterator();
                while (it.hasNext()) {
                    IGraphNode nn = ((IGraphEdge)it.next()).getEndNode();
                    if (!nn.getProperty("_hawkid").toString().equals(type)) continue;
                    found = true;
                }
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return found;
    }

    public String eClassFullNSURI(IHawkClass e) {
        return String.valueOf(e.getPackageNSURI()) + "/" + e.getName();
    }

    public String typeOfName(IGraphNode node) {
        String ret = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (IGraphTransaction tx = node.getGraph().beginTransaction();){
                try {
                    ret = ((IGraphEdge)node.getOutgoingWithType("_hawkOfType").iterator().next()).getEndNode().getProperty("_hawkid").toString();
                }
                catch (Exception e) {
                    System.err.println("Exception in typeOfName(Node node)");
                }
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public IGraphNode getClassNode(IGraphDatabase graph, String metaClassName) {
        IGraphNode cl = null;
        IGraphNode ret = null;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (IGraphTransaction tx = graph.beginTransaction();){
                IGraphNodeIndex epackagedictionary = graph.getMetamodelIndex();
                IGraphNode ep = null;
                if (metaClassName.contains("::")) {
                    ep = (IGraphNode)epackagedictionary.get("id", (Object)metaClassName).getSingle();
                    for (IGraphEdge r : ep.getIncomingWithType("epackage")) {
                        cl = r.getStartNode();
                        if (!cl.getProperty("_hawkid").equals(metaClassName.substring(metaClassName.indexOf("::") + 2))) continue;
                        ret = cl;
                    }
                } else {
                    IGraphIterable eps = epackagedictionary.query("id", (Object)"*");
                    for (IGraphNode epp : eps) {
                        for (IGraphEdge r : epp.getIncomingWithType("epackage")) {
                            cl = r.getStartNode();
                            if (!cl.getProperty("_hawkid").equals(metaClassName)) continue;
                            ret = cl;
                        }
                    }
                }
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

