/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.server.users.servlet.db;

import java.io.File;
import org.apache.shiro.authc.credential.DefaultPasswordService;
import org.apache.shiro.authc.credential.HashingPasswordService;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.HashService;
import org.eclipse.hawk.service.server.users.servlet.db.User;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.mapdb.TxBlock;
import org.mapdb.TxMaker;
import org.mapdb.TxRollbackException;

public class UserStorage {
    private TxMaker txMaker;
    private static final int HASH_ITERATIONS = 10000;
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_USER_PW = "password";

    public static HashingPasswordService getPasswordService() {
        DefaultHashService hashService = new DefaultHashService();
        hashService.setHashIterations(10000);
        hashService.setHashAlgorithmName("SHA-512");
        hashService.setGeneratePublicSalt(true);
        DefaultPasswordService passwordService = new DefaultPasswordService();
        passwordService.setHashService((HashService)hashService);
        return passwordService;
    }

    public UserStorage(File dataFile) {
        DBMaker dbMaker = DBMaker.newFileDB((File)dataFile).closeOnJvmShutdown().checksumEnable();
        DB db = dbMaker.make();
        this.getUserMap(db);
        this.txMaker = dbMaker.makeTxMaker();
        this.txMaker.execute(new TxBlock(){

            public void tx(DB db) throws TxRollbackException {
                BTreeMap<String, User> userMap = UserStorage.this.getUserMap(db);
                if (userMap.isEmpty()) {
                    String hashed = UserStorage.getPasswordService().encryptPassword((Object)UserStorage.DEFAULT_USER_PW);
                    User user = User.builder().username(UserStorage.DEFAULT_USER).hashedPassword(hashed).build();
                    userMap.put((Object)UserStorage.DEFAULT_USER, (Object)user);
                }
            }
        });
    }

    public TxMaker getTxMaker() {
        return this.txMaker;
    }

    public void close() {
        this.txMaker.close();
    }

    public BTreeMap<String, User> getUserMap(DB db) {
        return db.createTreeMap("users").keySerializer(BTreeKeySerializer.STRING).valueSerializer(Serializer.JAVA).counterEnable().makeOrGet();
    }
}

