/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.servlet.processors;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseProcessor;
import org.apache.thrift.TProcessor;
import org.eclipse.hawk.service.api.Hawk;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.artemis.server.Server;
import org.eclipse.hawk.service.servlet.processors.HawkThriftIface;
import org.eclipse.hawk.service.servlet.processors.IAuthenticatedProcessorFactory;

public class HawkThriftProcessorFactory
implements IAuthenticatedProcessorFactory {
    private final APIUtils.ThriftProtocol protocol;
    private Server artemisServer;
    private Map<String, ProcessFunction<Hawk.Iface, ? extends TBase>> processMap;

    public HawkThriftProcessorFactory(APIUtils.ThriftProtocol protocol) {
        this.protocol = protocol;
        this.processMap = new Hawk.Processor((Hawk.Iface)new HawkThriftIface()).getProcessMapView();
    }

    @Override
    public TProcessor create(HttpServletRequest request) {
        return new TBaseProcessor<Hawk.Iface>((Hawk.Iface)new HawkThriftIface(this.protocol, request, this.artemisServer), this.processMap){};
    }

    public Server getArtemisServer() {
        return this.artemisServer;
    }

    public void setArtemisServer(Server artemisServer) {
        this.artemisServer = artemisServer;
    }

    public APIUtils.ThriftProtocol getProtocol() {
        return this.protocol;
    }
}

