/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emfresource.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.core.model.IHawkPackage;
import org.eclipse.hawk.emfresource.impl.LocalHawkResourceImpl;
import org.eclipse.hawk.graph.ModelElementNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LocalHawkResourceUpdater
implements IGraphChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalHawkResourceUpdater.class);
    private final LocalHawkResourceImpl resource;
    private final Map<IGraphNode, EClass> addedRootNodes = new HashMap<IGraphNode, EClass>();
    private final Set<IGraphNode> removedNodes = new HashSet<IGraphNode>();
    private final Set<IGraphNode> updatedNodes = new HashSet<IGraphNode>();

    public LocalHawkResourceUpdater(LocalHawkResourceImpl r) {
        this.resource = r;
    }

    public void setModelIndexer(IModelIndexer m) {
    }

    public void synchroniseStart() {
    }

    public void synchroniseEnd() {
        for (Runnable r : this.resource.getSyncEndListeners()) {
            r.run();
        }
    }

    public void changeStart() {
    }

    /*
     * WARNING - void declaration
     */
    public void changeSuccess() {
        for (IGraphNode removedNode : this.removedNodes) {
            this.resource.removeNode(removedNode.getId().toString());
            this.resource.setModified(true);
        }
        this.updatedNodes.removeAll(this.removedNodes);
        ArrayList<ModelElementNode> elems = new ArrayList<ModelElementNode>();
        for (IGraphNode iGraphNode : this.addedRootNodes.keySet()) {
            ModelElementNode addedME = new ModelElementNode(iGraphNode);
            elems.add(addedME);
            this.resource.setModified(true);
        }
        for (IGraphNode iGraphNode : this.updatedNodes) {
            ModelElementNode updatedME = new ModelElementNode(iGraphNode);
            elems.add(updatedME);
            this.resource.setModified(true);
        }
        try {
            Throwable throwable = null;
            Iterator<IGraphNode> iterator = null;
            try (IGraphTransaction tx = this.resource.beginGraphTransaction();){
                this.resource.createOrUpdateEObjects(elems);
                tx.success();
            }
            catch (Throwable throwable2) {
                void var2_9;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var2_9;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error while updating resource", (Throwable)exception);
            this.addedRootNodes.clear();
            this.removedNodes.clear();
            this.updatedNodes.clear();
        }
    }

    public void changeFailure() {
        this.addedRootNodes.clear();
        this.removedNodes.clear();
        this.updatedNodes.clear();
    }

    public void metamodelAddition(IHawkPackage pkg, IGraphNode pkgNode) {
    }

    public void classAddition(IHawkClass cls, IGraphNode clsNode) {
    }

    public void fileAddition(VcsCommitItem s, IGraphNode fileNode) {
    }

    public void fileRemoval(VcsCommitItem s, IGraphNode fileNode) {
    }

    public void modelElementAddition(VcsCommitItem s, IHawkObject element, IGraphNode elementNode, boolean isTransient) {
        if (isTransient) {
            return;
        }
        IHawkClassifier type = element.getType();
        EPackage.Registry packageRegistry = this.resource.getResourceSet().getPackageRegistry();
        EPackage ePackage = packageRegistry.getEPackage(type.getPackageNSURI());
        EClass eClass = (EClass)ePackage.getEClassifier(type.getName());
        this.addedRootNodes.put(elementNode, eClass);
    }

    public void modelElementRemoval(VcsCommitItem s, IGraphNode elementNode, boolean isTransient) {
        if (isTransient) {
            return;
        }
        String id = elementNode.getId().toString();
        EObject existing = this.resource.getNodeEObject(id);
        if (existing != null) {
            this.removedNodes.add(elementNode);
        }
    }

    public void modelElementAttributeUpdate(VcsCommitItem s, IHawkObject eObject, String attrName, Object oldValue, Object newValue, IGraphNode elementNode, boolean isTransient) {
        if (isTransient) {
            return;
        }
        this.markUpdatedIfExisting(elementNode);
    }

    public void modelElementAttributeRemoval(VcsCommitItem s, IHawkObject eObject, String attrName, IGraphNode elementNode, boolean isTransient) {
        if (isTransient) {
            return;
        }
        this.markUpdatedIfExisting(elementNode);
    }

    public void referenceAddition(VcsCommitItem s, IGraphNode source, IGraphNode destination, String edgelabel, boolean isTransient) {
        EReference eRef;
        EClass destClass;
        EReference eRef2;
        if (isTransient) {
            return;
        }
        this.markUpdatedIfExisting(source);
        EClass sourceClass = this.addedRootNodes.get(source);
        if (sourceClass != null && (eRef2 = (EReference)sourceClass.getEStructuralFeature(edgelabel)) != null && eRef2.isContainer()) {
            this.addedRootNodes.remove(source);
        }
        if ((destClass = this.addedRootNodes.get(destination)) != null && (eRef = (EReference)destClass.getEStructuralFeature(edgelabel)) != null && eRef.isContainment()) {
            this.addedRootNodes.remove(destination);
        }
    }

    public void referenceRemoval(VcsCommitItem s, IGraphNode source, IGraphNode destination, String edgelabel, boolean isTransient) {
        if (isTransient) {
            return;
        }
        this.markUpdatedIfExisting(source);
    }

    private void markUpdatedIfExisting(IGraphNode elementNode) {
        String id = elementNode.getId().toString();
        EObject existing = this.resource.getNodeEObject(id);
        if (existing != null) {
            this.updatedNodes.add(elementNode);
        }
    }

    public String getName() {
        return "Local Hawk resource " + this.resource.getURI();
    }
}

