/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.models.Model;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.graph.util.GraphUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHawkModel
extends Model {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHawkModel.class);

    public static Object toPrimitive(Object ret) {
        if (ret == null) {
            return null;
        }
        if (ret instanceof Collection) {
            return "Hawk collection error: nested collections are not supported for derived/indexed attributes";
        }
        if (GraphUtil.isPrimitiveOrWrapperType(ret.getClass())) {
            return ret;
        }
        if (ret instanceof Date) {
            return AbstractHawkModel.formatDate((Date)ret);
        }
        if (ret instanceof EOLQueryEngine.GraphNodeWrapper) {
            return ret;
        }
        return ret.toString();
    }

    protected static String formatDate(Date value) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return sdf.format(value);
    }

    public abstract Collection<Object> getAllOf(String var1, String var2) throws EolModelElementTypeNotFoundException, EolInternalException;

    public abstract Object getFileOf(Object var1);

    public abstract Object getFilesOf(Object var1);

    public abstract Object getBackend();

    public Collection<Object> getAllOfKind(String metaclass) throws EolModelElementTypeNotFoundException {
        try {
            return this.getAllOf(metaclass, "_hawkOfKind");
        }
        catch (EolInternalException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw new EolModelElementTypeNotFoundException(this.getName(), metaclass);
        }
    }

    public Collection<Object> getAllOfType(String metaclass) throws EolModelElementTypeNotFoundException {
        try {
            return this.getAllOf(metaclass, "_hawkOfType");
        }
        catch (EolInternalException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new EolModelElementTypeNotFoundException(this.getName(), metaclass);
        }
    }

    public Object getEnumerationValue(String enumName, String literal) throws EolEnumerationValueNotFoundException {
        return literal;
    }

    public boolean isInstantiable(String arg0) {
        LOGGER.warn("isInstantiable called on a hawk model, this is not supported, returning false");
        return false;
    }

    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        String aliasString;
        super.load(properties, basePath);
        this.name = (String)properties.get((Object)"name");
        if (this.name == null) {
            this.name = "Model";
        }
        if ((aliasString = properties.getProperty("aliases")) != null && aliasString.trim().length() > 0) {
            String[] stringArray = aliasString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                this.aliases.add(alias.trim());
                ++n2;
            }
        }
        this.load();
    }

    public void setElementId(Object arg0, String arg1) {
        LOGGER.warn("This impelementation of IModel does not allow for ElementId to be changed after creation, hence this method does nothing");
    }

    public boolean store() {
        LOGGER.warn("Hawk indices are read-only: ignoring request to store");
        return true;
    }

    public boolean store(String arg0) {
        return this.store();
    }
}

