/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb.indexes;

import java.util.Iterator;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.orientdb.OrientDatabase;
import org.eclipse.hawk.orientdb.indexes.IndexCursorFactoryNodeIterable;
import org.eclipse.hawk.orientdb.indexes.OIndexCursorFactory;

final class IndexCursorFactoriesIterable<T>
implements IGraphIterable<T> {
    private final Iterable<OIndexCursorFactory> iterFactories;
    private final OrientDatabase graph;
    private final Class<T> klass;

    IndexCursorFactoriesIterable(Iterable<OIndexCursorFactory> iterFactories, OrientDatabase graph, Class<T> klass) {
        this.iterFactories = iterFactories;
        this.graph = graph;
        this.klass = klass;
    }

    public Iterator<T> iterator() {
        final Iterator<OIndexCursorFactory> itFactory = this.iterFactories.iterator();
        return new Iterator<T>(){
            Iterator<T> currentIterator = null;

            @Override
            public boolean hasNext() {
                while (this.currentIterator == null || !this.currentIterator.hasNext()) {
                    if (itFactory.hasNext()) {
                        this.currentIterator = new IndexCursorFactoryNodeIterable((OIndexCursorFactory)itFactory.next(), IndexCursorFactoriesIterable.this.graph, IndexCursorFactoriesIterable.this.klass).iterator();
                        continue;
                    }
                    return false;
                }
                return this.currentIterator != null && this.currentIterator.hasNext();
            }

            @Override
            public T next() {
                return this.currentIterator.next();
            }

            @Override
            public void remove() {
                this.currentIterator.remove();
            }
        };
    }

    public int size() {
        int count = 0;
        for (OIndexCursorFactory factory : this.iterFactories) {
            count += new IndexCursorFactoryNodeIterable<T>(factory, this.graph, this.klass).size();
        }
        return count;
    }

    public T getSingle() {
        return this.iterator().next();
    }
}

