/*******************************************************************************
 * Copyright (c) 2011-2015 The University of York.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 3.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-3.0
 *
 * Contributors:
 *     Antonio Garcia-Dominguez - initial API and implementation
 *     Beatriz Sanchez - some UI updates
 ******************************************************************************/
package org.eclipse.hawk.ui2.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.hawk.ui2.Activator;
import org.eclipse.jface.preference.IPreferenceStore;

public class HawkPreferenceInitializer extends AbstractPreferenceInitializer {

	@Override
	public void initializeDefaultPreferences() {
		IPreferenceStore store = Activator.getDefault().getPreferenceStore();
		
		HManager instance = HManager.getInstance();
		store.setDefault(HawkPreferenceConstants.MODEL_PLUGINS, String.join(",", instance.getModelTypes()));
		store.setDefault(HawkPreferenceConstants.METAMODEL_PLUGINS, String.join(",", instance.getMetaModelTypes()));
		
	}

}
