/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc.wrappers;

import java.util.Objects;
import java.util.Set;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;

public class GraphEdgeWrapper {
    private IGraphEdge edge;
    private EOLQueryEngine containerModel;

    public GraphEdgeWrapper(IGraphEdge r, EOLQueryEngine m) {
        this.edge = r;
        this.containerModel = m;
    }

    public IGraphEdge getEdge() {
        return this.edge;
    }

    public String getType() {
        return this.edge.getType();
    }

    public String getName() {
        return this.getType();
    }

    public Object getEndNode() {
        return this.containerModel.wrap(this.edge.getEndNode());
    }

    public Object getTarget() {
        return this.getEndNode();
    }

    public Object getStartNode() {
        return this.containerModel.wrap(this.edge.getStartNode());
    }

    public Object getSource() {
        return this.getStartNode();
    }

    public EOLQueryEngine getContainerModel() {
        return this.containerModel;
    }

    public Set<String> getPropertyKeys() {
        return this.edge.getPropertyKeys();
    }

    public Object getProperty(String name) {
        return this.edge.getProperty(name);
    }

    public Object getFeature(String name) throws EolRuntimeException {
        return this.containerModel.getPropertyGetter().invoke((Object)this, name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.containerModel, this.edge});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphEdgeWrapper other = (GraphEdgeWrapper)obj;
        return Objects.equals((Object)this.containerModel, (Object)other.containerModel) && Objects.equals(this.edge, other.edge);
    }
}

