/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.scopes.annotations;

import java.util.function.Supplier;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNodeIndex;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.eclipse.hawk.timeaware.queries.operations.scopes.EndingTimeAwareNodeWrapper;
import org.eclipse.hawk.timeaware.queries.operations.scopes.annotations.AbstractAnnotatedOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeforeAnnotatedOperation
extends AbstractAnnotatedOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeforeAnnotatedOperation.class);

    public BeforeAnnotatedOperation(Supplier<TimeAwareEOLQueryEngine> containerModelSupplier) {
        super(containerModelSupplier);
    }

    @Override
    protected ITimeAwareGraphNode useAnnotations(ITimeAwareGraphNodeIndex index, ITimeAwareGraphNode taNode, String derivedAttrName) {
        Long firstVersion = index.getEarliestVersionSince(taNode, derivedAttrName, (Object)true);
        if (firstVersion == null) {
            return null;
        }
        try {
            long prevInstant = taNode.travelInTime(firstVersion.longValue()).getPreviousInstant();
            if (prevInstant != -1L) {
                return new EndingTimeAwareNodeWrapper(taNode, prevInstant);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not fetch previous instant", (Throwable)e);
        }
        return null;
    }
}

