/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.orientechnologies.orient.core.cache.ORecordCache;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import java.util.Collection;

public class ORecordCacheGuava
implements ORecordCache {
    private boolean enabled = true;
    private Cache<ORID, ORecord> cache = CacheBuilder.newBuilder().softValues().build();

    public ORecord get(ORID rid) {
        if (!this.isEnabled()) {
            return null;
        }
        return (ORecord)this.cache.getIfPresent((Object)rid);
    }

    public ORecord put(ORecord record) {
        if (!this.isEnabled()) {
            return null;
        }
        ORecord oldValue = (ORecord)this.cache.getIfPresent((Object)record.getIdentity());
        this.cache.put((Object)record.getIdentity(), (Object)record);
        return oldValue;
    }

    public ORecord remove(ORID rid) {
        if (!this.isEnabled()) {
            return null;
        }
        ORecord oldValue = (ORecord)this.cache.getIfPresent((Object)rid);
        this.cache.invalidate((Object)rid);
        return oldValue;
    }

    public void shutdown() {
        this.clear();
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public void startup() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean enable() {
        boolean oldValue = this.enabled;
        this.enabled = true;
        return !oldValue;
    }

    public boolean disable() {
        boolean oldValue = this.enabled;
        this.enabled = false;
        return oldValue;
    }

    public int size() {
        return (int)this.cache.size();
    }

    public Collection<ORID> keys() {
        return this.cache.asMap().keySet();
    }
}

