/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.server.users.servlet.shiro;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SaltedAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.format.Shiro1CryptFormat;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.eclipse.hawk.service.server.users.servlet.UsersPlugin;
import org.eclipse.hawk.service.server.users.servlet.db.User;
import org.eclipse.hawk.service.server.users.servlet.db.UserStorage;
import org.mapdb.DB;

public class UsersRealm
extends AuthenticatingRealm {
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        if (token instanceof UsernamePasswordToken) {
            UsernamePasswordToken upToken = (UsernamePasswordToken)token;
            String username = upToken.getUsername();
            UserStorage storage = UsersPlugin.getInstance().getStorage();
            try (DB db = storage.getTxMaker().makeTx();){
                User user = (User)storage.getUserMap(db).get((Object)username);
                if (user == null) {
                    return null;
                }
                Hash hash = new Shiro1CryptFormat().parse(user.getHashedPassword());
                UserInfo userInfo = new UserInfo(user.getUsername(), hash);
                return userInfo;
            }
        }
        return null;
    }

    private static final class UserInfo
    implements SaltedAuthenticationInfo {
        private final Hash hash;
        private final String username;
        private static final long serialVersionUID = 1L;

        public UserInfo(String username, Hash hash) {
            this.username = username;
            this.hash = hash;
        }

        public PrincipalCollection getPrincipals() {
            return new SimplePrincipalCollection((Object)this.username, UsersRealm.class.getCanonicalName());
        }

        public Object getCredentials() {
            return this.hash;
        }

        public ByteSource getCredentialsSalt() {
            return this.hash.getSalt();
        }
    }
}

