/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.tests;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.core.query.InvalidQueryException;
import org.eclipse.hawk.core.query.QueryExecutionException;
import org.eclipse.hawk.core.security.FileBasedCredentialsStore;
import org.eclipse.hawk.graph.updater.GraphModelUpdater;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.mm.Tree.TreeFactory;
import org.eclipse.hawk.svn.SvnManager;
import org.eclipse.hawk.svn.tests.rules.TemporarySVNRepository;
import org.eclipse.hawk.timeaware.graph.TimeAwareIndexer;
import org.eclipse.hawk.timeaware.graph.TimeAwareModelUpdater;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.eclipse.hawk.timeaware.queries.TimelineEOLQueryEngine;
import org.junit.Before;

public abstract class AbstractTimeAwareModelIndexingTest
extends ModelIndexingTest {
    public static final String TREE_MM_PATH = "resources/metamodels/Tree.ecore";
    protected final TreeFactory treeFactory = TreeFactory.eINSTANCE;
    protected ResourceSet rsTree;
    protected TimeAwareEOLQueryEngine timeAwareQueryEngine;
    protected TimelineEOLQueryEngine timelineQueryEngine;

    public AbstractTimeAwareModelIndexingTest(File baseDir, IGraphDatabaseFactory dbFactory, ModelIndexingTest.IModelSupportFactory msFactory) {
        super(baseDir, dbFactory, msFactory);
    }

    @Before
    public void setUp() throws Exception {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore")});
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/XMLType.ecore")});
        this.setUpMetamodels();
        this.rsTree = new ResourceSetImpl();
        this.rsTree.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        this.timeAwareQueryEngine = new TimeAwareEOLQueryEngine();
        this.indexer.addQueryEngine((IQueryEngine)this.timeAwareQueryEngine);
        this.timelineQueryEngine = new TimelineEOLQueryEngine();
        this.indexer.addQueryEngine((IQueryEngine)this.timelineQueryEngine);
    }

    protected abstract void setUpMetamodels() throws Exception;

    protected GraphModelUpdater createModelUpdater() {
        return new TimeAwareModelUpdater();
    }

    protected IModelIndexer createIndexer(File indexerFolder, FileBasedCredentialsStore credStore) {
        return new TimeAwareIndexer("test", indexerFolder, (ICredentialsStore)credStore, (IConsole)this.console);
    }

    protected void requestSVNIndex(TemporarySVNRepository svnRepository) throws Exception {
        SvnManager vcs = new SvnManager();
        vcs.init(svnRepository.getRepositoryURL().toString(), this.indexer);
        vcs.run();
        this.indexer.addVCSManager((IVcsManager)vcs, true);
    }

    protected Object timeAwareEOL(String eolQuery) throws InvalidQueryException, QueryExecutionException {
        return this.timeAwareEOL(eolQuery, null);
    }

    protected Object timeAwareEOLInRepository(String eolQuery, TemporarySVNRepository svnRepository) throws InvalidQueryException, QueryExecutionException {
        return this.timeAwareEOL(eolQuery, Collections.singletonMap("REPOSITORY", svnRepository.getRepositoryURL().toString()));
    }

    protected Object timeAwareEOL(String eolQuery, Map<String, Object> context) throws InvalidQueryException, QueryExecutionException {
        return this.timeAwareQueryEngine.query(this.indexer, eolQuery, context);
    }

    protected Object timeAwareEOL(String eolQuery, String argumentName, Object argumentValue) throws InvalidQueryException, QueryExecutionException {
        return this.timeAwareEOL(eolQuery, Collections.singletonMap("ARGUMENTS", Collections.singletonMap(argumentName, argumentValue)));
    }

    protected Object timelineEOL(String eolQuery) throws InvalidQueryException, QueryExecutionException {
        return this.timelineQueryEngine.query(this.indexer, eolQuery, null);
    }
}

