/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public abstract class SqlJetRowNumCursor
extends SqlJetCursor {
    private long rowsCount = -1L;
    private long currentRowNum = -1L;
    private long currentRowId = -1L;
    private boolean internalMove;
    private long limit = 0L;

    SqlJetRowNumCursor(ISqlJetBtreeTable table, SqlJetDb db) throws SqlJetException {
        super(table, db);
    }

    public void setLimit(long limit) throws SqlJetException {
        if (limit >= 0L) {
            this.limit = limit;
            this.rowsCount = -1L;
            this.first();
        }
    }

    public long getLimit() {
        return this.limit;
    }

    public long getRowCount() throws SqlJetException {
        if (this.rowsCount < 0L) {
            this.computeRows(false);
        }
        return this.rowsCount;
    }

    protected void computeRows(final boolean current) throws SqlJetException {
        this.db.runReadTransaction(new ISqlJetTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run(SqlJetDb db) throws SqlJetException {
                try {
                    SqlJetRowNumCursor.this.internalMove = true;
                    SqlJetRowNumCursor.this.currentRowId = SqlJetRowNumCursor.this.getRowIdSafe();
                    SqlJetRowNumCursor.this.rowsCount = 0L;
                    SqlJetRowNumCursor.this.currentRowNum = -1L;
                    SqlJetRowNumCursor.this.first();
                    while (!SqlJetRowNumCursor.this.eof()) {
                        SqlJetRowNumCursor.this.rowsCount++;
                        if (SqlJetRowNumCursor.this.currentRowId == SqlJetRowNumCursor.this.getRowIdSafe()) {
                            SqlJetRowNumCursor.this.currentRowNum = SqlJetRowNumCursor.this.rowsCount;
                            if (current) break;
                        }
                        SqlJetRowNumCursor.this.next();
                    }
                    if (SqlJetRowNumCursor.this.currentRowNum < 0L) {
                        SqlJetRowNumCursor.this.currentRowNum = SqlJetRowNumCursor.this.rowsCount;
                    }
                    if (SqlJetRowNumCursor.this.currentRowId > 0L) {
                        SqlJetRowNumCursor.this.goTo(SqlJetRowNumCursor.this.currentRowId);
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    SqlJetRowNumCursor.this.internalMove = false;
                    throw throwable;
                }
                SqlJetRowNumCursor.this.internalMove = false;
                return null;
            }
        });
    }

    public long getRowIndex() throws SqlJetException {
        if (this.currentRowNum < 0L || this.rowsCount < 0L && this.eof() || this.currentRowId != this.getRowIdSafe()) {
            this.computeRows(true);
        }
        return this.currentRowNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean goToRow(long rowNum) throws SqlJetException {
        boolean bl;
        block16: {
            boolean bl2;
            block15: {
                boolean bl3;
                block14: {
                    try {
                        this.internalMove = true;
                        if (this.rowsCount > 0L && rowNum > this.rowsCount) {
                            boolean bl4 = false;
                            Object var7_7 = null;
                            this.internalMove = false;
                            return bl4;
                        }
                        if (this.currentRowNum < 0L || this.eof() && this.rowsCount < 0L || this.currentRowId != this.getRowIdSafe()) {
                            this.currentRowId = this.getRowIdSafe();
                            this.currentRowNum = 0L;
                            this.first();
                            while (!this.eof()) {
                                ++this.currentRowNum;
                                if (this.currentRowNum == rowNum) {
                                    this.currentRowId = this.getRowIdSafe();
                                    boolean bl5 = true;
                                    Object var7_8 = null;
                                    this.internalMove = false;
                                    return bl5;
                                }
                                this.next();
                            }
                            if (this.rowsCount < 0L) {
                                this.rowsCount = this.currentRowNum;
                            }
                            this.currentRowNum = -1L;
                            if (this.currentRowId > 0L) {
                                this.goTo(this.currentRowId);
                            }
                        } else {
                            if (rowNum == this.currentRowNum) {
                                bl3 = true;
                                break block14;
                            }
                            long rn = this.currentRowNum;
                            while (!this.eof()) {
                                this.currentRowNum = rowNum > this.currentRowNum ? ++this.currentRowNum : --this.currentRowNum;
                                if (this.currentRowNum == rowNum) {
                                    this.currentRowId = this.getRowIdSafe();
                                    bl2 = true;
                                    break block15;
                                }
                                if (!(rowNum > this.currentRowNum ? !this.next() : !this.previous())) continue;
                            }
                            if (this.rowsCount < 0L) {
                                this.rowsCount = this.currentRowNum;
                            }
                            this.currentRowNum = rn;
                            if (this.currentRowId > 0L) {
                                this.goTo(this.currentRowId);
                            }
                        }
                        bl = false;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        this.internalMove = false;
                        throw throwable;
                    }
                }
                Object var7_9 = null;
                this.internalMove = false;
                return bl3;
            }
            Object var7_10 = null;
            this.internalMove = false;
            return bl2;
        }
        Object var7_11 = null;
        this.internalMove = false;
        return bl;
    }

    public void delete() throws SqlJetException {
        --this.rowsCount;
        --this.currentRowNum;
        this.currentRowId = this.getRowIdSafe();
    }

    public boolean first() throws SqlJetException {
        return this.firstRowNum(super.first());
    }

    public boolean next() throws SqlJetException {
        return this.nextRowNum(super.next());
    }

    public boolean previous() throws SqlJetException {
        return this.previousRowNum(super.previous());
    }

    public boolean last() throws SqlJetException {
        if (this.limit > 0L && this.goToRow(this.limit)) {
            return true;
        }
        return this.lastRowNum(super.last());
    }

    protected boolean firstRowNum(boolean first) throws SqlJetException {
        if (this.internalMove) {
            return first;
        }
        if (first) {
            this.currentRowNum = 1L;
            this.currentRowId = this.getRowIdSafe();
        } else {
            this.currentRowNum = 0L;
            this.currentRowId = -1L;
        }
        return first;
    }

    protected boolean nextRowNum(boolean next) throws SqlJetException {
        if (this.internalMove) {
            return next;
        }
        if (next) {
            ++this.currentRowNum;
            this.currentRowId = this.getRowIdSafe();
        }
        return next;
    }

    protected boolean previousRowNum(boolean previous) throws SqlJetException {
        if (this.internalMove) {
            return previous;
        }
        if (previous) {
            --this.currentRowNum;
            this.currentRowId = this.getRowIdSafe();
        }
        return previous;
    }

    protected boolean lastRowNum(boolean last) throws SqlJetException {
        if (this.internalMove) {
            return last;
        }
        this.currentRowNum = -1L;
        this.currentRowId = -1L;
        return last;
    }

    private long getRowIdSafe() throws SqlJetException {
        return super.eof() ? 0L : this.getRowId();
    }

    public boolean eof() throws SqlJetException {
        if (this.limit > 0L) {
            return this.currentRowNum >= this.limit;
        }
        return super.eof();
    }
}

