/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.vcs;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.ui2.dialog.HVCSDialog;
import org.eclipse.hawk.ui2.vcs.IVcsConfigurationBlock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DefaultVcsConfigurationBlock
implements IVcsConfigurationBlock {
    private HVCSDialog dialog;
    private Text txtVCSLocation;
    private Button btnVCSBrowse;
    private Text txtUser;
    private Text txtPass;

    @Override
    public boolean isApplicableTo(IVcsManager manager) {
        return true;
    }

    @Override
    public void createBlock(final Composite container, HVCSDialog dialog) {
        this.dialog = dialog;
        IVcsManager managerToEdit = dialog.getManagerToEdit();
        GridLayout containerLayout = new GridLayout();
        containerLayout.numColumns = 3;
        container.setLayout((Layout)containerLayout);
        Label lblLocation = new Label(container, 0);
        lblLocation.setText("Location:");
        this.txtVCSLocation = new Text(container, 2048);
        GridData txtVCSLocationLayoutData = new GridData(4, 0x1000000, true, false);
        txtVCSLocationLayoutData.widthHint = 300;
        this.txtVCSLocation.setLayoutData((Object)txtVCSLocationLayoutData);
        if (managerToEdit != null) {
            this.txtVCSLocation.setText(managerToEdit.getLocation());
            this.txtVCSLocation.setEnabled(false);
        } else {
            this.txtVCSLocation.setText(dialog.getSelectedVCSManager().getDefaultLocation());
        }
        this.txtVCSLocation.addModifyListener(e -> this.updateDialog());
        this.btnVCSBrowse = new Button(container, 8);
        GridData gridDataB = new GridData();
        this.btnVCSBrowse.setLayoutData((Object)gridDataB);
        this.btnVCSBrowse.setText("Browse...");
        this.btnVCSBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(container.getShell(), 4096);
                dd.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toString());
                dd.setMessage("Select a folder to add to the indexer");
                dd.setText("Select a directory");
                String result = dd.open();
                if (result != null) {
                    DefaultVcsConfigurationBlock.this.txtVCSLocation.setText(result);
                }
            }
        });
        this.btnVCSBrowse.setEnabled(false);
        String usernameToEdit = null;
        String passwordToEdit = null;
        if (managerToEdit != null) {
            usernameToEdit = managerToEdit.getUsername();
            passwordToEdit = managerToEdit.getPassword();
        }
        if (this.isAuthSupported()) {
            Label lblUser = new Label(container, 0);
            lblUser.setText("User (optional):");
            this.txtUser = new Text(container, 2052);
            GridData txtUserLayoutData = new GridData(4, 0x1000000, true, false);
            txtUserLayoutData.horizontalSpan = 2;
            this.txtUser.setLayoutData((Object)txtUserLayoutData);
            if (usernameToEdit != null) {
                this.txtUser.setText(usernameToEdit);
            }
            this.txtUser.addModifyListener(e -> this.updateDialog());
            Label lblPass = new Label(container, 0);
            lblPass.setText("Pass (optional):");
            this.txtPass = new Text(container, 0x400804);
            GridData txtPassLayoutData = new GridData(4, 0x1000000, true, false);
            txtPassLayoutData.horizontalSpan = 2;
            this.txtPass.setLayoutData((Object)txtPassLayoutData);
            if (passwordToEdit != null) {
                this.txtPass.setText(passwordToEdit);
            }
            this.txtPass.addModifyListener(e -> this.updateDialog());
        }
        this.updateDialog();
    }

    @Override
    public void okPressed(HModel hawkModel, boolean isFrozen) {
        String vcsType = this.dialog.getSelectedVCSManager().getClass().getName();
        String location = this.txtVCSLocation.getText();
        String user = this.txtUser == null ? "" : this.txtUser.getText();
        String pass = this.txtPass == null ? "" : this.txtPass.getText();
        IVcsManager managerToEdit = this.dialog.getManagerToEdit();
        if (managerToEdit == null) {
            hawkModel.addVCS(location, vcsType, user, pass, isFrozen);
        } else {
            if (managerToEdit.isAuthSupported()) {
                managerToEdit.setCredentials(user, pass, hawkModel.getManager().getCredentialsStore());
            }
            managerToEdit.setFrozen(isFrozen);
        }
    }

    private void updateDialog() {
        if (this.isAuthSupported()) {
            boolean authEnabled = this.isLocationValid();
            this.txtUser.setEnabled(authEnabled);
            this.txtPass.setEnabled(authEnabled);
            if ("".equals(this.txtUser.getText()) != "".equals(this.txtPass.getText())) {
                this.dialog.setErrorMessage("The username and password must be empty or not empty at the same time");
            }
        }
        if (this.dialog.getManagerToEdit() == null) {
            IVcsManager vcsManager = this.dialog.getSelectedVCSManager();
            this.btnVCSBrowse.setEnabled(vcsManager != null && vcsManager.isPathLocationAccepted());
        }
        if (!this.isLocationValid()) {
            this.dialog.setErrorMessage("The location is not valid");
        } else if (this.dialog.getSelectedVCSManager() == null) {
            this.dialog.setErrorMessage("No VCS manager type has been selected");
        } else {
            this.dialog.setErrorMessage(null);
        }
    }

    private boolean isLocationValidPath() {
        File dir = new File(this.txtVCSLocation.getText());
        return dir.exists() && dir.isDirectory() && dir.canRead();
    }

    private boolean isAuthSupported() {
        IVcsManager vcsManager = this.dialog.getSelectedVCSManager();
        return vcsManager != null && vcsManager.isAuthSupported();
    }

    private boolean isLocationValid() {
        IVcsManager vcsManager = this.dialog.getSelectedVCSManager();
        return vcsManager.isPathLocationAccepted() && this.isLocationValidPath() || vcsManager.isURLLocationAccepted() && this.isLocationValidURI();
    }

    private boolean isLocationValidURI() {
        try {
            URI uri = new URI(this.txtVCSLocation.getText());
            return uri.getScheme() != null && uri.getPath() != null;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

