/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.graph.timeaware;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.timeaware.VersionRangeFilterCreatedIGraphEdgeIterable;
import org.eclipse.hawk.core.graph.timeaware.VersionRangeFilterIGraphEdgeIterable;

public interface ITimeAwareGraphNode
extends IGraphNode {
    public static final long NO_SUCH_INSTANT = -1L;

    public boolean isAlive();

    public long getTime();

    public List<Long> getAllInstants() throws Exception;

    default public List<ITimeAwareGraphNode> getAllVersions() throws Exception {
        return this.getAllInstants().stream().map(instant -> this.travelInTime((long)instant)).collect(Collectors.toList());
    }

    public long getEarliestInstant() throws Exception;

    default public ITimeAwareGraphNode getEarliest() throws Exception {
        return this.travelInTime(this.getEarliestInstant());
    }

    public long getPreviousInstant() throws Exception;

    default public ITimeAwareGraphNode getPrevious() throws Exception {
        return this.travelInTime(this.getPreviousInstant());
    }

    public long getLatestInstant() throws Exception;

    default public ITimeAwareGraphNode getLatest() throws Exception {
        return this.travelInTime(this.getLatestInstant());
    }

    public long getNextInstant() throws Exception;

    default public ITimeAwareGraphNode getNext() throws Exception {
        return this.travelInTime(this.getNextInstant());
    }

    public void end();

    public ITimeAwareGraphNode travelInTime(long var1);

    public List<Long> getInstantsBetween(long var1, long var3);

    default public List<ITimeAwareGraphNode> getVersionsBetween(long fromInclusive, long toInclusive) throws Exception {
        return this.getInstantsBetween(fromInclusive, toInclusive).stream().map(instant -> this.travelInTime((long)instant)).collect(Collectors.toList());
    }

    public List<Long> getInstantsFrom(long var1);

    default public List<ITimeAwareGraphNode> getVersionsFrom(long fromInclusive) throws Exception {
        return this.getInstantsFrom(fromInclusive).stream().map(instant -> this.travelInTime((long)instant)).collect(Collectors.toList());
    }

    public List<Long> getInstantsUpTo(long var1);

    default public List<ITimeAwareGraphNode> getVersionsUpTo(long toInclusive) throws Exception {
        return this.getInstantsUpTo(toInclusive).stream().map(instant -> this.travelInTime((long)instant)).collect(Collectors.toList());
    }

    default public Iterable<IGraphEdge> getOutgoingWithTypeBetween(String type, long fromInclusive, long toInclusive) throws Exception {
        return new VersionRangeFilterIGraphEdgeIterable(this.getVersionsBetween(fromInclusive, toInclusive), node -> node.getOutgoingWithType(type), edge -> edge.getEndNode().getId());
    }

    default public Iterable<IGraphEdge> getIncomingWithTypeBetween(String type, long fromInclusive, long toInclusive) throws Exception {
        return new VersionRangeFilterIGraphEdgeIterable(this.getVersionsBetween(fromInclusive, toInclusive), node -> node.getIncomingWithType(type), edge -> edge.getStartNode().getId());
    }

    default public Iterable<IGraphEdge> getOutgoingWithTypeCreatedBetween(String type, long fromInclusive, long toInclusive) throws Exception {
        return new VersionRangeFilterCreatedIGraphEdgeIterable(this, fromInclusive, toInclusive, node -> node.getOutgoingWithType(type), edge -> edge.getEndNode().getId());
    }

    default public Iterable<IGraphEdge> getIncomingWithTypeCreatedBetween(String type, long fromInclusive, long toInclusive) throws Exception {
        return new VersionRangeFilterCreatedIGraphEdgeIterable(this, fromInclusive, toInclusive, node -> node.getIncomingWithType(type), edge -> edge.getStartNode().getId());
    }
}

