/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.emf;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.graph.syncValidationListener.SyncValidationListener;
import org.eclipse.hawk.integration.tests.IntegrationTestSuite;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.Parameterized;

public class TreeUpdateTest
extends ModelIndexingTest {
    @Rule
    public ModelIndexingTest.GraphChangeListenerRule<SyncValidationListener> syncValidation = new ModelIndexingTest.GraphChangeListenerRule((ModelIndexingTest)this, (IGraphChangeListener)new SyncValidationListener());
    @Rule
    public TemporaryFolder modelFolder = new TemporaryFolder();
    private Path modelPath;

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return IntegrationTestSuite.caseParams();
    }

    public TreeUpdateTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf, new EMFModelSupportFactory());
    }

    public void prepare(String baseModel) throws Throwable {
        this.modelPath = new File(this.modelFolder.getRoot(), new File(baseModel).getName()).toPath();
        Files.copy(new File(this.baseDir, "resources/models/" + baseModel).toPath(), this.modelPath, new CopyOption[0]);
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore")});
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/XMLType.ecore")});
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Tree.ecore")});
        this.requestFolderIndex(this.modelFolder.getRoot());
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            return null;
        });
    }

    @Test
    public void eContainer() throws Throwable {
        this.prepare("tree/tree.model");
        Assert.assertEquals(null, (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').eContainer;"));
        Assert.assertEquals((Object)"t3", (Object)this.eol("return Tree.all.selectOne(t|t.label='t9000').eContainer.label;"));
        Assert.assertEquals((Object)1, (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').eContents.size;"));
        Assert.assertEquals((Object)0, (Object)this.eol("return Tree.all.selectOne(t|t.label='t9000').eContents.size;"));
        Assert.assertEquals((Object)1, (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').eAllContents.size;"));
        Assert.assertEquals((Object)0, (Object)this.eol("return Tree.all.selectOne(t|t.label='t9000').eAllContents.size;"));
    }

    @Test
    public void hawkProperties() throws Throwable {
        this.prepare("tree/tree.model");
        Assert.assertNotNull((Object)this.eol("return Tree.all.first.hawkNodeId;"));
        Assert.assertNotNull((Object)this.eol("return Tree.all.selectOne(t|t.label='t3').hawkURIFragment;"));
        Assert.assertTrue((boolean)((String)this.eol("return Tree.all.selectOne(t|t.label='t3').hawkRepos.first;")).startsWith("file:/"));
        Assert.assertEquals((Object)"/tree.model", (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').hawkFile;"));
        Assert.assertEquals(Collections.singleton("/tree.model"), (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').hawkFiles;"));
        Assert.assertEquals((Object)0, (Object)this.eol("return Tree.all.first.hawkProxies.size;"));
        Assert.assertEquals((Object)1, (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').hawkIn.size;"));
        Assert.assertEquals((Object)1, (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').hawkInEdges.size;"));
        Assert.assertEquals((Object)"t9000", (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').hawkInEdges.first.source.label;"));
        Assert.assertEquals((Object)"parent", (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').hawkInEdges.first.type;"));
        Assert.assertEquals((Object)1, (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').hawkOut.size;"));
        Assert.assertEquals((Object)1, (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').hawkOutEdges.size;"));
        Assert.assertEquals((Object)"children", (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').hawkOutEdges.first.type;"));
        Assert.assertEquals((Object)"t9000", (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').hawkOutEdges.first.target.label;"));
    }

    @Test
    public void addModel() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore")});
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/XMLType.ecore")});
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Tree.ecore")});
        this.requestFolderIndex(this.modelFolder.getRoot());
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            return null;
        });
        String baseModel = "tree/tree.model";
        this.modelPath = new File(this.modelFolder.getRoot(), new File("tree/tree.model").getName()).toPath();
        Files.copy(new File(this.baseDir, "resources/models/" + baseModel).toPath(), this.modelPath, new CopyOption[0]);
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            Throwable throwable = null;
            Object var2_3 = null;
            try (IGraphTransaction tx = this.db.beginTransaction();){
                Assert.assertEquals((long)2L, (long)this.queryEngine.getAllOf("Tree", "_hawkOfType").size());
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return null;
        });
    }

    @Test
    public void addChild() throws Throwable {
        this.prepare("tree/tree.model");
        this.replaceWith("changed-trees/add-child.model");
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            Throwable throwable = null;
            Object var2_3 = null;
            try (IGraphTransaction tx = this.db.beginTransaction();){
                Assert.assertEquals((long)3L, (long)this.queryEngine.getAllOf("Tree", "_hawkOfType").size());
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return null;
        });
    }

    @Test
    public void removeChild() throws Throwable {
        this.prepare("tree/tree.model");
        this.replaceWith("changed-trees/remove-child.model");
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            Throwable throwable = null;
            Object var2_3 = null;
            try (IGraphTransaction tx = this.db.beginTransaction();){
                Assert.assertEquals((long)1L, (long)this.queryEngine.getAllOf("Tree", "_hawkOfType").size());
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return null;
        });
    }

    @Test
    public void renameChild() throws Throwable {
        this.prepare("tree/tree.model");
        this.replaceWith("changed-trees/rename-child.model");
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            Assert.assertEquals((Object)2, (Object)this.eol("return Tree.all.size;"));
            Assert.assertEquals((Object)1, (Object)this.eol("return Tree.all.select(t|t.label='t90001').size;"));
            return null;
        });
    }

    @Test
    public void renameRoot() throws Throwable {
        this.prepare("tree/tree.model");
        this.replaceWith("changed-trees/rename-root.model");
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            Throwable throwable = null;
            Object var2_3 = null;
            try (IGraphTransaction tx = this.db.beginTransaction();){
                Assert.assertEquals((long)2L, (long)this.queryEngine.getAllOf("Tree", "_hawkOfType").size());
                Assert.assertEquals((Object)1, (Object)this.queryEngine.query(this.indexer, "return Tree.all.select(t|t.label='t40').size;", null));
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return null;
        });
    }

    private void replaceWith(String replacement) throws IOException {
        File replacementFile = new File(this.baseDir, "resources/models/" + replacement);
        Files.copy(replacementFile.toPath(), this.modelPath, StandardCopyOption.REPLACE_EXISTING);
        System.err.println("Copied " + replacementFile + " over " + this.modelPath);
    }
}

