/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.uml.vcs;

import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsChangeType;
import org.eclipse.hawk.core.VcsCommit;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.VcsRepositoryDelta;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PathmapResourceCollection
implements IVcsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathmapResourceCollection.class);
    protected ResourceSet rs = new ResourceSetImpl();
    private String baseURI;
    private static final String FIRST_REV = "0";
    private boolean isFrozen;

    public PathmapResourceCollection(String baseURI) {
        this.baseURI = baseURI;
        UMLUtil.init((ResourceSet)this.rs);
    }

    protected String getRootNsURI(String referenceResourceURI) {
        URI uri = URI.createURI((String)referenceResourceURI);
        EList eob = this.rs.getResource(uri, false).getContents();
        String revision = ((EObject)eob.get(0)).eClass().getEPackage().getNsURI();
        return revision;
    }

    public ResourceSet getResourceSet() {
        return this.rs;
    }

    public String getFirstRevision() throws Exception {
        return FIRST_REV;
    }

    public Collection<VcsCommitItem> getDelta(String endRevision) throws Exception {
        return this.getDelta(FIRST_REV, endRevision).getCompactedCommitItems();
    }

    public VcsRepositoryDelta getDelta(String startRevision, String endRevision) throws Exception {
        ArrayList<VcsCommit> commits = new ArrayList<VcsCommit>();
        VcsRepositoryDelta delta = new VcsRepositoryDelta(commits);
        delta.setManager((IVcsManager)this);
        String currentRevision = this.getCurrentRevision();
        if (!currentRevision.equals(startRevision)) {
            for (Resource r : this.rs.getResources()) {
                if (!r.getURI().toString().startsWith(this.baseURI)) continue;
                VcsCommit commit = new VcsCommit();
                commit.setAuthor(String.valueOf(this.getHumanReadableName()) + " - no authors recorded");
                commit.setJavaDate(new Date());
                commit.setMessage(String.valueOf(this.getHumanReadableName()) + " - no messages recorded");
                commit.setRevision(currentRevision);
                commits.add(commit);
                VcsCommitItem c = new VcsCommitItem();
                c.setChangeType(VcsChangeType.UPDATED);
                c.setCommit(commit);
                c.setPath(r.getURI().path());
                commit.getItems().add(c);
            }
        }
        return delta;
    }

    public File importFile(String revision, String path, File optionalTemp) {
        URI uri = URI.createURI((String)(String.valueOf(this.baseURI) + path.substring(1)));
        try {
            InputStream is = this.rs.getURIConverter().createInputStream(uri);
            if (is == null) {
                throw new IllegalArgumentException("Could not find " + path + " in the UML libraries");
            }
            Files.copy(is, optionalTemp.toPath(), new CopyOption[0]);
            return optionalTemp;
        }
        catch (Exception ex) {
            LOGGER.error("Error while importing predefined UML library " + path, (Throwable)ex);
            return null;
        }
    }

    public boolean isActive() {
        return !this.rs.getResources().isEmpty();
    }

    public void run() throws Exception {
    }

    public void shutdown() {
        for (Resource resource : this.rs.getResources()) {
            resource.unload();
        }
        this.rs = null;
    }

    public String getLocation() {
        return this.baseURI;
    }

    public String getUsername() {
        return null;
    }

    public String getPassword() {
        return null;
    }

    public void setCredentials(String username, String password, ICredentialsStore credStore) {
    }

    public boolean isAuthSupported() {
        return false;
    }

    public boolean isPathLocationAccepted() {
        return true;
    }

    public boolean isURLLocationAccepted() {
        return true;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public void setFrozen(boolean f) {
        this.isFrozen = f;
    }
}

