/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries;

import org.eclipse.epsilon.eol.execute.operations.EolOperationFactory;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.eclipse.hawk.timeaware.queries.operations.patterns.AlwaysReducer;
import org.eclipse.hawk.timeaware.queries.operations.patterns.BoundedVersionQuantifierOperation;
import org.eclipse.hawk.timeaware.queries.operations.patterns.EventuallyAtLeastReducer;
import org.eclipse.hawk.timeaware.queries.operations.patterns.EventuallyAtMostReducer;
import org.eclipse.hawk.timeaware.queries.operations.patterns.EventuallyReducer;
import org.eclipse.hawk.timeaware.queries.operations.patterns.NeverReducer;
import org.eclipse.hawk.timeaware.queries.operations.patterns.VersionQuantifierOperation;
import org.eclipse.hawk.timeaware.queries.operations.scopes.EndingTimeAwareNodeWrapper;
import org.eclipse.hawk.timeaware.queries.operations.scopes.StartingTimeAwareNodeWrapper;
import org.eclipse.hawk.timeaware.queries.operations.scopes.annotations.AfterAnnotatedOperation;
import org.eclipse.hawk.timeaware.queries.operations.scopes.annotations.BeforeAnnotatedOperation;
import org.eclipse.hawk.timeaware.queries.operations.scopes.annotations.SinceAnnotatedOperation;
import org.eclipse.hawk.timeaware.queries.operations.scopes.annotations.UntilAnnotatedOperation;
import org.eclipse.hawk.timeaware.queries.operations.scopes.annotations.WhenAnnotatedOperation;
import org.eclipse.hawk.timeaware.queries.operations.scopes.predicates.VersionRangeOperation;
import org.eclipse.hawk.timeaware.queries.operations.scopes.predicates.WhenOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAwareEOLOperationFactory
extends EolOperationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeAwareEOLOperationFactory.class);
    private final TimeAwareEOLQueryEngine containerModel;

    public TimeAwareEOLOperationFactory(TimeAwareEOLQueryEngine model) {
        this.containerModel = model;
        this.operationCache.put("always", new VersionQuantifierOperation(this::getContainerModel, new AlwaysReducer()));
        this.operationCache.put("never", new VersionQuantifierOperation(this::getContainerModel, new NeverReducer()));
        this.operationCache.put("eventually", new VersionQuantifierOperation(this::getContainerModel, new EventuallyReducer()));
        this.operationCache.put("eventuallyAtMost", new BoundedVersionQuantifierOperation(this::getContainerModel, count -> new EventuallyAtMostReducer((int)count)));
        this.operationCache.put("eventuallyAtLeast", new BoundedVersionQuantifierOperation(this::getContainerModel, count -> new EventuallyAtLeastReducer((int)count)));
        this.operationCache.put("since", new VersionRangeOperation(this::getContainerModel, (original, match) -> new StartingTimeAwareNodeWrapper(match)));
        this.operationCache.put("after", new VersionRangeOperation(this::getContainerModel, (original, version) -> {
            try {
                ITimeAwareGraphNode nextVersion = version.getNext();
                if (nextVersion != null) {
                    return new StartingTimeAwareNodeWrapper(nextVersion);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return null;
        }));
        this.operationCache.put("until", new VersionRangeOperation(this::getContainerModel, (original, version) -> new EndingTimeAwareNodeWrapper(original, version.getTime())));
        this.operationCache.put("before", new VersionRangeOperation(this::getContainerModel, (original, version) -> {
            try {
                long prevInstant = version.getPreviousInstant();
                if (prevInstant != -1L) {
                    return new EndingTimeAwareNodeWrapper(original, prevInstant);
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not retrieve previous instant for before", (Throwable)e);
            }
            return null;
        }));
        this.operationCache.put("when", new WhenOperation(this::getContainerModel));
        this.operationCache.put("whenAnnotated", new WhenAnnotatedOperation(this::getContainerModel));
        this.operationCache.put("sinceAnnotated", new SinceAnnotatedOperation(this::getContainerModel));
        this.operationCache.put("afterAnnotated", new AfterAnnotatedOperation(this::getContainerModel));
        this.operationCache.put("untilAnnotated", new UntilAnnotatedOperation(this::getContainerModel));
        this.operationCache.put("beforeAnnotated", new BeforeAnnotatedOperation(this::getContainerModel));
    }

    public TimeAwareEOLQueryEngine getContainerModel() {
        return this.containerModel;
    }
}

