/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.patterns;

import org.eclipse.hawk.timeaware.queries.operations.patterns.IShortCircuitReducer;

public class EventuallyAtLeastReducer
implements IShortCircuitReducer {
    private final int minCount;
    private int currentCount;

    public EventuallyAtLeastReducer(int minCount) {
        this.minCount = minCount;
    }

    @Override
    public Boolean reduce(boolean element) {
        if (element) {
            ++this.currentCount;
            if (this.currentCount >= this.minCount) {
                return true;
            }
        }
        return null;
    }

    @Override
    public boolean reduce() {
        return this.currentCount >= this.minCount;
    }
}

