/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.scopes;

import java.util.Collections;
import java.util.List;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.timeaware.queries.operations.scopes.AbstractSingleWrapTimeAwareNodeWrapper;

public class StartingTimeAwareNodeWrapper
extends AbstractSingleWrapTimeAwareNodeWrapper {
    private final long fromInclusive;

    public StartingTimeAwareNodeWrapper(ITimeAwareGraphNode original) {
        this(original, original.getTime());
    }

    public StartingTimeAwareNodeWrapper(ITimeAwareGraphNode original, long fromInclusive) {
        super(original);
        this.fromInclusive = fromInclusive;
    }

    public List<Long> getAllInstants() throws Exception {
        return this.original.getInstantsBetween(this.fromInclusive, this.original.getLatestInstant());
    }

    public long getEarliestInstant() throws Exception {
        return this.fromInclusive;
    }

    public long getPreviousInstant() throws Exception {
        long prev = this.original.getPreviousInstant();
        if (prev == -1L || prev < this.fromInclusive) {
            return -1L;
        }
        return prev;
    }

    public long getLatestInstant() throws Exception {
        return this.original.getLatestInstant();
    }

    public long getNextInstant() throws Exception {
        return this.original.getNextInstant();
    }

    public ITimeAwareGraphNode travelInTime(long time) {
        long actualTime = Math.max(time, this.fromInclusive);
        return this.wrap(this.original.travelInTime(actualTime));
    }

    public List<Long> getInstantsBetween(long fromInclusive, long toInclusive) {
        if (this.fromInclusive > toInclusive) {
            return Collections.emptyList();
        }
        long actualFromTime = Math.max(fromInclusive, this.fromInclusive);
        return this.original.getInstantsBetween(actualFromTime, toInclusive);
    }

    public List<Long> getInstantsFrom(long fromInclusive) {
        long actualFromTime = Math.max(fromInclusive, this.fromInclusive);
        return this.original.getInstantsFrom(actualFromTime);
    }

    public List<Long> getInstantsUpTo(long toInclusive) {
        return this.original.getInstantsBetween(this.fromInclusive, toInclusive);
    }

    @Override
    protected ITimeAwareGraphNode wrap(ITimeAwareGraphNode n) {
        return new StartingTimeAwareNodeWrapper(n, this.fromInclusive);
    }
}

