/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.scopes.predicates;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.eclipse.hawk.timeaware.queries.operations.TimeAwareNodeFirstOrderOperation;
import org.eclipse.hawk.timeaware.queries.operations.scopes.WhenNodeWrapper;

public class WhenOperation
extends TimeAwareNodeFirstOrderOperation {
    public WhenOperation(Supplier<TimeAwareEOLQueryEngine> containerModelSupplier) {
        super(containerModelSupplier);
    }

    @Override
    protected Object execute(Variable iterator, Expression expression, IEolContext context, Function<ITimeAwareGraphNode, Object> versionWrapper, ITimeAwareGraphNode taNode) throws EolInternalException {
        try {
            long latestInstant = taNode.getLatestInstant();
            List versions = taNode.getVersionsBetween(taNode.getTime(), latestInstant);
            FrameStack scope = context.getFrameStack();
            ArrayList<Long> matchingVersions = new ArrayList<Long>();
            for (ITimeAwareGraphNode version : versions) {
                Object listItem = versionWrapper.apply(version);
                if (iterator.getType() != null && !iterator.getType().isKind(listItem)) continue;
                scope.enterLocal(FrameType.UNPROTECTED, (ModuleElement)expression, new Variable[0]);
                scope.put(Variable.createReadOnlyVariable((String)iterator.getName(), (Object)listItem));
                Object bodyResult = context.getExecutorFactory().execute((ModuleElement)expression, context);
                scope.leaveLocal((ModuleElement)expression);
                if (!(bodyResult instanceof Boolean) || !((Boolean)bodyResult).booleanValue()) continue;
                matchingVersions.add(version.getTime());
            }
            if (!matchingVersions.isEmpty()) {
                Long oldestMatchingVersion = (Long)matchingVersions.get(matchingVersions.size() - 1);
                ITimeAwareGraphNode oldestMatchingNode = taNode.travelInTime(oldestMatchingVersion.longValue());
                WhenNodeWrapper scopedNode = new WhenNodeWrapper(oldestMatchingNode, matchingVersions);
                return versionWrapper.apply(scopedNode);
            }
        }
        catch (Exception ex) {
            throw new EolInternalException((Throwable)ex, (ModuleElement)expression);
        }
        return null;
    }

    public boolean isOverridable() {
        return false;
    }
}

