/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.graph;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;

public final class NodeFilterIGraphEdgeIterable
implements Iterable<IGraphEdge> {
    private final Iterable<IGraphEdge> allEdges;
    private final Set<Object> ids;
    private final int flags;
    public static final int MATCH_START_NODE = 1;
    public static final int MATCH_END_NODE = 2;

    public NodeFilterIGraphEdgeIterable(Iterable<IGraphEdge> allEdges, Iterable<IGraphNode> targets, int flags) {
        this.allEdges = allEdges;
        this.ids = new HashSet<Object>();
        for (IGraphNode target : targets) {
            this.ids.add(target.getId());
        }
        this.flags = flags;
    }

    @Override
    public Iterator<IGraphEdge> iterator() {
        final Iterator<IGraphEdge> itAllEdges = this.allEdges.iterator();
        return new Iterator<IGraphEdge>(){
            IGraphEdge next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    while (this.next == null && itAllEdges.hasNext()) {
                        IGraphEdge candidate = (IGraphEdge)itAllEdges.next();
                        if ((NodeFilterIGraphEdgeIterable.this.flags & 1) != 0 && NodeFilterIGraphEdgeIterable.this.ids.contains(candidate.getStartNode().getId())) {
                            this.next = candidate;
                            continue;
                        }
                        if ((NodeFilterIGraphEdgeIterable.this.flags & 2) == 0 || !NodeFilterIGraphEdgeIterable.this.ids.contains(candidate.getEndNode().getId())) continue;
                        this.next = candidate;
                    }
                }
                return this.next != null;
            }

            @Override
            public IGraphEdge next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IGraphEdge ret = this.next;
                this.next = null;
                return ret;
            }
        };
    }
}

