/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.scanner;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.ColorManager;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.IntentColorConstants;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class ModelingUnitDecorationPainter
implements IPainter,
PaintListener {
    private static final int MAXIMUM_ELEMENT_LINES = 50;
    private static final int RIGHT_DECORATION_PADDING = 30;
    private static final int LEFT_DECORATION_PADDING = 5;
    private boolean fIsActive;
    private ITextViewer fTextViewer;
    private StyledText fTextWidget;
    private final boolean fIsAdvancedGraphicsPresent;
    private ColorManager colorManager;

    public ModelingUnitDecorationPainter(ITextViewer textViewer, ColorManager colorManager) {
        this.fTextViewer = textViewer;
        this.fTextWidget = textViewer.getTextWidget();
        GC gc = new GC((Drawable)this.fTextWidget);
        gc.setAdvanced(true);
        this.fIsAdvancedGraphicsPresent = gc.getAdvanced();
        this.colorManager = colorManager;
        gc.dispose();
    }

    public void dispose() {
        this.fTextViewer = null;
        this.fTextWidget = null;
    }

    public void paint(int reason) {
        IDocument document = this.fTextViewer.getDocument();
        if (document == null) {
            this.deactivate(false);
            return;
        }
        if (!this.fIsActive) {
            this.fIsActive = true;
            this.fTextWidget.addPaintListener((PaintListener)this);
        }
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (redraw) {
                this.redrawAll();
            }
        }
    }

    public void setPositionManager(IPaintPositionManager manager) {
    }

    public void paintControl(PaintEvent event) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(event.gc, event.x, event.y, event.width, event.height);
        }
    }

    private void handleDrawRequest(GC gc, int x, int y, int w, int h) {
        int endLine;
        int startLine = this.fTextWidget.getLineIndex(y);
        if (startLine <= (endLine = this.fTextWidget.getLineIndex(y + h - 1)) && startLine < this.fTextWidget.getLineCount()) {
            if (this.fIsAdvancedGraphicsPresent) {
                int alpha = gc.getAlpha();
                gc.setAlpha(100);
                this.drawLineRange(gc, startLine, endLine, x, w, true);
                gc.setAlpha(alpha);
            } else {
                this.drawLineRange(gc, startLine, endLine, x, w, false);
            }
        }
    }

    private void drawLineRange(GC gc, int startLine, int endLine, int x, int w, boolean usingAlpha) {
        int viewPortWidth = this.fTextWidget.getClientArea().width;
        int line = startLine;
        while (line <= endLine) {
            int lineOffset = this.fTextWidget.getOffsetAtLine(line);
            int lineEndOffset = line < this.fTextWidget.getLineCount() - 1 ? this.fTextWidget.getOffsetAtLine(line + 1) : this.fTextWidget.getCharCount();
            int lineLength = lineEndOffset - lineOffset;
            while (lineLength > 0) {
                char c = this.fTextWidget.getTextRange(lineOffset + lineLength - 1, 1).charAt(0);
                if (c != '\r' && c != '\n') break;
                --lineLength;
            }
            Point endOfLine = this.fTextWidget.getLocationAtOffset(lineOffset + lineLength);
            if (x - endOfLine.x <= viewPortWidth) {
                int endOffset;
                int startOffset;
                int y = this.fTextWidget.getLinePixel(line);
                try {
                    startOffset = this.fTextWidget.getOffsetAtLocation(new Point(x, y)) - 1;
                    if (startOffset - 2 <= lineOffset) {
                        startOffset = lineOffset;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    startOffset = lineOffset;
                }
                if (x + w >= endOfLine.x) {
                    endOffset = lineEndOffset;
                } else {
                    try {
                        endOffset = this.fTextWidget.getOffsetAtLocation(new Point(x + w - 1, y)) + 1;
                        if (endOffset + 2 >= lineEndOffset) {
                            endOffset = lineEndOffset;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        endOffset = lineEndOffset;
                    }
                }
                if (endOffset > startOffset) {
                    this.drawDecoration(gc, startOffset, endOffset, usingAlpha);
                }
            }
            ++line;
        }
    }

    private void drawDecoration(GC gc, int startOffset, int endOffset, boolean usingAlpha) {
        StyledTextContent content = this.fTextWidget.getContent();
        int muOpeningLineOffset = 0;
        int maxMuLineSize = 0;
        int maxMuLineSizeOffset = 0;
        int beginLine = Math.max(1, content.getLineAtOffset(startOffset) - 50);
        int endLine = Math.min(content.getLineCount() - 2, content.getLineAtOffset(endOffset) + 50);
        int i = beginLine;
        while (i < endLine) {
            String line = content.getLine(i);
            if (line.length() > maxMuLineSize) {
                maxMuLineSize = line.length();
                maxMuLineSizeOffset = content.getOffsetAtLine(i + 1) - 1;
            }
            if (line.contains("@M")) {
                muOpeningLineOffset = content.getOffsetAtLine(i) + line.indexOf("@M");
            }
            if (line.contains("M@".replace("\n", "")) && content.getLineAtOffset(muOpeningLineOffset) != i) {
                int beginingOffset = content.getOffsetAtLine(i + 1);
                this.drawDecorationRectangle(gc, muOpeningLineOffset, beginingOffset + content.getLine(i + 1).length(), maxMuLineSizeOffset, usingAlpha);
            }
            ++i;
        }
    }

    private void redrawAll() {
        this.fTextWidget.redraw();
    }

    private void drawDecorationRectangle(GC gc, int beginOffset, int endOffset, int maxMuLineSizeOffset, boolean usingAlpha) {
        int decorationLineLength = this.fTextWidget.getSize().x;
        gc.setAlpha(100);
        gc.setForeground(this.colorManager.getColor(IntentColorConstants.getMuDecorationLineForeground()));
        gc.setBackground(this.colorManager.getColor(IntentColorConstants.getMuDecorationBackground()));
        Point beginPos = this.fTextWidget.getLocationAtOffset(beginOffset);
        Point endPos = this.fTextWidget.getLocationAtOffset(endOffset);
        gc.drawRoundRectangle(beginPos.x - 5, beginPos.y, decorationLineLength - beginPos.x - 30, endPos.y - beginPos.y, 10, 10);
    }
}

