/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.serializer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.serializer.ParsedElementPosition;

public class IntentPositionManager {
    private Map<EObject, ParsedElementPosition> instructionToPosition = new HashMap<EObject, ParsedElementPosition>();
    private SortedMap<Integer, EObject> positionToInstruction = new TreeMap<Integer, EObject>();

    public void clear() {
        this.instructionToPosition.clear();
        this.positionToInstruction.clear();
    }

    public ParsedElementPosition getPositionForElement(EObject instruction) {
        return this.instructionToPosition.get(instruction);
    }

    public EObject getElementAtPosition(int offset) {
        EObject foundElement = null;
        Iterator<Integer> offsetIterator = this.positionToInstruction.keySet().iterator();
        Integer currentOffsetValue = 0;
        while (currentOffsetValue < offset && offsetIterator.hasNext()) {
            currentOffsetValue = offsetIterator.next();
            foundElement = (EObject)this.positionToInstruction.get(currentOffsetValue);
        }
        return foundElement;
    }

    public void addIntentPositionManagerInformations(IntentPositionManager positionManager) {
        this.instructionToPosition.putAll(positionManager.instructionToPosition);
        this.positionToInstruction.putAll(positionManager.positionToInstruction);
    }

    public void setPositionForInstruction(EObject instruction, int offset, int length) {
        this.instructionToPosition.put(instruction, new ParsedElementPosition(offset, length));
        this.positionToInstruction.put(offset, instruction);
    }

    public void setPositionForInstruction(EObject instruction, int offset, int length, int declarationLength) {
        this.instructionToPosition.put(instruction, new ParsedElementPosition(offset, length, declarationLength));
        this.positionToInstruction.put(offset, instruction);
    }

    public void handleTabulations(int tabOffset, int nbTabs) {
        this.positionToInstruction.clear();
        for (Map.Entry<EObject, ParsedElementPosition> entry : this.instructionToPosition.entrySet()) {
            ParsedElementPosition position = entry.getValue();
            int offset = position.getOffset();
            int length = position.getLength();
            if (offset <= tabOffset && offset + length >= tabOffset) {
                length += nbTabs;
            }
            if (offset >= tabOffset) {
                offset += nbTabs;
            }
            position.setOffset(offset);
            position.setLength(length);
            this.positionToInstruction.put(offset, entry.getKey());
        }
    }
}

