/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser.modelingunit.parser.linker;

import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.modelingunit.AnnotationDeclaration;
import org.eclipse.mylyn.docs.intent.core.modelingunit.IntentReferenceInModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.LabelInModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstruction;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ParseException;

public final class AnnotationDeclarationLinker {
    private AnnotationDeclarationLinker() {
    }

    public static void attachAnnotationDeclaration(AnnotationDeclaration annotationDeclaration) throws ParseException {
        EObject annotationContainer = annotationDeclaration.eContainer();
        int indexOfAnnotationDeclaration = annotationContainer.eContents().indexOf((Object)annotationDeclaration);
        EObject targetForAnnotation = null;
        String literalFormOfTarget = "";
        if (indexOfAnnotationDeclaration < annotationContainer.eContents().size() - 1) {
            ListIterator iterator = annotationContainer.eContents().listIterator(indexOfAnnotationDeclaration);
            while (iterator.hasNext()) {
                EObject nextElement = (EObject)iterator.next();
                if (!AnnotationDeclarationLinker.isTargetforAnnotationDeclaration(nextElement)) continue;
                targetForAnnotation = nextElement;
                literalFormOfTarget = nextElement.toString();
                break;
            }
        }
        if (targetForAnnotation == null) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Can't attach the Annotation of type " + annotationDeclaration.getAnnotationID() + " (values : ");
            for (Map.Entry keyVal : annotationDeclaration.getMap()) {
                errorMessage.append(String.valueOf((String)keyVal.getKey()) + "=" + (String)keyVal.getValue() + " ");
            }
            errorMessage.append(") to any element.");
            throw new ParseException(errorMessage.toString());
        }
        annotationDeclaration.setIntentHref(literalFormOfTarget);
        annotationDeclaration.setReferencedElement((EObject)((ModelingUnitInstruction)targetForAnnotation));
    }

    private static boolean isTargetforAnnotationDeclaration(EObject candidate) {
        boolean isCandidateTargetforAnnotationDeclaration = candidate instanceof ModelingUnitInstruction;
        isCandidateTargetforAnnotationDeclaration = isCandidateTargetforAnnotationDeclaration && !(candidate instanceof LabelInModelingUnit);
        isCandidateTargetforAnnotationDeclaration = isCandidateTargetforAnnotationDeclaration && !(candidate instanceof IntentReferenceInModelingUnit);
        isCandidateTargetforAnnotationDeclaration = isCandidateTargetforAnnotationDeclaration && !(candidate instanceof AnnotationDeclaration);
        return isCandidateTargetforAnnotationDeclaration;
    }
}

