/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.override.entitylistener;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.override.entitylistener.NoEntityListener;
import com.sun.ts.tests.jpa.core.override.entitylistener.NoListener;
import com.sun.ts.tests.jpa.core.override.entitylistener.OverridenListener;
import com.sun.ts.tests.jpa.core.override.util.CallBackCounts;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final Long ID = 1L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void testOverrideEntityListener() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        CallBackCounts.clearCountsMap();
        OverridenListener entity = new OverridenListener();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        this.getEntityManager().flush();
        TestUtil.logTrace((String)("persisted entity" + entity));
        this.getEntityManager().remove((Object)entity);
        this.getEntityManager().flush();
        TestUtil.logTrace((String)("Removed entity" + entity));
        this.getEntityTransaction().commit();
        try {
            pass1 = this.checkPersistCallBacks();
            pass2 = this.checkRemoveCallBacks();
            if (pass1 && pass2) {
                TestUtil.logTrace((String)"testOverrideEntityListener Passed");
            } else {
                if (pass1) {
                    throw new EETest.Fault("Test failed while testing preremove and postremove methods in testOverrideEntityListener ");
                }
                if (pass2) {
                    throw new EETest.Fault("Test failed while testing prepersist and postpersist methods in testOverrideEntityListener ");
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception thrown while testing testOverrideEntityListener" + e);
        }
    }

    public void testEntityListenerXML() throws EETest.Fault {
        block6: {
            boolean pass = false;
            CallBackCounts.clearCountsMap();
            NoEntityListener entity = new NoEntityListener();
            entity.setId(ID);
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)entity);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)("persisted entity" + entity));
            try {
                pass = this.checkPersistCallBacks();
                if (pass) {
                    TestUtil.logTrace((String)"Test Passed");
                    break block6;
                }
                throw new EETest.Fault("TestEntityListenerXML method failed");
            }
            catch (Exception e) {
                throw new EETest.Fault("Exception thrown while testing testEntityListenerXML" + e);
            }
            finally {
                this.getEntityManager().remove((Object)entity);
                this.getEntityTransaction().commit();
            }
        }
    }

    public void testNoEntityListener() throws EETest.Fault {
        block6: {
            boolean pass = false;
            CallBackCounts.clearCountsMap();
            NoListener entity = new NoListener();
            entity.setId(ID);
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)entity);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)("persisted entity" + entity));
            try {
                pass = this.checkPersistCallBacks();
                if (pass) {
                    TestUtil.logTrace((String)"Test Passed");
                    break block6;
                }
                throw new EETest.Fault("TestNoEntityListener method failed");
            }
            catch (Exception e) {
                throw new EETest.Fault("Exception thrown while testing testNoEntityListener" + e);
            }
            finally {
                this.getEntityManager().remove((Object)entity);
                this.getEntityTransaction().commit();
            }
        }
    }

    private boolean checkPersistCallBacks() throws EETest.Fault {
        boolean result = false;
        if (this.test("prePersist", 1) && this.test("postPersist", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkRemoveCallBacks() throws EETest.Fault {
        boolean result = false;
        if (this.test("preRemove", 1) && this.test("preRemove", 1)) {
            result = true;
        }
        return result;
    }

    private boolean test(String callBackName, int expectedCount) throws EETest.Fault {
        int count = CallBackCounts.getCount((String)callBackName);
        boolean result = false;
        if (count == expectedCount) {
            TestUtil.logTrace((String)("test passed" + callBackName));
            result = true;
        } else {
            TestUtil.logErr((String)("test failed" + callBackName));
        }
        return result;
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYLISTENER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

