/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.deploy.entity.bmp.pkey;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.common.dao.coffee.variants.LongPKCoffeeDAO;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.FinderException;
import jakarta.ejb.NoSuchEntityException;
import jakarta.ejb.RemoveException;
import java.util.Properties;
import javax.naming.NamingException;

public class LongBeanEJB
implements EntityBean {
    private float cofPrice;
    protected TSNamingContext nctx = null;
    protected EntityContext ectx = null;
    protected LongPKCoffeeDAO dao = null;

    public void ping() {
    }

    public Long ejbCreate(Properties props, long cofID, String cofName, float cofPrice) throws CreateException {
        try {
            TestUtil.logTrace((String)"[LongBean] ejbCreate()");
            TestUtil.logTrace((String)"[LongBean] Initialize remote logging");
            TestUtil.init((Properties)props);
            TestUtil.logMsg((String)"[LongBean] DBSupport Init");
            if (null == this.dao) {
                this.dao = DAOFactory.getInstance().getLongPKCoffeeDAO();
            }
            TestUtil.logTrace((String)"[LongBean] Start session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[LongBean] Create new row...");
            this.dao.create(cofID, cofName, cofPrice);
            this.cofPrice = cofPrice;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[LongBean] Caught exception: " + e), (Throwable)e);
            throw new CreateException("Cannot create bean: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
        return new Long(cofID);
    }

    public void ejbPostCreate(Properties props, long cofID, String cofName, float cofPrice) {
        TestUtil.logTrace((String)"[LongBean] ejbPostCreate()");
    }

    public void setEntityContext(EntityContext c) throws EJBException {
        TestUtil.logTrace((String)"[LongBean] setEntityContext()");
        this.ectx = c;
        try {
            TestUtil.logMsg((String)"[LongBean] Obtaining TS Naming Context...");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("[LongBean] Naming Exception : " + e), (Throwable)e);
            throw new EJBException("Cannot obtain Naming Context" + e);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[LongBean] Caught exception: " + e), (Throwable)e);
            throw new EJBException("Caught exception: " + e);
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"[LongBean] unsetEntityContext()");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"[LongBean] ejbRemove()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[LongBean] Initialize DBSupport...");
                this.dao = DAOFactory.getInstance().getLongPKCoffeeDAO();
            }
            TestUtil.logTrace((String)"[LongBean] Start session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[LongBean] Remove row...");
            this.dao.delete((Long)this.ectx.getPrimaryKey());
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[LongBean] Caught Exception: " + e), (Throwable)e);
            throw new RemoveException("Cannot remove bean: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"[LongBean] ejbActivate()");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"[LongBean] ejbPassivate()");
    }

    public void ejbLoad() throws EJBException {
        TestUtil.logTrace((String)"[LongBean] ejbLoad()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[LongBean] Initialize DBSupport()");
                this.dao = DAOFactory.getInstance().getLongPKCoffeeDAO();
            }
            TestUtil.logTrace((String)"[LongBean] Get DB connection...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[LongBean] Load row...");
            this.cofPrice = this.dao.loadPrice((Long)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            TestUtil.logErr((String)"[LongBean] No such entity exists: ", (Throwable)e.getCause());
            throw new NoSuchEntityException("[ejbLoad] DAOException" + e.getCause());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("[ejbLoad] Unable to init DBSupport" + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbStore() throws EJBException {
        TestUtil.logTrace((String)"[LongBean] ejbStore()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[LongBean] Initializing DBSupport...");
                this.dao = DAOFactory.getInstance().getLongPKCoffeeDAO();
            }
            TestUtil.logTrace((String)"[LongBean] Get DB connection...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[LongBean] Store row...");
            this.dao.storePrice((Long)this.ectx.getPrimaryKey(), this.cofPrice);
        }
        catch (DAOException e) {
            TestUtil.logErr((String)"[LongBean] No such entity", (Throwable)e.getCause());
            throw new NoSuchEntityException("[ejbStore] DAOException" + e.getCause());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("[ejbStore] Unable to init DBSupport");
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
            this.dao = null;
        }
    }

    public Long ejbFindByPrimaryKey(Long key) throws FinderException {
        TestUtil.logTrace((String)"[LongBean] ejbFindByPrimaryKey()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[LongBean] Initializing DBSupport...");
                this.dao = DAOFactory.getInstance().getLongPKCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Long l = key;
                return l;
            }
            try {
                throw new FinderException("[LongBean] Key not found: " + key);
            }
            catch (DAOException e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("DAOException " + e.getCause());
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }
}

