/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.resultSet.resultSet47;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;

public class resultSetClient47
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.resultSet.resultSet47";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private Statement stmt = null;
    private PreparedStatement pstmt = null;
    private DataSource ds1 = null;
    private String drManager = null;
    private rsSchema rsSch = null;
    private Properties props = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        resultSetClient47 theTests = new resultSetClient47();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.rsSch = new rsSchema();
                this.stmt = this.conn.createStatement();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetString84() throws EETest.Fault {
        ResultSet oRes = null;
        try {
            this.rsSch.createTab("Timestamp_Tab", this.props, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.props.getProperty("Timestamp_Query_Null", "");
            oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getString(NullValue)");
            this.msg.setMsg("get the Null value from the table using getString Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            String oRetVal = oRes.getString(sColName);
            if (oRetVal == null) {
                this.msg.setMsg("getString returns the Null Value " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the Null Value", "Call to getString is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString is Failed!");
        }
        finally {
            try {
                oRes.close();
                this.stmt.close();
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception eclean) {
                this.msg.printError(eclean, "Call to getString is Failed!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBytes01() throws EETest.Fault {
        String binarySize = null;
        Object createString = null;
        Object createString1 = null;
        Object createString2 = null;
        Object executeString = null;
        ResultSet oRes = null;
        try {
            this.rsSch.createTab("Binary_Tab", this.props, this.conn);
            this.msg.setMsg("extract the Binary Table size from property file");
            binarySize = this.props.getProperty("binarySize");
            this.msg.setMsg("Binary Table Size : " + binarySize);
            String sPrepStmt = this.props.getProperty("Binary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("From File" + this.props.getProperty("bytesize"));
            int bytearrsize = Integer.parseInt(binarySize);
            this.msg.setMsg("ByteArraySize is :" + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setBytes(1, bytearr);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.props.getProperty("Binary_Query_Val", "");
            oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.GetBytes(Value)");
            this.msg.setMsg("get the value from the table using GetBytes Method");
            byte[] oRetVal = oRes.getBytes(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("GetBytes did not return the proper byte array values", "test getBytes Failed");
            }
            this.msg.setMsg("GetBytes returns the proper byte array values");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBytes is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                oRes.close();
                this.stmt.close();
                this.rsSch.dropTab("Binary_Tab", this.conn);
            }
            catch (Exception eclean) {
                this.msg.printError(eclean, "Call to getBytes is Failed!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBytes02() throws EETest.Fault {
        String binarySize = null;
        Object createString = null;
        Object createString1 = null;
        Object createString2 = null;
        Object executeString = null;
        ResultSet oRes = null;
        try {
            this.rsSch.createTab("Binary_Tab", this.props, this.conn);
            this.msg.setMsg("extract the Binary Table size from property file");
            binarySize = this.props.getProperty("binarySize");
            this.msg.setMsg("Binary Table Size : " + binarySize);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.props.getProperty("Binary_Query_Val", "");
            oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.GetBytes(NullValue)");
            this.msg.setMsg("get the Null value from the table using GetBytes Method");
            byte[] oRetVal = oRes.getBytes(1);
            if (oRes.wasNull()) {
                this.msg.setMsg("GetBytes returns the Null Value " + oRetVal);
            } else {
                this.msg.printTestError("GetBytes did not return the Null Value", "test getBytes Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBytes is Failed!");
        }
        finally {
            try {
                oRes.close();
                this.stmt.close();
                this.rsSch.dropTab("Binary_Tab", this.conn);
            }
            catch (Exception eclean) {
                this.msg.printError(eclean, "Call to getBytes is Failed!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBytes03() throws EETest.Fault {
        String varbinarySize = null;
        Object createString = null;
        Object createString1 = null;
        Object createString2 = null;
        Object executeString = null;
        ResultSet oRes = null;
        try {
            this.rsSch.createTab("Varbinary_Tab", this.props, this.conn);
            this.msg.setMsg("extract the Binary Table size from property file");
            varbinarySize = this.props.getProperty("varbinarySize");
            this.msg.setMsg("Varbinary Table Size : " + varbinarySize);
            String sPrepStmt = this.props.getProperty("Varbinary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            int bytearrsize = Integer.parseInt(varbinarySize);
            this.msg.setMsg("ByteArraySize is :" + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setBytes(1, bytearr);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.props.getProperty("Varbinary_Query_Val", "");
            oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.GetBytes(Value)");
            this.msg.setMsg("get the value from the table using GetBytes Method");
            byte[] oRetVal = oRes.getBytes(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("GetBytes did not return the proper byte array values", "test getBytes Failed");
            }
            this.msg.setMsg("GetBytes returns the proper byte array values");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBytes is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                oRes.close();
                this.stmt.close();
                this.rsSch.dropTab("Varbinary_Tab", this.conn);
            }
            catch (Exception eclean) {
                this.msg.printError(eclean, "Call to getBytes is Failed!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBytes04() throws EETest.Fault {
        String varbinarySize = null;
        Object createString = null;
        Object createString1 = null;
        Object createString2 = null;
        Object executeString = null;
        ResultSet oRes = null;
        try {
            this.rsSch.createTab("Varbinary_Tab", this.props, this.conn);
            this.msg.setMsg("extract the Varbinary Table size from property file");
            varbinarySize = this.props.getProperty("varbinarySize");
            this.msg.setMsg("Varbinary Table Size : " + varbinarySize);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.props.getProperty("Varbinary_Query_Val", "");
            oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.GetBytes(NullValue)");
            this.msg.setMsg("get the Null value from the table using GetBytes Method");
            byte[] oRetVal = oRes.getBytes(1);
            if (oRes.wasNull()) {
                this.msg.setMsg("GetBytes returns the Null Value " + oRetVal);
            } else {
                this.msg.printTestError("GetBytes did not return the Null Value", "test getBytes Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBytes is Failed!");
        }
        finally {
            try {
                oRes.close();
                this.stmt.close();
                this.rsSch.dropTab("Varbinary_Tab", this.conn);
            }
            catch (Exception eclean) {
                this.msg.printError(eclean, "Call to getString is Failed!");
            }
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

