/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.pluralattribute;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.metamodelapi.pluralattribute.Uni1XMPerson;
import com.sun.ts.tests.jpa.core.metamodelapi.pluralattribute.Uni1XMProject;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import java.lang.reflect.Member;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void getCollectionType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
            if (mType != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mType.getCollection("projects", Uni1XMProject.class);
                PluralAttribute.CollectionType pluralColType = pluralAttrib.getCollectionType();
                TestUtil.logTrace((String)("collection Type = " + pluralAttrib.getCollectionType()));
                if (pluralColType == PluralAttribute.CollectionType.COLLECTION) {
                    TestUtil.logTrace((String)("Received Expected Collection type = " + pluralColType));
                    pass = true;
                } else {
                    TestUtil.logTrace((String)("Received UnExpected Collection type = " + pluralColType));
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getCollectionType Test  failed");
        }
    }

    public void getElementType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
            if (mType != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mType.getCollection("projects", Uni1XMProject.class);
                TestUtil.logTrace((String)("collection Element Type = " + pluralAttrib.getElementType().getJavaType().getName()));
                String elementTypeName = pluralAttrib.getElementType().getJavaType().getName();
                if (elementTypeName.equals("com.sun.ts.tests.jpa.core.metamodelapi.pluralattribute.Uni1XMProject")) {
                    TestUtil.logTrace((String)("Received Expected Element type = " + elementTypeName));
                    pass = true;
                } else {
                    TestUtil.logTrace((String)("Received UnExpected Element type = " + elementTypeName));
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getElementType Test  failed");
        }
    }

    public void isCollection() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                boolean b = pluralAttrib.isCollection();
                if (b) {
                    TestUtil.logTrace((String)("Received expected result:" + b));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: true, actual: " + b));
                }
            } else {
                TestUtil.logErr((String)"managedType() returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("isCollection Test failed");
        }
    }

    public void isAssociation() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                boolean b = pluralAttrib.isAssociation();
                if (b) {
                    TestUtil.logTrace((String)("Received expected result:" + b));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: true, actual: " + b));
                }
            } else {
                TestUtil.logErr((String)"managedType() returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("isAssociation Test failed");
        }
    }

    public void getPersistentAttributeType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    Attribute.PersistentAttributeType pAttribType = pluralAttrib.getPersistentAttributeType();
                    if (pAttribType == Attribute.PersistentAttributeType.ONE_TO_MANY) {
                        TestUtil.logTrace((String)("Received expected result " + pAttribType));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: " + Attribute.PersistentAttributeType.ONE_TO_MANY.toString() + ", actual:" + pAttribType));
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getPersistentAttributeType Test failed");
        }
    }

    public void getName() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    String name = pluralAttrib.getName();
                    if (name.equals("projects")) {
                        TestUtil.logTrace((String)("Received expected result" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: projects, actual:" + name));
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getName Test failed");
        }
    }

    public void getJavaType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    Class pPluralAttribJavaType = pluralAttrib.getJavaType();
                    if (pPluralAttribJavaType.getName().equals("java.util.Collection")) {
                        TestUtil.logTrace((String)("Received expected result " + pPluralAttribJavaType));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: java.util.Collection, actual:" + pPluralAttribJavaType));
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getJavaType Test failed");
        }
    }

    public void getJavaMember() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    TestUtil.logTrace((String)("Singular attribute JavaMember = " + pluralAttrib.getJavaMember().getName()));
                    Member javaMember = pluralAttrib.getJavaMember();
                    if (javaMember.getName().equals("projects")) {
                        TestUtil.logTrace((String)("Received expected result " + javaMember.getName()));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: projects, actual:" + javaMember.getName()));
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getJavaMember Test  failed");
        }
    }

    public void getBindableType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + pluralAttrib.getName()));
                    Bindable.BindableType bType = pluralAttrib.getBindableType();
                    if (bType != null) {
                        if (bType.name().equals(Bindable.BindableType.PLURAL_ATTRIBUTE.name())) {
                            TestUtil.logTrace((String)("Received expected result:" + bType.name()));
                            pass = true;
                        } else {
                            TestUtil.logErr((String)("Expected: " + Bindable.BindableType.PLURAL_ATTRIBUTE.name() + ", actual:" + bType.name()));
                        }
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getBindableType Test  failed");
        }
    }

    public void getBindableJavaType() throws EETest.Fault {
        boolean pass = false;
        String expected = "com.sun.ts.tests.jpa.core.metamodelapi.pluralattribute.Uni1XMProject";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + pluralAttrib.getName()));
                    Class cType = pluralAttrib.getBindableJavaType();
                    if (cType != null) {
                        if (cType.getName().equals(expected)) {
                            TestUtil.logTrace((String)("Received expected result:" + cType.getName()));
                            pass = true;
                        } else {
                            TestUtil.logErr((String)("Expected: " + expected + ", actual:" + cType.getName()));
                        }
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getBindableJavaType Test  failed");
        }
    }

    public void getDeclaringType() throws EETest.Fault {
        boolean pass = false;
        String expected = "com.sun.ts.tests.jpa.core.metamodelapi.pluralattribute.Uni1XMPerson";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    ManagedType type = pluralAttrib.getDeclaringType();
                    if (type != null) {
                        String name = type.getJavaType().getName();
                        if (name.equals(expected)) {
                            TestUtil.logTrace((String)("Received expected result:" + name));
                            pass = true;
                        } else {
                            TestUtil.logErr((String)("Expected: " + expected + ", actual:" + name));
                        }
                    } else {
                        TestUtil.logErr((String)"getDeclaringType() returned null");
                    }
                } else {
                    TestUtil.logErr((String)"getCollection(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"managedType() returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaringType Test  failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        try {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception re) {
            TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
        }
    }
}

