/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.mapkeycolumn;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.mapkeycolumn.Department;
import com.sun.ts.tests.jpa.core.annotations.mapkeycolumn.Department2;
import com.sun.ts.tests.jpa.core.annotations.mapkeycolumn.Employee;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    private static Employee[] empRef = new Employee[10];
    private static Department[] deptRef = new Department[5];
    private static Department2[] deptRef2 = new Department2[5];
    public Map<String, Employee> link = new HashMap<String, Employee>();

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationMapKeyColumnTest1() throws EETest.Fault {
        boolean pass = false;
        List e = null;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find Employees belonging to Department: Marketing");
            e = this.getEntityManager().createQuery("Select e from Employee e where e.department.name = 'Marketing'").setMaxResults(10).getResultList();
            if (e.size() != 3) {
                TestUtil.logErr((String)("Did not get expected resultsExpected 3 Employees, Received: " + e.size()));
            } else {
                TestUtil.logTrace((String)("annotationMapKeyColumnTest1: Expected results received. Expected 3 Employees, Received: " + e.size()));
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("annotationMapKeyColumnTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationMapKeyColumnTest2() throws EETest.Fault {
        boolean pass = false;
        List e = null;
        try {
            this.getEntityTransaction().begin();
            Object[] expectedEmps = new Integer[]{4, 2};
            TestUtil.logTrace((String)"find Employees belonging to Department: Marketing");
            e = this.getEntityManager().createQuery("Select e.id from Employee e where e.department.name = 'Administration' ORDER BY e.id DESC").setMaxResults(10).getResultList();
            Object[] result = e.toArray(new Integer[e.size()]);
            TestUtil.logTrace((String)"Compare results of Employee Ids ");
            pass = Arrays.equals(expectedEmps, result);
            if (!pass) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 Employees :  Received: " + e.size()));
                Iterator it = e.iterator();
                while (it.hasNext()) {
                    TestUtil.logTrace((String)(" Employee PK : " + it.next()));
                }
            } else {
                TestUtil.logTrace((String)"Expected results received");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)ex);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("annotationMapKeyColumnTest2 failed");
        }
    }

    public void annotationMapKeyColumnTest3() throws EETest.Fault {
        boolean pass = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(0);
        expected.add(2);
        expected.add(4);
        ArrayList<Integer> actual = new ArrayList<Integer>();
        try {
            this.getEntityTransaction().begin();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            TestUtil.logTrace((String)("Name:" + emp.getFirstName() + " " + emp.getLastName()));
            Department dept = emp.getDepartment();
            TestUtil.logTrace((String)("Dept=" + dept.getName()));
            Map emps = dept.getLastNameEmployees();
            if (emps.size() == 3) {
                TestUtil.logTrace((String)("number of employees=" + emps.size()));
                for (Map.Entry entry : emps.entrySet()) {
                    TestUtil.logTrace((String)("id=" + ((Employee)entry.getValue()).getId() + ", Name=" + ((Employee)entry.getValue()).getFirstName() + " " + ((Employee)entry.getValue()).getLastName()));
                    actual.add(((Employee)entry.getValue()).getId() - 1);
                }
                Collections.sort(actual);
                if (expected.equals(actual)) {
                    TestUtil.logTrace((String)"Received expected employees");
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Did not get correct employees");
                    TestUtil.logErr((String)"Expected:");
                    for (Integer i : expected) {
                        TestUtil.logTrace((String)("id=" + empRef[i].getId() + ", Name=" + empRef[i].getFirstName() + " " + empRef[i].getLastName()));
                    }
                    TestUtil.logErr((String)"Actual:");
                    for (Integer i : actual) {
                        TestUtil.logTrace((String)("id=" + empRef[i].getId() + ", Name=" + empRef[i].getFirstName() + " " + empRef[i].getLastName()));
                    }
                }
            } else {
                TestUtil.logErr((String)("Expected 3 employees, actual:" + emps.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("annotationMapKeyColumnTest3 Failed");
        }
    }

    public void mapKeyColumnInsertableFalseTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            Department2 dept = (Department2)this.getEntityManager().find(Department2.class, (Object)3);
            if (dept != null) {
                TestUtil.logTrace((String)("Dept=" + dept.getName()));
                Map emps = dept.getLastNameEmployees();
                if (emps.size() == 0) {
                    TestUtil.logTrace((String)"Received expected number of employees");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected 0 employees, actual:" + emps.size()));
                    TestUtil.logErr((String)"Actual:");
                    for (Map.Entry entry : emps.entrySet()) {
                        TestUtil.logErr((String)("id=" + ((Employee)entry.getValue()).getId() + ", Name=" + ((Employee)entry.getValue()).getFirstName() + " " + ((Employee)entry.getValue()).getLastName()));
                    }
                }
            } else {
                TestUtil.logErr((String)"Department2 returned was null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("mapKeyColumnInsertableFalseTest Failed");
        }
    }

    public void mapKeyColumnUpdatableFalseTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            TestUtil.logTrace((String)"find Department");
            Department2 dept = (Department2)this.getEntityManager().find(Department2.class, (Object)deptRef2[0].getId());
            TestUtil.logTrace((String)("Dept=" + dept.getName()));
            this.link = new HashMap<String, Employee>();
            this.link.put("OFF-006", empRef[6]);
            TestUtil.logTrace((String)"set last names of employees and save");
            dept.setLastNameEmployees(this.link);
            this.getEntityManager().merge((Object)dept);
            this.getEntityManager().flush();
            this.clearCache();
            TestUtil.logTrace((String)"find Department again");
            dept = (Department2)this.getEntityManager().find(Department2.class, (Object)deptRef2[0].getId());
            Map emps = dept.getLastNameEmployees();
            if (emps.size() == 0) {
                TestUtil.logTrace((String)("Received expected number of employees for department: " + deptRef2[0].getId()));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected 0 employees, actual:" + emps.size()));
                TestUtil.logErr((String)"Actual:");
                for (Map.Entry entry : emps.entrySet()) {
                    TestUtil.logErr((String)("id=" + ((Employee)entry.getValue()).getId() + ", Name=" + ((Employee)entry.getValue()).getFirstName() + " " + ((Employee)entry.getValue()).getLastName()));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("mapKeyColumnUpdatableFalseTest Failed");
        }
    }

    public void criteriaBuilderKeysValuesTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<String> expected = new HashSet<String>();
        expected.add("OFF-000");
        expected.add("OFF-002");
        expected.add("OFF-004");
        try {
            this.getEntityTransaction().begin();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            System.out.println("Name:" + emp.getFirstName() + " " + emp.getLastName());
            Department dept = emp.getDepartment();
            System.out.println("Dept=" + dept.getName());
            Map emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry entry : emps.entrySet()) {
                    TestUtil.logTrace((String)("map:" + (String)entry.getKey() + ", " + ((Employee)entry.getValue()).getId() + " " + ((Employee)entry.getValue()).getFirstName() + " " + ((Employee)entry.getValue()).getLastName()));
                }
            }
            Set keys = emps.keySet();
            for (String key : keys) {
                TestUtil.logTrace((String)("key:" + key));
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                TestUtil.logTrace((String)"Received expected keys");
                pass1 = true;
            } else {
                TestUtil.logErr((String)"Did not received expected keys");
                TestUtil.logErr((String)"Expected:");
                for (String key : expected) {
                    TestUtil.logTrace((String)("key:" + key));
                }
                TestUtil.logErr((String)"Actual:");
                for (String key : keys) {
                    TestUtil.logTrace((String)("key:" + key));
                }
            }
            HashSet<Employee> hashSet = new HashSet<Employee>();
            hashSet.add(empRef[0]);
            hashSet.add(empRef[2]);
            hashSet.add(empRef[4]);
            Collection employees = emps.values();
            for (Employee e : employees) {
                TestUtil.logTrace((String)("values:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName()));
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                TestUtil.logTrace((String)"Received expected values");
                pass2 = true;
            } else {
                TestUtil.logErr((String)"Did not received expected values");
                TestUtil.logErr((String)"Expected:");
                for (Employee e : hashSet) {
                    TestUtil.logTrace((String)("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName()));
                }
                TestUtil.logErr((String)"Actual:");
                for (Employee e : employees) {
                    TestUtil.logTrace((String)("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName()));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)ex);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("criteriaBuilderKeysValuesTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        TestUtil.logTrace((String)"createTestData");
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create 2 Departments");
            Client.deptRef[0] = new Department(1, "Marketing");
            Client.deptRef[1] = new Department(2, "Administration");
            TestUtil.logTrace((String)"Start to persist departments ");
            for (Department department : deptRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted department " + department.getName()));
            }
            TestUtil.logTrace((String)"Create 2 Department2 ");
            Client.deptRef2[0] = new Department2(3, "IT");
            TestUtil.logTrace((String)"Start to persist Department2 ");
            for (Department department : deptRef2) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted department " + department.getName()));
            }
            TestUtil.logTrace((String)"Create 5 employees");
            Client.empRef[0] = new Employee(1, "Alan", "Frechette");
            empRef[0].setDepartment(deptRef[0]);
            Client.empRef[1] = new Employee(2, "Arthur", "Frechette");
            empRef[1].setDepartment(deptRef[1]);
            Client.empRef[2] = new Employee(3, "Shelly", "McGowan");
            empRef[2].setDepartment(deptRef[0]);
            Client.empRef[3] = new Employee(4, "Robert", "Bissett");
            empRef[3].setDepartment(deptRef[1]);
            Client.empRef[4] = new Employee(5, "Stephen", "DMilla");
            empRef[4].setDepartment(deptRef[0]);
            this.link.put("OFF-000", empRef[0]);
            this.link.put("OFF-002", empRef[2]);
            this.link.put("OFF-004", empRef[4]);
            deptRef[0].setLastNameEmployees(this.link);
            this.link = new HashMap<String, Employee>();
            this.link.put("OFF-001", empRef[1]);
            this.link.put("OFF-003", empRef[3]);
            deptRef[1].setLastNameEmployees(this.link);
            this.link = new HashMap<String, Employee>();
            this.link.put("OFF-005", empRef[5]);
            deptRef2[0].setLastNameEmployees(this.link);
            TestUtil.logTrace((String)"Start to persist employees ");
            for (Department department : empRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted employee " + department.getId()));
            }
            TestUtil.logTrace((String)"Start to Merge department ");
            for (Department department : deptRef) {
                if (department == null) continue;
                this.getEntityManager().merge((Object)department);
                TestUtil.logTrace((String)("merged department " + department.getName()));
            }
            TestUtil.logTrace((String)"Start to Merge department ");
            for (Department department : deptRef2) {
                if (department == null) continue;
                this.getEntityManager().merge((Object)department);
                TestUtil.logTrace((String)("merged department " + department.getName()));
            }
            TestUtil.logTrace((String)"Start to persist employees ");
            for (Department department : empRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted employee " + department.getId()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMP_MAPKEYCOL").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

