/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices13.servlet.WSWebServiceRefLookupDDs.client;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.JAXWS_Data;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import com.sun.ts.tests.webservices13.servlet.WSWebServiceRefLookupDDs.client.Echo;
import com.sun.ts.tests.webservices13.servlet.WSWebServiceRefLookupDDs.client.EchoService;
import com.sun.ts.tests.webservices13.servlet.WSWebServiceRefLookupDDs.client.EjbClientIF;
import jakarta.ejb.EJB;
import jakarta.xml.ws.WebServiceRef;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;

public class Client
extends EETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    private static final String PKG_NAME = "com.sun.ts.tests.webservices13.servlet.WSWebServiceRefLookupDDs.client.";
    private TSURL ctsurl = new TSURL();
    private String hostname = "localhost";
    private int portnum = 8000;
    private static final String ENDPOINT_URL = "wswsreflookupdds.endpoint.1";
    private static final String WSDLLOC_URL = "wswsreflookupdds.wsdlloc.1";
    private String urlString = null;
    private URL wsdlurl = null;
    private static final String SERVICE_NAME = "EchoService";
    private static final String PORT_NAME = "EchoPort";
    private static final String NAMESPACEURI = "http://echo.org/wsdl";
    private QName SERVICE_QNAME = new QName("http://echo.org/wsdl", "EchoService");
    private QName PORT_QNAME = new QName("http://echo.org/wsdl", "EchoPort");
    private URL url = null;
    private URLConnection urlConn = null;
    private Properties props = null;
    private String SERVLET = "/WSWSRefLookupDDsClnt2_web/ServletTest";
    static EchoService service = null;
    Echo port = null;
    @WebServiceRef(lookup="bogus")
    static EchoService service2 = null;
    Echo port2 = null;
    @EJB(name="ejb/WSWebServiceRefLookupDDsClntBean")
    static EjbClientIF ejbclient;

    private void getPort() throws Exception {
        this.getTestURLs();
        InitialContext ctx = new InitialContext();
        TestUtil.logMsg((String)"JNDI lookup java:comp/env/service/wswsreflookupddsservice");
        service = (EchoService)((Object)ctx.lookup("java:comp/env/service/wswsreflookupddsservice"));
        TestUtil.logMsg((String)("AppClient DEBUG: service=" + service));
        this.port = (Echo)service.getPort(Echo.class);
        TestUtil.logMsg((String)"AppClient DEBUG: Obtained port");
        TestUtil.logMsg((String)("AppClient DEBUG: port=" + this.port));
        this.getTargetEndpointAddress(this.port);
        TestUtil.logMsg((String)("AppClient DEBUG: service2=" + service2));
        TestUtil.logMsg((String)"AppClient DEBUG: Obtained port");
        this.port2 = (Echo)service2.getPort(Echo.class);
        TestUtil.logMsg((String)("AppClient DEBUG: port2=" + this.port2));
        JAXWS_Util.setTargetEndpointAddress(this.port2, this.urlString);
        this.getTargetEndpointAddress(this.port2);
    }

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXWS_Util.getURLFromProp(ENDPOINT_URL);
        this.urlString = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXWS_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.urlString));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
    }

    private void getTargetEndpointAddress(Object port) throws Exception {
        TestUtil.logMsg((String)("Get Target Endpoint Address for port=" + port));
        String urlString = JAXWS_Util.getTargetEndpointAddress(port);
        TestUtil.logMsg((String)("Target Endpoint Address=" + urlString));
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        boolean pass = true;
        this.props = p;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.getPort();
            TestUtil.logMsg((String)("AppClient DEBUG: ejbclient=" + ejbclient));
            TestUtil.logMsg((String)("AppClient DEBUG: service=" + service));
            TestUtil.logMsg((String)("AppClient DEBUG: port=" + this.port));
            TestUtil.logMsg((String)("AppClient DEBUG: service2=" + service2));
            TestUtil.logMsg((String)("AppClient DEBUG: port2=" + this.port2));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (service == null || service2 == null || this.port == null || this.port2 == null) {
            throw new EETest.Fault("setup failed: injection failure");
        }
        TestUtil.logMsg((String)("setup() Endpoint urlString=" + this.urlString));
        p.setProperty("ENDPOINTURL", this.urlString);
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void testwsreflookup() throws EETest.Fault {
        TestUtil.logMsg((String)"testwsreflookup");
        boolean pass = true;
        TestUtil.logMsg((String)"-------------------------------");
        TestUtil.logMsg((String)"Test appclient invocation .....");
        TestUtil.logMsg((String)"-------------------------------");
        TestUtil.logMsg((String)"AppClient invoking EchoService stringTest() method");
        if (!this.stringTest()) {
            pass = false;
            TestUtil.logErr((String)"Failed in appclient");
        } else {
            TestUtil.logMsg((String)"Passed in appclient");
        }
        try {
            TestUtil.logMsg((String)"-----------------------------------");
            TestUtil.logMsg((String)"Test servletclient invocation .....");
            TestUtil.logMsg((String)"-----------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + this.url));
            this.props.setProperty("TEST", "testwsreflookup");
            TestUtil.logMsg((String)("Endpoint urlString=" + this.urlString));
            this.props.setProperty("ENDPOINTURL", this.urlString);
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"Failed in servletclient");
            } else {
                TestUtil.logMsg((String)"Passed in servletclient");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Failed on servletclient invocation");
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"Test ejbclient invocation .....");
            TestUtil.logMsg((String)"-------------------------------");
            boolean passEjb = ejbclient.testwsreflookup(this.props);
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"Failed in ejbclient");
            } else {
                TestUtil.logMsg((String)"Passed in ejbclient");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Failed on ejbclient invocation");
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("testwsreflookup failed");
        }
    }

    public boolean stringTest() throws EETest.Fault {
        TestUtil.logMsg((String)"stringTest");
        boolean pass = true;
        String request = "Mary";
        try {
            String response = this.port2.echoString(request);
            if (!JAXWS_Data.compareValues(request, response, "String")) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("stringTest failed", e);
        }
        return pass;
    }
}

