/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgTypesT2;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import java.io.Serializable;
import java.util.Properties;

public class MsgBeanMsgTestT2
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;
    private TopicConnectionFactory tFactory = null;
    private TopicConnection tConnection = null;
    private Topic topic = null;
    private TopicPublisher tPublisher = null;
    private TopicSession tSession = null;

    public MsgBeanMsgTestT2() {
        TestUtil.logTrace((String)"@MsgBeanMsgTest2()!");
    }

    public void ejbCreate() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesT2  - @MsgBeanMsgTest2-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                TestUtil.logTrace((String)"qFactory error");
            }
            TestUtil.logTrace((String)"got a qFactory !!");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                TestUtil.logTrace((String)"queueR error");
            }
            this.tFactory = (TopicConnectionFactory)this.context.lookup("java:comp/env/jms/MyTopicConnectionFactory");
            if (this.tFactory == null) {
                TestUtil.logTrace((String)"tFactory error");
            }
            TestUtil.logTrace((String)"got a tFactory !!");
            this.topic = (Topic)this.context.lookup("java:comp/env/jms/MDB_TOPIC");
            if (this.topic == null) {
                TestUtil.logTrace((String)"topic error");
            }
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps(msg, this.p);
        TestUtil.logTrace((String)("from jms.ee.mdb.mdb_msgTypesT2 @onMessage!" + msg));
        try {
            TestUtil.logTrace((String)("TestCase:" + msg.getStringProperty("TestCase")));
            TestUtil.logTrace((String)("onMessage will run TestCase: " + msg.getStringProperty("TestCase")));
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                TestUtil.logTrace((String)"connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            this.tConnection = this.tFactory.createTopicConnection();
            if (this.tConnection == null) {
                TestUtil.logTrace((String)"connection error");
            } else {
                this.tConnection.start();
                this.tSession = this.tConnection.createTopicSession(true, 0);
            }
            if (msg.getStringProperty("TestCase").equals("messageObjectCopyTopicTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running messageObjectCopyTopicTestCreate - create the message");
                this.messageObjectCopyTopicTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("messageObjectCopyTopicTest")) {
                TestUtil.logTrace((String)"@onMessage - running messageObjectCopyTopicTest - read and verify the message");
                this.messageObjectCopyTopicTest((ObjectMessage)msg);
            }
            if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsBooleanCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsBooleanCreate - create the message");
                this.streamMessageConversionTopicTestsBooleanCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsBoolean")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsBoolean - read and verify the message");
                this.streamMessageConversionTopicTestsBoolean((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsByteCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsByteCreate - create the message");
                this.streamMessageConversionTopicTestsByteCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsByte")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsByte - read and verify the message");
                this.streamMessageConversionTopicTestsByte((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsShortCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsShortCreate - create the message");
                this.streamMessageConversionTopicTestsShortCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsShort")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsShort - read and verify the message");
                this.streamMessageConversionTopicTestsShort((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsIntCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsIntCreate - create the message");
                this.streamMessageConversionTopicTestsIntCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsInt")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsInt - read and verify the message");
                this.streamMessageConversionTopicTestsInt((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsLongCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsLongCreate - create the message");
                this.streamMessageConversionTopicTestsLongCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsLong")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsLong - read and verify the message");
                this.streamMessageConversionTopicTestsLong((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsFloatCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsFloatCreate - create the message");
                this.streamMessageConversionTopicTestsFloatCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsFloat")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsFloat - read and verify the message");
                this.streamMessageConversionTopicTestsFloat((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsDoubleCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsDoubleCreate - create the message");
                this.streamMessageConversionTopicTestsDoubleCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsDouble")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsDouble - read and verify the message");
                this.streamMessageConversionTopicTestsDouble((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsStringCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsStringCreate - create the message");
                this.streamMessageConversionTopicTestsStringCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsString")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsString - read and verify the message");
                this.streamMessageConversionTopicTestsString((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsCharCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsCharCreate - create the message");
                this.streamMessageConversionTopicTestsCharCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsChar")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsChar - read and verify the message");
                this.streamMessageConversionTopicTestsChar((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsBytesCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsBytesCreate - create the message");
                this.streamMessageConversionTopicTestsBytesCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsBytes")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsBytes - read and verify the message");
                this.streamMessageConversionTopicTestsBytes((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsInvFormatStringCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsInvFormatStringCreate - create the message");
                this.streamMessageConversionTopicTestsInvFormatStringCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsInvFormatString")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionTopicTestsInvFormatString - read and verify the message");
                this.streamMessageConversionTopicTestsInvFormatString((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageTopicTestsFullMsgCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageTopicTestsFullMsgCreate - create the message");
                this.streamMessageTopicTestsFullMsgCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageTopicTestsFullMsg")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageTopicTestsFullMsg - read and verify the message");
                this.streamMessageTopicTestsFullMsg((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageTopicTestNullCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageTopicTestNullCreate - create the message");
                this.streamMessageTopicTestNullCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageTopicTestNull")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageTopicTestNull - read and verify the message");
                this.streamMessageTopicTestNull((StreamMessage)msg);
            } else {
                TestUtil.logTrace((String)"@onMessage - invalid message type found in StringProperty");
            }
            TestUtil.logTrace((String)"@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
            if (this.tConnection != null) {
                try {
                    this.tConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    public void messageObjectCopyTopicTestCreate() {
        boolean pass = true;
        try {
            ObjectMessage messageSentObjectMsg = null;
            StringBuffer sBuff = new StringBuffer("This is");
            String initial = "This is";
            messageSentObjectMsg = this.qSession.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)messageSentObjectMsg, this.p);
            messageSentObjectMsg.setObject((Serializable)sBuff);
            sBuff.append("a test ");
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "messageObjectCopyTopicTest");
            messageSentObjectMsg.setStringProperty("TestCase", "messageObjectCopyTopicTest");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSentObjectMsg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsBooleanCreate() {
        try {
            StreamMessage messageSent = null;
            boolean abool = true;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsBoolean");
            TestUtil.logTrace((String)"Verify conversion support for boolean primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsBoolean");
            messageSent.writeBoolean(abool);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsByteCreate() {
        try {
            StreamMessage messageSent = null;
            byte bValue = 127;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsByte");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsByte");
            messageSent.writeByte(bValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsShortCreate() {
        try {
            StreamMessage messageSent = null;
            short sValue = 1;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsShort");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsShort");
            messageSent.writeShort(sValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsIntCreate() {
        try {
            StreamMessage messageSent = null;
            int iValue = 6;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsInt");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsInt");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeInt(iValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsLongCreate() {
        try {
            StreamMessage messageSent = null;
            long lValue = 2L;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsLong");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsLong");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeLong(lValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsFloatCreate() {
        try {
            StreamMessage messageSent = null;
            float fValue = 5.0f;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsFloat");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsFloat");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeFloat(fValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsDoubleCreate() {
        try {
            StreamMessage messageSent = null;
            double dValue = 3.0;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsDouble");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsDouble");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeDouble(dValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsStringCreate() {
        try {
            StreamMessage messageSent = null;
            String myString = "10";
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsString");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsString");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeString(myString);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsCharCreate() {
        try {
            StreamMessage messageSent = null;
            char charValue = 'a';
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsChar");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsChar");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeChar(charValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsBytesCreate() {
        try {
            StreamMessage messageSent = null;
            byte[] bValues = new byte[]{1, 2, 3};
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsBytes");
            TestUtil.logTrace((String)"Verify conversion support for byte[] primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsBytes");
            messageSent.writeBytes(bValues);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsInvFormatStringCreate() {
        try {
            StreamMessage messageSent = null;
            String myString = "mytest string";
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsInvFormatString");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsInvFormatString");
            messageSent.writeString(myString);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageTopicTestsFullMsgCreate() {
        try {
            StreamMessage messageSent = null;
            byte bValue = 127;
            boolean abool = false;
            byte[] bValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            byte[] bValues2 = new byte[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
            char charValue = 'Z';
            short sValue = Short.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = 6;
            boolean pass = true;
            String myString = "text";
            String sTesting = "Testing StreamMessages";
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageTopicTestsFullMsg");
            messageSent.writeBytes(bValues2, 0, bValues.length);
            messageSent.writeBoolean(abool);
            messageSent.writeByte(bValue);
            messageSent.writeBytes(bValues);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(dValue);
            messageSent.writeFloat(fValue);
            messageSent.writeInt(iValue);
            messageSent.writeLong(lValue);
            messageSent.writeObject((Object)sTesting);
            messageSent.writeShort(sValue);
            messageSent.writeString(myString);
            messageSent.writeObject(null);
            messageSent.setStringProperty("TestCase", "streamMessageTopicTestsFullMsg");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageTopicTestNullCreate() {
        try {
            StreamMessage messageSent = null;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageTopicTestNull");
            TestUtil.logTrace((String)"writeString(null) ");
            messageSent.setStringProperty("TestCase", "streamMessageTopicTestNull");
            messageSent.writeString(null);
            TestUtil.logTrace((String)"Sending message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void messageObjectCopyTopicTest(ObjectMessage messageReceivedObjectMsg) {
        boolean pass = true;
        String testCase = "messageObjectCopyTopicTest";
        String initial = "This is";
        try {
            TestUtil.logMsg((String)"Ensure that changing the object did not change the message");
            StringBuffer s = (StringBuffer)messageReceivedObjectMsg.getObject();
            TestUtil.logTrace((String)("s is " + s));
            if (s.toString().equals(initial)) {
                TestUtil.logTrace((String)"Pass: msg was not changed");
            } else {
                TestUtil.logTrace((String)"Fail: msg was changed!");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsBoolean(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsBoolean";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a boolean");
            try {
                if (messageReceived.readBoolean() == abool) {
                    TestUtil.logTrace((String)"Pass: boolean to boolean - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a boolean");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Boolean.valueOf(abool).toString())) {
                    TestUtil.logTrace((String)"Pass: boolean to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read a boolean - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                bValue = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readLong();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsByte(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsByte";
        try {
            byte bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Byte.toString(bValue))) {
                    TestUtil.logTrace((String)"Pass: byte to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read a byte - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readByte() == bValue) {
                    TestUtil.logTrace((String)"Pass: byte to byte - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == bValue) {
                    TestUtil.logTrace((String)"Pass: byte to short - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                pass = false;
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == bValue) {
                    TestUtil.logTrace((String)"Pass: byte to int - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)bValue) {
                    TestUtil.logTrace((String)"Pass: byte to long - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsShort(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsShort";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            short sValue = 1;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a short - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Short.toString(sValue))) {
                    TestUtil.logTrace((String)"Pass: short to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read a short - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a short - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == sValue) {
                    TestUtil.logTrace((String)"Pass: short to short - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a short - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == sValue) {
                    TestUtil.logTrace((String)"Pass: short to int - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)sValue) {
                    TestUtil.logTrace((String)"Pass: short to long - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a short - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a short - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsInt(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsInt";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read an int - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Integer.toString(iValue))) {
                    TestUtil.logTrace((String)"Pass: int to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read an int - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read an int - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read an int");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read an int - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == iValue) {
                    TestUtil.logTrace((String)"Pass: int to int - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)iValue) {
                    TestUtil.logTrace((String)"Pass: int to long - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read an int - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read an int - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsLong(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsLong";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a long - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a long");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Long.toString(lValue))) {
                    TestUtil.logTrace((String)"Pass: long to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read  a long - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read an long - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a long");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a long - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a long");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a long");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == lValue) {
                    TestUtil.logTrace((String)"Pass: int to long - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a long - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read an long - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsFloat(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsFloat";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a float  ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a float");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Float.toString(fValue))) {
                    TestUtil.logTrace((String)"Pass: float to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read  a float ");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a float  ");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a float");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a long  ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a float");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a long");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a float  ");
            try {
                messageReceived.reset();
                if (messageReceived.readFloat() == fValue) {
                    TestUtil.logTrace((String)"Pass: float to float - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read an float  ");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == (double)fValue) {
                    TestUtil.logTrace((String)"Pass: float to double - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsDouble(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsDouble";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a double  ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a double");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Double.toString(dValue))) {
                    TestUtil.logTrace((String)"Pass: double to string");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read  a double ");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a double  ");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a double");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a double  ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a double");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a double");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a double  ");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a double  ");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == dValue) {
                    TestUtil.logTrace((String)"Pass: double to double ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsString(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsString";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            String myString = "10";
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(myString)) {
                    TestUtil.logTrace((String)"Pass: string to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read a String");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readByte() == Byte.parseByte(myString)) {
                    TestUtil.logTrace((String)"Pass: String to byte ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a string");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == Short.parseShort(myString)) {
                    TestUtil.logTrace((String)"Pass: String to short ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a String ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == Integer.parseInt(myString)) {
                    TestUtil.logTrace((String)"Pass: String to int ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == Long.parseLong(myString)) {
                    TestUtil.logTrace((String)"Pass: String to long ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readFloat() == Float.parseFloat(myString)) {
                    TestUtil.logTrace((String)"Pass: String to float ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == Double.parseDouble(myString)) {
                    TestUtil.logTrace((String)"Pass: String to double ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a string ");
            try {
                messageReceived.clearBody();
                messageReceived.writeString("true");
                messageReceived.reset();
                if (messageReceived.readBoolean() == abool) {
                    TestUtil.logTrace((String)"Pass: String to boolean ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a string  that is !true ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                if (!b) {
                    TestUtil.logTrace((String)"Fail: !true should return false");
                    pass = false;
                } else {
                    TestUtil.logTrace((String)"Pass: !true returned false");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsChar(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsChar";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a char - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a char");
            try {
                messageReceived.reset();
                String s = messageReceived.readString();
                TestUtil.logTrace((String)("char returned for \"a\" is : " + s));
                if (s.equals("a")) {
                    TestUtil.logTrace((String)"Pass: char to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read a char - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a char - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a char");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a char ");
            try {
                messageReceived.reset();
                if (messageReceived.readChar() == 'a') {
                    TestUtil.logTrace((String)"Pass: char to char - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a char ");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a char");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a char - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a char - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsBytes(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsBytes";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues2 = new byte[]{0, 0, 0};
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read a byte[] ");
            boolean nCount = false;
            try {
                messageReceived.reset();
                if (messageReceived.readBytes(bValues2) == 3) {
                    TestUtil.logTrace((String)"Pass: byte[] to byte[] - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: count incorrect");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a byte[]");
            messageReceived.reset();
            try {
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a byte[]");
            try {
                messageReceived.reset();
                String s = messageReceived.readString();
                TestUtil.logTrace((String)"Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsInvFormatString(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsInvFormatString";
        try {
            boolean pass = true;
            String myString = "mytest string";
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a String that is not valid ");
            try {
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: java.lang.NumberFormatException expected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof NumberFormatException) {
                    TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Verify that the data can be read as a string and pointer did not move");
            try {
                String s = messageReceived.readString();
                TestUtil.logTrace((String)("message read: " + s));
                if (s.equals(myString)) {
                    TestUtil.logTrace((String)"Pass: able to read the string");
                } else {
                    TestUtil.logTrace((String)"Fail: string not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a string that is not valid ");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof NumberFormatException) {
                    TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a String that is not valid ");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof NumberFormatException) {
                    TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a String that is not valid ");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof NumberFormatException) {
                    TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a String that is not valid ");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof NumberFormatException) {
                    TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a String that is not valid ");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof NumberFormatException) {
                    TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageTopicTestsFullMsg(StreamMessage messageReceived) {
        String testCase = "streamMessageTopicTestsFullMsg";
        try {
            int i;
            byte bValue = 127;
            boolean abool = false;
            byte[] bValues2 = new byte[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
            byte[] bValuesReturned = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            byte[] bValuesReturned2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            char charValue = 'Z';
            short sValue = Short.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = 6;
            boolean pass = true;
            String myString = "text";
            String sTesting = "Testing StreamMessages";
            try {
                int nCount = bValuesReturned2.length;
                do {
                    nCount = messageReceived.readBytes(bValuesReturned2);
                    TestUtil.logTrace((String)("nCount is " + nCount));
                    if (nCount == -1) continue;
                    for (i = 0; i < bValuesReturned2.length; ++i) {
                        if (bValuesReturned2[i] != bValues2[i]) {
                            TestUtil.logTrace((String)("Fail: byte[] " + i + " is not valid"));
                            pass = false;
                            continue;
                        }
                        TestUtil.logTrace((String)("PASS: byte[]" + i + " is valid"));
                    }
                } while (nCount >= bValuesReturned2.length);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readBoolean() == abool) {
                    TestUtil.logTrace((String)"Pass: boolean returned ok");
                } else {
                    TestUtil.logTrace((String)"Fail: boolean not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readByte() == bValue) {
                    TestUtil.logTrace((String)"Pass: Byte returned ok");
                } else {
                    TestUtil.logTrace((String)"Fail: Byte not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                int nCount = bValuesReturned.length;
                do {
                    nCount = messageReceived.readBytes(bValuesReturned);
                    TestUtil.logTrace((String)("nCount is " + nCount));
                    if (nCount == -1) continue;
                    for (i = 0; i < bValuesReturned2.length; ++i) {
                        if (bValuesReturned2[i] != bValues2[i]) {
                            TestUtil.logTrace((String)("Fail: byte[] " + i + " is not valid"));
                            pass = false;
                            continue;
                        }
                        TestUtil.logTrace((String)("PASS: byte[]" + i + " is valid"));
                    }
                } while (nCount >= bValuesReturned.length);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readChar() == charValue) {
                    TestUtil.logTrace((String)"Pass: correct char");
                } else {
                    TestUtil.logTrace((String)"Fail: char not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readDouble() == dValue) {
                    TestUtil.logTrace((String)"Pass: correct double");
                } else {
                    TestUtil.logTrace((String)"Fail: double not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readFloat() == fValue) {
                    TestUtil.logTrace((String)"Pass: correct float");
                } else {
                    TestUtil.logTrace((String)"Fail: float not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readInt() == iValue) {
                    TestUtil.logTrace((String)"Pass: correct int");
                } else {
                    TestUtil.logTrace((String)"Fail: int not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readLong() == lValue) {
                    TestUtil.logTrace((String)"Pass: correct long");
                } else {
                    TestUtil.logTrace((String)"Fail: long not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readObject().equals(sTesting)) {
                    TestUtil.logTrace((String)"Pass: correct object");
                } else {
                    TestUtil.logTrace((String)"Fail: object not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readShort() == sValue) {
                    TestUtil.logTrace((String)"Pass: correct short");
                } else {
                    TestUtil.logTrace((String)"Fail: short not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readString().equals(myString)) {
                    TestUtil.logTrace((String)"Pass: correct string");
                } else {
                    TestUtil.logTrace((String)"Fail: string not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readObject() == null) {
                    TestUtil.logTrace((String)"Pass: correct object");
                } else {
                    TestUtil.logTrace((String)"Fail: object not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageTopicTestNull(StreamMessage messageReceived) {
        String testCase = "streamMessageTopicTestNull";
        try {
            boolean pass = true;
            try {
                if (messageReceived.readObject() == null) {
                    TestUtil.logTrace((String)"Pass: Read a null");
                } else {
                    TestUtil.logTrace((String)"Fail: null value not returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)"Error trying to read a null object");
                TestUtil.logTrace((String)("Error: unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            TestUtil.logTrace((String)"Sending response message");
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            TestUtil.logTrace((String)("Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown"));
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            TestUtil.logTrace((String)("Error: " + ee.getClass().getName() + " was thrown"));
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesT2  In MsgBeanMsgTest2::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesT2  In MsgBeanMsgTest2::remove()!!");
    }
}

