/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jacc.provider;

import com.sun.ts.tests.jacc.provider.TSLogRecord;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class TSLogger
extends Logger {
    private String contextId;
    private int levelValue = Level.INFO.intValue();
    private int offValue = Level.OFF.intValue();
    private Filter filter;
    private String name;
    private static TSLogger tsLogger = null;

    protected TSLogger(String name) {
        super(name, null);
        this.name = name;
        this.levelValue = Level.INFO.intValue();
    }

    public static synchronized TSLogger getTSLogger(String name) {
        TSLogger result = null;
        LogManager manager = LogManager.getLogManager();
        if (tsLogger != null) {
            if (tsLogger.getName().equals(name)) {
                result = tsLogger;
            }
        } else {
            result = new TSLogger(name);
            manager.addLogger(result);
        }
        return result;
    }

    @Override
    public void log(Level level, String msg) {
        this.log(level, msg, "jacc_ctx");
    }

    public void log(Level level, String msg, String contextId) {
        if (level.intValue() < this.levelValue || this.levelValue == this.offValue) {
            return;
        }
        TSLogRecord lr = new TSLogRecord(level, msg, contextId);
        String rbn = null;
        for (Logger target = this; target != null && (rbn = target.getResourceBundleName()) == null; target = target.getParent()) {
        }
        if (rbn != null) {
            lr.setResourceBundleName(rbn);
        }
        this.log(lr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(TSLogRecord record) {
        if (record.getLevel().intValue() < this.levelValue || this.levelValue == this.offValue) {
            return;
        }
        TSLogger tSLogger = this;
        synchronized (tSLogger) {
            if (this.filter != null && !this.filter.isLoggable(record)) {
                return;
            }
        }
        TSLogger logger = this;
        while (logger != null) {
            Handler[] targets = logger.getHandlers();
            if (targets != null) {
                for (int i = 0; i < targets.length; ++i) {
                    if (!(targets[i] instanceof FileHandler)) continue;
                    targets[i].publish(record);
                }
            }
            if (!logger.getUseParentHandlers()) break;
            logger = null;
        }
    }
}

