/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jacc.provider;

import com.sun.ts.lib.util.sec.security.provider.PolicyFile;
import com.sun.ts.tests.jacc.provider.TSLogger;
import com.sun.ts.tests.jacc.provider.TSXMLFormatter;
import jakarta.security.jacc.EJBMethodPermission;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import javax.security.auth.Subject;

public final class TSPolicy
extends Policy {
    private Policy policy = null;
    public static final String VENDOR_POLICY_PROVIDER = "vendor.jakarta.security.jacc.policy.provider";
    private static ClassLoader classLoader = null;
    public static boolean POLICY_INSTALLED = false;
    public static TSLogger logger = null;
    boolean firstInvocationForJACCPermissions = true;
    boolean multipleSetPolicyAllowed = false;
    String[] tokenArray = new String[2];
    String methodInterfaceName = null;
    String methodName = null;

    public TSPolicy() {
        TSPolicy.initializeTSLogger();
        if (!POLICY_INSTALLED) {
            this.loadPolicy();
        }
        if (this.firstInvocationForJACCPermissions) {
            this.jaccPermissionsEquals();
            this.jaccPermissionsHashCode();
            this.firstInvocationForJACCPermissions = false;
        }
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicy", "getPermissions");
        }
        return this.policy.getPermissions(codesource);
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicy", "getPermissions");
        }
        return this.policy.getPermissions(domain);
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        String contextId;
        if (permission instanceof WebResourcePermission && permission.getName().equals("/secured.jsp")) {
            logger.log(Level.INFO, "Calling policyContextKey1()");
            this.policyContextKey1();
        }
        if (permission instanceof EJBMethodPermission) {
            this.tokenArray = this.getTokensFromString(permission.getActions());
            this.methodName = this.tokenArray[0];
            this.methodInterfaceName = this.tokenArray[1];
            if (permission.getName().equals("jacc_providerContracts_JACCEntity") && this.methodName.equals("getArg1") && this.methodInterfaceName.equals("Remote")) {
                logger.log(Level.INFO, "Calling policyContextKey2()");
                logger.log(Level.INFO, "Calling policyContextKey3()");
                this.policyContextKey3();
            }
        }
        if ((contextId = PolicyContext.getContextID()) != null) {
            try {
                PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                PolicyConfiguration pc = pcf.getPolicyConfiguration();
                if (pc != null) {
                    logger.log(Level.INFO, "PolicyConfigurationFactory.getPolicyConfiguration() : PASSED");
                } else {
                    logger.log(Level.INFO, "PolicyConfigurationFactory.getPolicyConfiguration() : FAILED");
                }
                PolicyConfiguration pc2 = pcf.getPolicyConfiguration(contextId);
                if (pc2 == null || !pc.equals(pc2)) {
                    logger.log(Level.INFO, "PolicyConfigurationFactory.getPolicyConfiguration(String) : FAILED");
                } else {
                    logger.log(Level.INFO, "PolicyConfigurationFactory.getPolicyConfiguration(String) : PASSED");
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "PolicyConfigurationFactory.getPolicyConfiguration() : FAILED");
            }
        }
        return this.policy.implies(domain, permission);
    }

    @Override
    public void refresh() {
        this.policy.refresh();
        if (logger != null) {
            logger.log(Level.INFO, "TSPolicy.refresh() invoked");
        }
    }

    private void loadPolicy() {
        String javaPolicy = System.getProperty(VENDOR_POLICY_PROVIDER);
        if (javaPolicy == null) {
            logger.log(Level.FINE, "Loading Default Policy");
            this.policy = new PolicyFile();
            this.policy.refresh();
            POLICY_INSTALLED = true;
            logger.log(Level.INFO, "Default policy loaded");
        } else {
            try {
                logger.log(Level.FINE, "Loading Policy = " + javaPolicy);
                classLoader = TSPolicy.class.getClassLoader();
                Class<?> clazz = classLoader.loadClass(javaPolicy);
                Object obj = clazz.newInstance();
                if (!(obj instanceof Policy)) {
                    logger.log(Level.SEVERE, "vendor's policy is not of type java.security.Policy");
                    throw new RuntimeException(javaPolicy + "is not a type of java.security.Policy");
                }
                this.policy = (Policy)obj;
                logger.log(Level.INFO, "vendor's policy loaded!");
                POLICY_INSTALLED = true;
            }
            catch (ClassNotFoundException cnfe) {
                logger.log(Level.SEVERE, "vendor's Policy instantiation error", cnfe);
                throw new RuntimeException(cnfe);
            }
            catch (IllegalAccessException iae) {
                logger.log(Level.SEVERE, "vendor's Policy instantiation error", iae);
                throw new RuntimeException(iae);
            }
            catch (InstantiationException ie) {
                logger.log(Level.SEVERE, "vendor's Policy instantiation error", ie);
                throw new RuntimeException(ie);
            }
        }
    }

    private static void initializeTSLogger() {
        String logFileLocation = null;
        if (logger != null) {
            return;
        }
        try {
            logFileLocation = System.getProperty("log.file.location");
            if (logFileLocation != null) {
                logger = TSLogger.getTSLogger("jacc");
                boolean appendMode = true;
                File file = new File(logFileLocation + "/JACCLog.txt");
                if (file.exists()) {
                    file.delete();
                }
                System.out.println("XXXX:  in initializeTSLogger() - about to create JACCLog.txt");
                FileHandler fileHandler = new FileHandler(logFileLocation + "/JACCLog.txt", appendMode);
                fileHandler.setFormatter(new TSXMLFormatter());
                logger.addHandler(fileHandler);
                TSPolicy.setTSLogger(logger);
            } else {
                logger = TSLogger.getTSLogger("jacc");
                TSPolicy.setTSLogger(logger);
                logger.log(Level.SEVERE, "log.file.location not set: Using default logger");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("TSLogger Initialization failed", e);
        }
    }

    public static TSLogger getTSLogger() {
        return logger;
    }

    public static void setTSLogger(TSLogger lgr) {
        logger = lgr;
    }

    private void policyContextKey1() {
        try {
            HttpServletRequest ctx = (HttpServletRequest)PolicyContext.getContext((String)"jakarta.servlet.http.HttpServletRequest");
            logger.log(Level.INFO, "PolicyContext.getContext() test passed forjakarta.servlet.http.HttpServletRequest");
            logger.log(Level.INFO, "PolicyContextKey1: PASSED");
        }
        catch (ClassCastException e) {
            logger.log(Level.INFO, "PolicyContext.getContext()returned incorrect value for key jakarta.servlet.http.HttpServletRequest");
            logger.log(Level.SEVERE, "PolicyContextKey1: FAILED");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PolicyContextKey1: FAILED");
        }
    }

    private void policyContextKey3() {
        try {
            Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            logger.log(Level.INFO, "PolicyContext.getContext() test passed forjavax.security.auth.Subject.container");
            logger.log(Level.INFO, "PolicyContextKey3: PASSED");
        }
        catch (ClassCastException e) {
            logger.log(Level.INFO, "PolicyContext.getContext()returned incorrect value for key javax.security.auth.Subject.container");
            logger.log(Level.INFO, "PolicyContextKey3: FAILED");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PolicyContextKey3: FAILED");
        }
    }

    public String[] getTokensFromString(String actions) {
        String[] array = new String[2];
        StringTokenizer strtoken = new StringTokenizer(actions, ",");
        if (actions.indexOf(",") > 0) {
            array[0] = strtoken.nextToken();
            if (strtoken.hasMoreTokens()) {
                array[1] = strtoken.nextToken();
            }
        }
        return array;
    }

    private void jaccPermissionsEquals() {
        boolean result;
        try {
            logger.log(Level.FINE, "Checking EJBMethodPermission.equals()");
            EJBMethodPermission emp = new EJBMethodPermission("DummyEJB", "dummyMethod,Home,String");
            result = emp.equals((Object)emp);
            if (result) {
                logger.log(Level.INFO, "EJBMethodPermission.equals() : PASSED");
            } else {
                logger.log(Level.INFO, "EJBMethodPermission.equals() : FAILED");
                logger.log(Level.INFO, "Calling EJBMethodPermission.equals() onto itself returned false");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "EJBMethodPermission.equals() : FAILED");
        }
        try {
            EJBRoleRefPermission errp = new EJBRoleRefPermission("DummyEJB", "dummyRole");
            result = errp.equals((Object)errp);
            if (result) {
                logger.log(Level.INFO, "EJBRoleRefPermission.equals() : PASSED");
            } else {
                logger.log(Level.INFO, "EJBRoleRefPermission.equals() : FAILED");
                logger.log(Level.INFO, "Calling EJBRoleRefPermission.equals() onto itself returned false");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "EJBRoleRefPermission.equals() : FAILED");
        }
        try {
            WebResourcePermission wrp = new WebResourcePermission("/dummyEntry", "POST");
            result = wrp.equals((Object)wrp);
            if (result) {
                logger.log(Level.INFO, "WebResourcePermission.equals() : PASSED");
            } else {
                logger.log(Level.INFO, "WebResourcePermission.equals() : FAILED");
                logger.log(Level.INFO, "Calling WebResourcePermission.equals() onto itself returned false");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WebResourcePermission.equals() : FAILED");
        }
        try {
            WebRoleRefPermission wrrp = new WebRoleRefPermission("dummyReosource", "dummyRole");
            result = wrrp.equals((Object)wrrp);
            if (result) {
                logger.log(Level.INFO, "WebRoleRefPermission.equals() : PASSED");
            } else {
                logger.log(Level.INFO, "WebRoleRefPermission.equals() : FAILED");
                logger.log(Level.INFO, "Calling WebRoleRefPermission.equals() onto itself returned false");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WebRoleRefPermission.equals() : FAILED");
        }
        try {
            WebUserDataPermission wudp = new WebUserDataPermission("/dummyResource.jsp", "GET,POST:CONFIDENTIAL");
            result = wudp.equals((Object)wudp);
            if (result) {
                logger.log(Level.INFO, "WebUserDataPermission.equals() : PASSED");
            } else {
                logger.log(Level.INFO, "WebUserDataPermission.equals() : FAILED");
                logger.log(Level.INFO, "Calling WebUserDataPermission.equals() onto itself returned false");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WebUserDataPermission.equals() : FAILED");
        }
    }

    private void jaccPermissionsHashCode() {
        try {
            EJBMethodPermission emp = new EJBMethodPermission("DummyEJB", "dummyMethod,Home,String");
            int hashCode1 = emp.hashCode();
            int hashCode2 = emp.hashCode();
            if (hashCode1 == hashCode2) {
                logger.log(Level.INFO, "EJBMethodPermission.hashCode() : PASSED");
            } else {
                logger.log(Level.INFO, "EJBMethodPermission.hashCode() : FAILED");
                logger.log(Level.INFO, "EJBMethodPermission.hashCode() returned different values within the same application.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "EJBMethodPermission.hashCode() : FAILED");
        }
        try {
            EJBRoleRefPermission errp = new EJBRoleRefPermission("DummyEJB", "dummyRole");
            int hashCode3 = errp.hashCode();
            int hashCode4 = errp.hashCode();
            if (hashCode3 == hashCode4) {
                logger.log(Level.INFO, "EJBRoleRefPermission.hashCode() : PASSED");
            } else {
                logger.log(Level.INFO, "EJBRoleRefPermission.hashCode() : FAILED");
                logger.log(Level.INFO, "EJBRoleRefPermission.hashCode() returned different values within the same application.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "EJBRoleRefPermission.hashCode() : FAILED");
        }
        try {
            WebResourcePermission wrp = new WebResourcePermission("/dummyEntry", "POST");
            int hashCode5 = wrp.hashCode();
            int hashCode6 = wrp.hashCode();
            if (hashCode5 == hashCode6) {
                logger.log(Level.INFO, "WebResourcePermission.hashCode() : PASSED");
            } else {
                logger.log(Level.INFO, "WebResourcePermission.hashCode() : FAILED");
                logger.log(Level.INFO, "WebResourcePermission.hashCode() returned different values within the same application.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WebResourcePermission.hashCode() : FAILED");
        }
        try {
            WebRoleRefPermission wrrp = new WebRoleRefPermission("dummyReosource", "dummyRole");
            int hashCode7 = wrrp.hashCode();
            int hashCode8 = wrrp.hashCode();
            if (hashCode7 == hashCode8) {
                logger.log(Level.INFO, "WebRoleRefPermission.hashCode() : PASSED");
            } else {
                logger.log(Level.INFO, "WebRoleRefPermission.hashCode() : FAILED");
                logger.log(Level.INFO, "WebRoleRefPermission.hashCode() returned different values within the same application.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WebRoleRefPermission.hashCode() : FAILED");
        }
        try {
            WebUserDataPermission wudp = new WebUserDataPermission("/dummyResource.jsp", "GET,POST:CONFIDENTIAL");
            int hashCode9 = wudp.hashCode();
            int hashCode10 = wudp.hashCode();
            if (hashCode9 == hashCode10) {
                logger.log(Level.INFO, "WebUserDataPermission.hashCode() : PASSED");
            } else {
                logger.log(Level.INFO, "WebUserDataPermission.hashCode() : FAILED");
                logger.log(Level.INFO, "WebUserDataPermission.hashCode() returned different values within the same application.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WebUserDataPermission.hashCode() : FAILED");
        }
    }
}

