/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jacc.web.principal2role;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.BASE64Encoder;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private Properties props = null;
    private String pageSec = null;
    private String pageSec1 = null;
    private String ctxroot = "/jacc_web_principal2role_first_module_web";
    private String ctxroot1 = "/jacc_web_principal2role_second_module_web";
    private String pageJspSec = this.ctxroot + "/first_resource.jsp";
    private String pageJspSec1 = this.ctxroot1 + "/second_resource.jsp";
    private String hostname = null;
    private int portnum = 0;
    private String unauthusername = null;
    private String unauthpassword = null;
    private String username = null;
    private String password = null;
    private TSNamingContext nctx = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.hostname = p.getProperty("webServerHost");
            this.portnum = Integer.parseInt(p.getProperty("webServerPort"));
            this.username = p.getProperty("user");
            this.password = p.getProperty("password");
            this.unauthusername = p.getProperty("authuser");
            this.unauthpassword = p.getProperty("authpassword");
            this.pageSec = this.pageJspSec;
            this.pageSec1 = this.pageJspSec1;
            this.nctx = new TSNamingContext();
        }
        catch (Exception e) {
            this.logErr("Error in setup: ", e);
        }
    }

    public void PrincipalToRoleMapping() throws EETest.Fault {
        TSURL ctsurl = new TSURL();
        String firstURLstr = ctsurl.getURLString("http", this.hostname, this.portnum, this.pageSec);
        String secondURLstr = ctsurl.getURLString("http", this.hostname, this.portnum, this.pageSec1);
        try {
            URL firstURL = new URL(firstURLstr);
            URL secondURL = new URL(secondURLstr);
            TestUtil.logMsg((String)"Verifying access rights");
            TestUtil.logMsg((String)"***********************");
            TestUtil.logMsg((String)("Authorized user " + this.username + " invoking " + firstURL));
            if (!this.isAccessible(firstURL, this.username, this.password)) {
                throw new EETest.Fault("Authorized user acesss denied");
            }
            TestUtil.logMsg((String)"Access allowed");
            TestUtil.logMsg((String)("Unauthorized user " + this.unauthusername + " invoking " + firstURL));
            if (this.isAccessible(firstURL, this.unauthusername, this.unauthpassword)) {
                throw new EETest.Fault("Unauthorized user access allowed");
            }
            TestUtil.logMsg((String)"Access denied");
            TestUtil.logMsg((String)("Authorized user " + this.username + " invoking " + secondURL));
            if (!this.isAccessible(secondURL, this.username, this.password)) {
                throw new EETest.Fault("Authorized user acesss denied");
            }
            TestUtil.logMsg((String)"Access allowed");
            TestUtil.logMsg((String)("Unauthorized user " + this.unauthusername + " invoking " + secondURL));
            if (this.isAccessible(secondURL, this.unauthusername, this.unauthpassword)) {
                throw new EETest.Fault("Unauthorized user access allowed");
            }
            TestUtil.logMsg((String)"Access denied");
            TestUtil.logMsg((String)"Same PrincipalToRoleMapping applied for both web modules");
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"Test PrincipalToRoleMapping failed");
            e.printStackTrace();
            throw new EETest.Fault("Test PrincipalToRoleMapping failed");
        }
    }

    public void cleanup() throws EETest.Fault {
    }

    public boolean isAccessible(URL url, String user, String pwd) {
        try {
            String line;
            String authData = user + ":" + pwd;
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            URLConnection urlConn = url.openConnection();
            urlConn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            InputStream content = urlConn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(content));
            Object output = "";
            while ((line = in.readLine()) != null) {
                output = (String)output + line;
            }
            String stringToSearch = user;
            return ((String)output).indexOf(stringToSearch) != -1;
        }
        catch (Exception e) {
            return false;
        }
    }
}

