/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.tx.entity.pm.bm.TxR_Exceptions;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.tx.txEPMbean.AppException;
import com.sun.ts.tests.ejb.ee.tx.txEPMbean.TxEPMBean;
import com.sun.ts.tests.ejb.ee.tx.txEPMbean.TxEPMBeanHome;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.ObjectNotFoundException;
import jakarta.ejb.RemoveException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionRolledbackException;
import jakarta.transaction.UserTransaction;
import java.util.Properties;

public class TestBeanEJB
implements SessionBean {
    private Properties testProps = new Properties();
    private TSNamingContext jctx = null;
    private SessionContext sctx = null;
    private static final String txEPMBeanRequired = "java:comp/env/ejb/TxRequired";
    private TxEPMBeanHome beanHome = null;
    private String tName1 = null;

    public void ejbCreate() throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
    }

    public void ejbCreate(Properties p) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate w/Properties");
        try {
            TestUtil.logMsg((String)"Getting Naming Context");
            this.jctx = new TSNamingContext();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Create exception: " + e.getMessage()), (Throwable)e);
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public boolean test1() {
        TestUtil.logMsg((String)"test1");
        TestUtil.logMsg((String)"Cause an AppException");
        TxEPMBean beanref = null;
        boolean testResult = false;
        UserTransaction ut = null;
        String brand1 = "First brand";
        String brand2 = "Second brand";
        try {
            TestUtil.logTrace((String)"Looking up the TxEPMBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEPMBeanHome)this.jctx.lookup(txEPMBeanRequired, TxEPMBeanHome.class);
            TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
            beanref = this.beanHome.create(this.tName1, new Integer(1), brand1, 1.0f, this.testProps);
            TestUtil.logTrace((String)"Getting the UserTransaction interface");
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Update brand name and catch AppException");
            ut.begin();
            try {
                beanref.updateBrandName(brand2, -1);
                TestUtil.logTrace((String)"Did not receive AppException as expected");
            }
            catch (AppException ae) {
                TestUtil.logTrace((String)"AppException received as expected.");
                testResult = true;
            }
            ut.commit();
            TestUtil.logTrace((String)"Transaction commited");
            boolean ae = testResult;
            return ae;
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (beanref != null) {
                    beanref.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean test2() {
        TestUtil.logMsg((String)"test2");
        TestUtil.logMsg((String)"Cause a SystemException");
        TxEPMBean beanref = null;
        boolean t2 = false;
        boolean t1 = false;
        boolean testResult = false;
        UserTransaction ut = null;
        String brand1 = "First brand";
        String brand2 = "Second brand";
        Object key = null;
        try {
            TestUtil.logTrace((String)"Looking up the TxEPMBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEPMBeanHome)this.jctx.lookup(txEPMBeanRequired, TxEPMBeanHome.class);
            TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
            beanref = this.beanHome.create(this.tName1, new Integer(1), brand1, 1.0f, this.testProps);
            TestUtil.logTrace((String)"Getting the UserTransaction interface");
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Update brand name and catch TransactionRolledbackException");
            ut.begin();
            try {
                beanref.updateBrandName(brand2, -3);
                TestUtil.logTrace((String)"Did not receive TransactionRolledbackException as expected");
            }
            catch (TransactionRolledbackException re) {
                TestUtil.logTrace((String)"TransactionRolledbackException received as expected.");
                t1 = true;
            }
            TestUtil.logTrace((String)"Check that the transaction was marked for rollback");
            int txStatus = ut.getStatus();
            if (txStatus == 1) {
                TestUtil.logTrace((String)"Transaction is marked for rollback");
                TestUtil.printTransactionStatus((int)txStatus);
                t2 = true;
            } else {
                TestUtil.logTrace((String)"Transaction not marked for rollback as expected");
            }
            TestUtil.logTrace((String)"Starting rollback");
            ut.rollback();
            TestUtil.logTrace((String)"Rollback finished");
            if (t1 && t2) {
                testResult = true;
            }
            boolean bl = testResult;
            return bl;
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (beanref != null) {
                    beanref.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test3() {
        boolean testResult;
        block27: {
            TestUtil.logMsg((String)"test3");
            UserTransaction ut = null;
            TxEPMBean beanref3 = null;
            TxEPMBean beanref2 = null;
            TxEPMBean beanref1 = null;
            testResult = false;
            String brand1 = "First brand";
            String brand2 = "Second brand";
            Integer key1 = new Integer(1);
            Integer key2 = new Integer(2);
            try {
                TestUtil.logTrace((String)"Looking up the TxEPMBean Home interface of java:comp/env/ejb/TxRequired");
                this.beanHome = (TxEPMBeanHome)this.jctx.lookup(txEPMBeanRequired, TxEPMBeanHome.class);
                TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
                beanref1 = this.beanHome.create(this.tName1, key1, brand1, 1.0f, this.testProps);
                ut = this.sctx.getUserTransaction();
                TestUtil.logTrace((String)"Starting User Transaction");
                ut.begin();
                try {
                    beanref2 = this.beanHome.create(this.tName1, key1, brand2, 1.0f, this.testProps);
                }
                catch (Exception e1) {
                    TestUtil.logMsg((String)"Expected exception caught trying to create bean with same PK");
                    testResult = true;
                }
                TestUtil.logTrace((String)"Starting commit");
                ut.commit();
                TestUtil.logTrace((String)"Commit finished");
            }
            catch (Exception e) {
                testResult = true;
                try {
                    if (ut.getStatus() != 6) {
                        ut.rollback();
                    }
                }
                catch (SystemException se) {
                    TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
                }
                try {
                    beanref3 = this.beanHome.findByPrimaryKey(key1);
                    String result = beanref3.getBrandName();
                    if (!brand1.equals(result)) {
                        TestUtil.logMsg((String)("Wrong brand name:  Expected:  " + brand1 + " Received: " + result));
                        testResult = false;
                        break block27;
                    }
                    testResult = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Exception caught checking test result", (Throwable)ex);
                    TestUtil.printStackTrace((Throwable)ex);
                }
            }
            finally {
                try {
                    if (beanref1 != null) {
                        beanref1.remove();
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Exception removing beanref1: " + e.getMessage()), (Throwable)e);
                }
                try {
                    if (beanref2 != null) {
                        beanref2.remove();
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Expected exception removing beanref2 beanref2 should not exist");
                }
            }
        }
        return testResult;
    }

    public boolean test5() {
        TestUtil.logMsg((String)"test5");
        TestUtil.logMsg((String)"Cause an ObjectNotFoundException");
        Object ut = null;
        TxEPMBean beanref1 = null;
        boolean testResult = false;
        Integer badkey = new Integer(8);
        try {
            TestUtil.logTrace((String)"Looking up the TxEPMBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEPMBeanHome)this.jctx.lookup(txEPMBeanRequired, TxEPMBeanHome.class);
            try {
                TestUtil.logTrace((String)"Before bad findByPrimaryKey!");
                beanref1 = this.beanHome.findByPrimaryKey(badkey);
                TestUtil.logTrace((String)"Did not recieve expected ObjectNotFoundException");
            }
            catch (ObjectNotFoundException onf) {
                TestUtil.logTrace((String)"Received Expected ObjectNotFoundException");
                testResult = true;
            }
            return testResult;
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test6() {
        TestUtil.logMsg((String)"test6");
        TestUtil.logMsg((String)"Cause a RemoveException");
        UserTransaction ut = null;
        TxEPMBean beanref = null;
        boolean testResult = false;
        String brand1 = "First brand";
        Integer key1 = new Integer(1);
        try {
            TestUtil.logTrace((String)"Looking up the TxEPMBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEPMBeanHome)this.jctx.lookup(txEPMBeanRequired, TxEPMBeanHome.class);
            TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
            beanref = this.beanHome.create(this.tName1, key1, brand1, 1.0f, this.testProps);
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Starting User Transaction");
            ut.begin();
            TestUtil.logTrace((String)"Forcing a RemoveException");
            beanref.throwRemoveException();
            TestUtil.logTrace((String)"Did not receive expected RemoveException");
        }
        catch (RemoveException re) {
            testResult = true;
            TestUtil.logTrace((String)"RemoveException received as expected");
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        try {
            TestUtil.logTrace((String)"Starting rollback");
            ut.rollback();
            TestUtil.logTrace((String)"Rollback finished");
        }
        catch (Exception er) {
            TestUtil.logErr((String)("Exception caught while trying to rollback" + er.getMessage()), (Throwable)er);
        }
        finally {
            try {
                if (beanref != null) {
                    beanref.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref: " + e.getMessage()), (Throwable)e);
            }
        }
        return testResult;
    }

    public boolean test7() {
        TestUtil.logMsg((String)"test7");
        TestUtil.logMsg((String)"Cause an EJBException");
        TxEPMBean beanref = null;
        boolean t2 = false;
        boolean t1 = false;
        boolean testResult = false;
        UserTransaction ut = null;
        String brand1 = "First brand";
        String brand2 = "Second brand";
        Object key = null;
        try {
            TestUtil.logTrace((String)"Looking up the TxEPMBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEPMBeanHome)this.jctx.lookup(txEPMBeanRequired, TxEPMBeanHome.class);
            TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
            beanref = this.beanHome.create(this.tName1, new Integer(1), brand1, 1.0f, this.testProps);
            TestUtil.logTrace((String)"Getting the UserTransaction interface");
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Update brand name and catch TransactionRolledbackException");
            ut.begin();
            try {
                beanref.updateBrandName(brand2, -5);
                TestUtil.logTrace((String)"Did not receive TransactionRolledbackException as expected");
            }
            catch (TransactionRolledbackException re) {
                TestUtil.logTrace((String)"TransactionRolledbackException received as expected.");
                t1 = true;
            }
            TestUtil.logTrace((String)"Check that the transaction was marked for rollback");
            int txStatus = ut.getStatus();
            if (txStatus == 1) {
                TestUtil.logTrace((String)"Transaction is marked for rollback");
                TestUtil.printTransactionStatus((int)txStatus);
                t2 = true;
            } else {
                TestUtil.logTrace((String)"Did not receive transaction marked for rollback as expected");
            }
            TestUtil.logTrace((String)"Starting rollback");
            ut.rollback();
            TestUtil.logTrace((String)"Rollback finished");
            if (t1 && t2) {
                testResult = true;
            }
            boolean bl = testResult;
            return bl;
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (beanref != null) {
                    beanref.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean test8() {
        TestUtil.logMsg((String)"test8");
        TestUtil.logMsg((String)"Cause an Error");
        TxEPMBean beanref = null;
        boolean t2 = false;
        boolean t1 = false;
        boolean testResult = false;
        UserTransaction ut = null;
        String brand1 = "First brand";
        String brand2 = "Second brand";
        Object key = null;
        try {
            TestUtil.logTrace((String)"Looking up the TxEPMBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEPMBeanHome)this.jctx.lookup(txEPMBeanRequired, TxEPMBeanHome.class);
            TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
            beanref = this.beanHome.create(this.tName1, new Integer(1), brand1, 1.0f, this.testProps);
            TestUtil.logTrace((String)"Getting the UserTransaction interface");
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Update brand name and catch TransactionRolledbackException");
            ut.begin();
            try {
                beanref.updateBrandName(brand2, -6);
                TestUtil.logTrace((String)"Did not receive TransactionRolledbackException as expected");
            }
            catch (TransactionRolledbackException re) {
                TestUtil.logTrace((String)"TransactionRolledbackException received as expected.");
                t1 = true;
            }
            TestUtil.logTrace((String)"Check that the transaction was marked for rollback");
            int txStatus = ut.getStatus();
            if (txStatus == 1) {
                TestUtil.logTrace((String)"Transaction is marked for rollback");
                TestUtil.printTransactionStatus((int)txStatus);
                t2 = true;
            } else {
                TestUtil.logTrace((String)"Did not receive transaction marked for rollback as expected");
            }
            TestUtil.logTrace((String)"Starting rollback");
            ut.rollback();
            TestUtil.logTrace((String)"Rollback finished");
            if (t1 && t2) {
                testResult = true;
            }
            boolean bl = testResult;
            return bl;
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (beanref != null) {
                    beanref.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        this.testProps = p;
        try {
            TestUtil.init((Properties)p);
            this.tName1 = TestUtil.getTableName((String)TestUtil.getProperty((String)"TxEBean_Delete"));
            TestUtil.logTrace((String)("tName1: " + this.tName1));
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.logErr((String)("RemoteLoggingInitException: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

