/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.override.entity;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.override.entity.NameOnlyInXML;
import com.sun.ts.tests.jpa.core.override.entity.NoEntityAnnotation;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final Long ID = 9L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception:test failed ", (Throwable)e);
        }
    }

    public void testNameOnlyInXML() throws EETest.Fault {
        block6: {
            this.getEntityTransaction().begin();
            NameOnlyInXML entity = new NameOnlyInXML();
            entity.setId(ID);
            this.getEntityManager().persist((Object)entity);
            this.getEntityManager().flush();
            try {
                List result = this.getEntityManager().createNamedQuery("findAll").getResultList();
                TestUtil.logTrace((String)("Result of the entity is " + result.size()));
                if (result.size() == 1) {
                    TestUtil.logTrace((String)"Test Passed");
                    break block6;
                }
                throw new EETest.Fault("Expected the size to be 1  but it is -" + result.size());
            }
            catch (Exception e) {
                throw new EETest.Fault("Exception thrown while testing testNameOnlyInXML" + e);
            }
            finally {
                this.getEntityManager().remove((Object)entity);
                this.getEntityTransaction().commit();
            }
        }
    }

    public void testNameOnlyInAnnotation() throws EETest.Fault {
        List result = this.getEntityManager().createQuery("SELECT m FROM NAMEONLYINANNOTATION m").getResultList();
        if (result.size() != 0) {
            throw new EETest.Fault("Expected the size to be 0  but it is -" + result.size());
        }
        TestUtil.logTrace((String)"Test Passed");
    }

    public void testNameOverride() throws EETest.Fault {
        List result = this.getEntityManager().createQuery("SELECT n FROM NAMEOVERRIDE n").getResultList();
        if (result.size() != 0) {
            throw new EETest.Fault("Expected the size to be 0  but it is -" + result.size());
        }
        TestUtil.logTrace((String)"Test Passed");
    }

    public void testNoEntityAnnotation() throws EETest.Fault {
        block6: {
            this.getEntityTransaction().begin();
            NoEntityAnnotation entity = new NoEntityAnnotation();
            entity.setId(ID);
            this.getEntityManager().persist((Object)entity);
            this.getEntityManager().flush();
            try {
                List result = this.getEntityManager().createNamedQuery("findAllNoEntityAnnotation").getResultList();
                TestUtil.logTrace((String)("Result of the entity is " + result.size()));
                if (result.size() == 1) {
                    TestUtil.logTrace((String)"Test Passed");
                    break block6;
                }
                throw new EETest.Fault("Expected the size to be 1  but it is -" + result.size());
            }
            catch (Exception e) {
                throw new EETest.Fault("Exception thrown while testing testNoEntityAnnotation" + e);
            }
            finally {
                this.getEntityManager().remove((Object)entity);
                this.getEntityTransaction().commit();
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NAMEONLYINXML").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYANNOTATION").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

